/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.AnnotationConfiguration;
import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.TypeScope;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class TypeContext {
    private final TypeResolver typeResolver = new TypeResolver();
    private final MemberResolver memberResolver = new MemberResolver(this.typeResolver);
    private final AnnotationConfiguration annotationConfig;

    public TypeContext(AnnotationConfiguration annotationConfig) {
        this.annotationConfig = annotationConfig;
    }

    public final ResolvedType resolve(Type type, Type ... typeParameters) {
        return this.typeResolver.resolve(type, typeParameters);
    }

    public final ResolvedType resolveSubtype(ResolvedType supertype, Class<?> subtype) {
        return this.typeResolver.resolveSubtype(supertype, subtype);
    }

    public final ResolvedTypeWithMembers resolveWithMembers(ResolvedType resolvedType) {
        return this.memberResolver.resolve(resolvedType, this.annotationConfig, null);
    }

    public FieldScope createFieldScope(ResolvedField field, ResolvedTypeWithMembers declaringTypeMembers) {
        return new FieldScope(field, declaringTypeMembers, this);
    }

    public MethodScope createMethodScope(ResolvedMethod method, ResolvedTypeWithMembers declaringTypeMembers) {
        return new MethodScope(method, declaringTypeMembers, this);
    }

    public TypeScope createTypeScope(ResolvedType type) {
        return new TypeScope(type, this);
    }

    public ResolvedType getTypeParameterFor(ResolvedType type, Class<?> erasedSuperType, int parameterIndex) {
        List typeParameters = type.typeParametersFor(erasedSuperType);
        if (typeParameters == null || !typeParameters.isEmpty() && typeParameters.size() <= parameterIndex || typeParameters.isEmpty() && erasedSuperType.getTypeParameters().length <= parameterIndex) {
            return null;
        }
        if (typeParameters.isEmpty()) {
            return this.resolve((Type)((Object)Object.class), new Type[0]);
        }
        return (ResolvedType)typeParameters.get(parameterIndex);
    }

    public boolean isContainerType(ResolvedType type) {
        return type.isArray() || type.isInstanceOf(Collection.class);
    }

    public ResolvedType getContainerItemType(ResolvedType containerType) {
        ResolvedType itemType = containerType.getArrayElementType();
        if (itemType == null && this.isContainerType(containerType)) {
            itemType = this.getTypeParameterFor(containerType, Iterable.class, 0);
        }
        return itemType;
    }

    public final String getSimpleTypeDescription(ResolvedType type) {
        return this.getTypeDescription(type, true);
    }

    public final String getFullTypeDescription(ResolvedType type) {
        return this.getTypeDescription(type, false);
    }

    private String getTypeDescription(ResolvedType type, boolean simpleClassNames) {
        Class erasedType = type.getErasedType();
        String result = simpleClassNames ? erasedType.getSimpleName() : erasedType.getTypeName();
        List typeParameters = type.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            result = result + typeParameters.stream().map(parameterType -> this.getTypeDescription((ResolvedType)parameterType, simpleClassNames)).collect(Collectors.joining(", ", "<", ">"));
        }
        return result;
    }

    public String getSchemaDefinitionName(ResolvedType type) {
        return this.getSimpleTypeDescription(type);
    }

    public String getMethodPropertyArgumentTypeDescription(ResolvedType type) {
        return this.getSimpleTypeDescription(type);
    }
}

