/*
 * Decompiled with CFR 0.152.
 */
package com.globalload;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.util.logging.Logger;

public class NativeUtils {
    public static final String NATIVE_FOLDER_PATH_PREFIX = "nativeutils";
    private static final Logger LOGGER = Logger.getLogger(NativeUtils.class.getName());
    private static final int MIN_PREFIX_LENGTH = 3;
    private static File temporaryDir;

    private NativeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path) throws IOException {
        String filename;
        if (path == null || !path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
        if (filename == null || filename.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        if (temporaryDir == null) {
            temporaryDir = NativeUtils.createTempDirectory();
            temporaryDir.deleteOnExit();
        }
        File temp = new File(temporaryDir, filename);
        try (InputStream is = NativeUtils.class.getResourceAsStream(path);){
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            boolean status = temp.delete();
            if (status) {
                LOGGER.info("Deleted file : " + temp.getAbsolutePath());
            }
            throw e;
        }
        catch (NullPointerException e) {
            boolean status = temp.delete();
            if (status) {
                LOGGER.info("Deleted file : " + temp.getAbsolutePath());
            }
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        try {
            System.load(temp.getAbsolutePath());
        }
        finally {
            if (NativeUtils.isPosixCompliant()) {
                boolean status = temp.delete();
                if (status) {
                    LOGGER.info("Deleted file : " + temp.getAbsolutePath());
                }
            } else {
                temp.deleteOnExit();
            }
        }
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    private static File createTempDirectory() throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File generatedDir = new File(tempDir, NATIVE_FOLDER_PATH_PREFIX + System.nanoTime());
        if (!generatedDir.mkdir()) {
            throw new IOException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }
}

