/*
 * Decompiled with CFR 0.152.
 */
package com.github.villadora.semver;

import com.github.villadora.semver.regexp.VersionRegExps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;

class Build
implements Serializable {
    private static final long serialVersionUID = 4639504973400479946L;
    private String[] build;

    public static boolean valid(String build) {
        if (build == null) {
            return false;
        }
        return VersionRegExps.BUILD_REG.matcher(build).matches();
    }

    public Build() {
        this.setBuild(null);
    }

    public Build(String ... build) {
        this.setBuild(build);
    }

    public String[] getBuild() {
        return this.build;
    }

    public void setBuild(String[] build) {
        if (build == null) {
            this.build = new String[0];
        } else {
            LinkedList<String> bds = new LinkedList<String>();
            for (String bd : build) {
                if (bd == null || bd.matches("\\s*")) continue;
                if (!bd.matches(VersionRegExps.BUILD_REG.pattern())) {
                    throw new IllegalArgumentException("build format is invalid: " + bd);
                }
                bds.addAll(Arrays.asList(bd.split("\\.")));
            }
            this.build = bds.toArray(new String[0]);
        }
    }

    public String toString() {
        if (this.build.length > 0) {
            StringBuilder bb = new StringBuilder(this.build[0]);
            for (int i = 1; i < this.build.length; ++i) {
                bb.append(".");
                bb.append(this.build[i]);
            }
            return bb.toString();
        }
        return "";
    }

    public int hashCode() {
        return Arrays.hashCode(this.build);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (that instanceof Build) {
            return Arrays.equals(this.build, ((Build)that).build);
        }
        return false;
    }
}

