/*
 * Decompiled with CFR 0.152.
 */
package com.github.villadora.semver;

import com.github.villadora.semver.regexp.VersionRegExps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;

class PreRelease
implements Comparable<PreRelease>,
Serializable {
    private static final long serialVersionUID = 8495065215362333955L;
    private String[] prerelease;

    public static boolean valid(String prerelease) {
        if (prerelease == null) {
            return false;
        }
        return VersionRegExps.PRERELEASE_REG.matcher(prerelease).matches();
    }

    public PreRelease() {
        this.setPrerelease(null);
    }

    public PreRelease(String ... prerelease) {
        this.setPrerelease(prerelease);
    }

    public String[] getPrerelease() {
        return this.prerelease;
    }

    public void setPrerelease(String[] prerelease) {
        if (prerelease == null) {
            this.prerelease = new String[0];
        } else {
            LinkedList<String> pres = new LinkedList<String>();
            for (String pre : prerelease) {
                if (pre == null || pre.matches("\\s*")) continue;
                if (!pre.matches(VersionRegExps.PRERELEASE_REG.pattern())) {
                    throw new IllegalArgumentException("prerelease format is invalid: " + pre);
                }
                pres.addAll(Arrays.asList(pre.split("\\.")));
            }
            this.prerelease = pres.toArray(new String[0]);
        }
    }

    public String toString() {
        if (this.prerelease.length > 0) {
            StringBuilder pb = new StringBuilder(this.prerelease[0]);
            for (int i = 1; i < this.prerelease.length; ++i) {
                pb.append(".");
                pb.append(this.prerelease[i]);
            }
            return pb.toString();
        }
        return "";
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        return that instanceof PreRelease ? this.compareTo((PreRelease)that) == 0 : false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.prerelease);
    }

    @Override
    public int compareTo(PreRelease o) {
        if (this.prerelease == null) {
            if (o.prerelease == null) {
                return 0;
            }
            return 1;
        }
        if (o.prerelease == null) {
            return -1;
        }
        if (this.prerelease.length > 0 && o.prerelease.length == 0) {
            return -1;
        }
        if (this.prerelease.length == 0 && o.prerelease.length > 0) {
            return 1;
        }
        if (this.prerelease.length == 0 && o.prerelease.length == 0) {
            return 0;
        }
        int lenA = this.prerelease.length;
        int lenB = o.prerelease.length;
        for (int i = 0; i < lenA && i < lenB; ++i) {
            String preA = this.prerelease[i];
            String preB = o.prerelease[i];
            if (preA == null && preB == null) continue;
            if (preB == null) {
                return 1;
            }
            if (preA == null) {
                return -1;
            }
            if (preA.matches("0|[1-9]\\d*")) {
                if (!preB.matches("0|[1-9]\\d*")) {
                    return -1;
                }
                return Integer.parseInt(preA) - Integer.parseInt(preB);
            }
            if (preB.matches("0|[1-9]\\d*")) {
                return 1;
            }
            int cmp = preA.compareTo(preB);
            if (cmp == 0) continue;
            return cmp;
        }
        if (lenA == lenB) {
            return 0;
        }
        if (lenA < lenB) {
            return -1;
        }
        if (lenA > lenB) {
            return 1;
        }
        return 0;
    }
}

