/*
 * Decompiled with CFR 0.152.
 */
package com.github.villadora.semver;

import com.github.villadora.semver.Version;
import com.github.villadora.semver.ranges.Range;

public class SemVer {
    public static boolean valid(String version) {
        return Version.valid(version);
    }

    public static Version version(String version) {
        return new Version(version);
    }

    public static int compare(String versionA, String versionB) {
        SemVer.checkVersionArg(versionA, versionB);
        return new Version(versionA).compareTo(new Version(versionB));
    }

    public static boolean eq(String versionA, String versionB) {
        SemVer.checkVersionArg(versionA, versionB);
        return new Version(versionA).compareTo(new Version(versionB)) == 0;
    }

    public static boolean neq(String versionA, String versionB) {
        return !SemVer.eq(versionA, versionB);
    }

    public static boolean gt(String versionA, String versionB) {
        SemVer.checkVersionArg(versionA, versionB);
        return new Version(versionA).compareTo(new Version(versionB)) > 0;
    }

    public static boolean gte(String versionA, String versionB) {
        SemVer.checkVersionArg(versionA, versionB);
        return new Version(versionA).compareTo(new Version(versionB)) >= 0;
    }

    public static boolean lt(String versionA, String versionB) {
        SemVer.checkVersionArg(versionA, versionB);
        return new Version(versionA).compareTo(new Version(versionB)) < 0;
    }

    public static boolean lte(String versionA, String versionB) {
        SemVer.checkVersionArg(versionA, versionB);
        return new Version(versionA).compareTo(new Version(versionB)) <= 0;
    }

    public static boolean rangeValid(String range) {
        return Range.valid(range);
    }

    public static Range range(String range) {
        return Range.valueOf(range);
    }

    public static boolean satisfies(String version, String range) {
        return SemVer.satisfies(new Version(version), Range.valueOf(range));
    }

    public static boolean satisfies(Version version, Range range) {
        return range.satisfies(version);
    }

    private static void checkVersionArg(String ... versions) {
        for (String version : versions) {
            if (Version.valid(version)) continue;
            throw new IllegalArgumentException("Invalid version: " + version);
        }
    }
}

