/*
 * Decompiled with CFR 0.152.
 */
package com.github.villadora.semver.parser;

import com.github.villadora.semver.Version;
import com.github.villadora.semver.ranges.Range;
import com.github.villadora.semver.regexp.RangeRegExps;
import com.github.villadora.semver.regexp.VersionRegExps;
import java.util.regex.Matcher;

public class RangeParser {
    private String input;
    private int pos;

    public static Range parse(String range) {
        return new RangeParser(range).parse();
    }

    public RangeParser(String input) {
        this.input = input.trim();
        this.pos = 0;
    }

    public Range parse() {
        if (this.input.length() == 0) {
            return Range.any();
        }
        return this.range();
    }

    private Range range() {
        return this.range(false);
    }

    private Range range(boolean paren) {
        this.skipWhitespace();
        Range range = null;
        char ch = this.input.charAt(this.pos);
        switch (ch) {
            case '(': {
                ++this.pos;
                range = this.range(true);
                if (this.input.charAt(this.pos) != ')') {
                    throw new IllegalArgumentException("Cannot find matching close paren: " + this.input);
                }
                ++this.pos;
                break;
            }
            case '~': {
                range = this.tilde();
                break;
            }
            case '<': 
            case '>': {
                range = this.compare();
                break;
            }
            default: {
                Matcher mc = RangeRegExps.HYPHEN_RANGE_REG.matcher(this.input.substring(this.pos));
                if (mc.find()) {
                    String hyphen = mc.group();
                    String start = mc.group(1);
                    String end = mc.group(2);
                    this.pos += hyphen.length();
                    range = Range.between(this.precise(start), this.precise(end), true, true);
                    break;
                }
                mc = RangeRegExps.SIMPLE_RANGE_REG.matcher(this.input.substring(this.pos));
                if (mc.find()) {
                    String srange = mc.group();
                    this.pos += srange.length();
                    range = Range.exact(this.precise(srange));
                    break;
                }
                mc = RangeRegExps.X_RANGE_REG.matcher(this.input.substring(this.pos));
                if (mc.find()) {
                    String xrange = mc.group();
                    this.pos += xrange.length();
                    String[] v = xrange.split("\\.");
                    if (v.length > 3) {
                        throw new IllegalArgumentException("BaseRange is invalid for: " + this.input);
                    }
                    if (v.length == 3 || v.length == 2 && !v[1].matches("x|X|\\*")) {
                        if (v[1].matches("x|X|\\*")) {
                            int major = Integer.parseInt(v[0]);
                            range = Range.between(this.precise(Integer.toString(major), true), this.precise(Integer.toString(major + 1), true), true, false);
                            break;
                        }
                        int minor = Integer.parseInt(v[1]);
                        range = Range.between(this.precise(v[0] + "." + Integer.toString(minor), true), this.precise(v[0] + "." + Integer.toString(minor + 1), true), true, false);
                        break;
                    }
                    if (v.length == 2 || v.length == 1 && !v[0].matches("x|X|\\*")) {
                        int major = Integer.parseInt(v[0]);
                        range = Range.between(this.precise(Integer.toString(major), true), this.precise(Integer.toString(major + 1), true), true, false);
                        break;
                    }
                    if (v.length != 1) break;
                    range = Range.any();
                    break;
                }
                throw new IllegalArgumentException("Invalid range expression: " + this.input);
            }
        }
        while (this.pos < this.input.length()) {
            if (this.pos + 1 < this.input.length()) {
                char first = this.input.charAt(this.pos);
                char second = this.input.charAt(this.pos + 1);
                if (first == ' ' && !Character.isWhitespace(second) && second != '|' && second != ')') {
                    ++this.pos;
                    range = Range.compositeAnd(range, this.range());
                    continue;
                }
            }
            this.skipWhitespace();
            ch = this.input.charAt(this.pos);
            if (this.pos + 1 < this.input.length() && ch == '|' && this.input.charAt(this.pos + 1) == '|') {
                this.pos += 2;
                range = Range.compositeOr(range, this.range());
                continue;
            }
            if (paren && this.input.charAt(this.pos) == ')') {
                return range;
            }
            if (Character.isWhitespace(this.input.charAt(this.pos))) continue;
            throw new IllegalArgumentException("Invalid range expression: " + this.input);
        }
        return range;
    }

    private Range compare() {
        Matcher mc = RangeRegExps.COMPARE_RANGE_REG.matcher(this.input.substring(this.pos));
        if (mc.find()) {
            String comp = mc.group(1);
            String version = mc.group(2);
            this.pos += mc.group().length();
            if (RangeRegExps.SHORT_VERSION_REG.matcher(version).matches()) {
                if (comp.equals("<=") || comp.equals(">=") || comp.equals("<")) {
                    version = this.precise(version, true);
                } else {
                    String[] v = version.split("\\.");
                    if (v.length == 2) {
                        version = this.precise(v[0] + "." + Integer.toString(Integer.parseInt(v[1]) + 1), true);
                    } else if (v.length == 1) {
                        version = this.precise(Integer.toString(Integer.parseInt(v[0]) + 1), true);
                    }
                    comp = ">=";
                }
            }
            if (comp.equals(">")) {
                return Range.greaterThan(version);
            }
            if (comp.equals("<")) {
                if (!version.contains("-")) {
                    version = version + "-0";
                }
                return Range.lessThan(version);
            }
            if (comp.equals(">=")) {
                return Range.greaterAndEqualThan(version);
            }
            if (comp.equals("<=")) {
                return Range.lessAndEqualThan(version);
            }
        }
        throw new IllegalArgumentException("Invalid compare range: " + this.input.substring(this.pos));
    }

    private Range tilde() {
        Matcher mc = RangeRegExps.TILDE_RANGE_REG.matcher(this.input.substring(this.pos));
        if (mc.find()) {
            String impv = mc.group(1);
            String[] v = impv.split("\\.");
            this.pos += mc.group().length();
            Version version = new Version(this.precise(impv, true));
            if (v.length == 1) {
                Version upper = new Version(version);
                upper.setMajor(upper.getMajor() + 1);
                upper.setPatch(0);
                return Range.between(version, upper, true, false);
            }
            if (v.length <= 3) {
                Version upper = new Version(version);
                upper.setMinor(upper.getMinor() + 1);
                upper.setPatch(0);
                return Range.between(version, upper, true, false);
            }
        }
        throw new IllegalArgumentException("Invalid tilde range: " + this.input.substring(this.pos));
    }

    private void skipWhitespace() {
        if (this.pos < this.input.length() && Character.isWhitespace(this.input.charAt(this.pos))) {
            ++this.pos;
        }
    }

    private String precise(String version) {
        return this.precise(version, false);
    }

    private String precise(String version, boolean prerelease) {
        if (RangeRegExps.EXACT_VERSION_REG.matcher(version).matches()) {
            if (prerelease && VersionRegExps.MAIN_VERSION_REG.matcher(version).matches()) {
                return version + "-0";
            }
            return version;
        }
        String[] v = version.split("\\.");
        if (v.length == 3) {
            return prerelease ? version + "-0" : version;
        }
        if (v.length == 2) {
            return prerelease ? version + ".0-0" : version + ".0";
        }
        if (v.length == 1) {
            return prerelease ? version + ".0.0-0" : version + ".0.0";
        }
        throw new IllegalArgumentException("Invalid version for expand: " + version);
    }
}

