/*
 * Decompiled with CFR 0.152.
 */
package com.github.villadora.semver.ranges;

import com.github.villadora.semver.Version;
import com.github.villadora.semver.ranges.Range;
import java.util.Arrays;
import java.util.List;

class CompositRange
extends Range {
    private boolean and = false;
    private List<Range> ranges;

    public CompositRange(Range ... ranges) {
        this(Arrays.asList(ranges), false);
    }

    public CompositRange(boolean and, Range ... ranges) {
        this(Arrays.asList(ranges), and);
    }

    public CompositRange(List<Range> ranges) {
        this(ranges, false);
    }

    public CompositRange(List<Range> ranges, boolean and) {
        boolean maxClose = false;
        boolean minClose = false;
        Version max = null;
        Version min = null;
        for (Range range : ranges) {
            if (max == null) {
                max = range.max;
                maxClose = range.maxClose;
            } else if (!and && (!maxClose ? max.compareTo(range.max) <= 0 : max.compareTo(range.max) < 0) || and && (maxClose ? max.compareTo(range.max) > 0 : max.compareTo(range.max) >= 0)) {
                max = range.max;
                maxClose = range.maxClose;
            }
            if (min == null) {
                min = range.min;
                minClose = range.minClose;
                continue;
            }
            if (!(!and && (!minClose ? min.compareTo(range.min) >= 0 : min.compareTo(range.min) > 0)) && (!and || !(minClose ? min.compareTo(range.min) < 0 : min.compareTo(range.min) <= 0))) continue;
            min = range.min;
            minClose = range.minClose;
        }
        this.ranges = ranges;
        this.and = and;
        this.min = min;
        this.max = max;
        this.minClose = minClose;
        this.maxClose = maxClose;
    }

    @Override
    public boolean satisfies(Version version) {
        for (Range range : this.ranges) {
            if (this.and) {
                if (range.satisfies(version)) continue;
                return false;
            }
            if (!range.satisfies(version)) continue;
            return true;
        }
        return this.and;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.ranges.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof CompositRange) {
            CompositRange that = (CompositRange)o;
            if (!super.equals(that)) {
                return false;
            }
            if (this.and != that.and) {
                return false;
            }
            if (this.ranges.size() != that.ranges.size()) {
                return false;
            }
            for (int i = 0; i < this.ranges.size(); ++i) {
                if (this.ranges.get(i).equals(that.ranges.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

