/*
 * Decompiled with CFR 0.152.
 */
package com.github.villadora.semver.ranges;

import com.github.villadora.semver.Version;
import com.github.villadora.semver.parser.RangeParser;
import com.github.villadora.semver.ranges.AnyRange;
import com.github.villadora.semver.ranges.CompositRange;
import com.github.villadora.semver.ranges.EmptyRange;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Range {
    protected boolean minClose;
    protected boolean maxClose;
    protected Version min;
    protected Version max;
    public static final Version MIN = new Version(-1, -1, -1, new String[]{"0"});
    public static final Version MAX = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

    protected Range() {
        this(MAX, MIN);
    }

    protected Range(String start, String end) {
        this(new Version(start), new Version(end));
    }

    protected Range(Version start, Version end) {
        this(start, end, false, false);
    }

    protected Range(String start, String end, boolean startClose, boolean endClose) {
        this(new Version(start), new Version(end), startClose, endClose);
    }

    protected Range(Version start, Version end, boolean startClose, boolean endClose) {
        this.min = start;
        this.max = end;
        this.minClose = startClose;
        this.maxClose = endClose;
    }

    public boolean satisfies(Version version) {
        if (version == null) {
            return false;
        }
        if (this.min.compareTo(this.max) > 0) {
            return false;
        }
        return (this.minClose ? this.min.compareTo(version) <= 0 : this.min.compareTo(version) < 0) && (this.maxClose ? this.max.compareTo(version) >= 0 : this.max.compareTo(version) > 0);
    }

    public Version maxSatisfying(List<Version> versions) {
        if (versions == null || versions.size() == 0) {
            return null;
        }
        LinkedList<Version> list = new LinkedList<Version>(versions);
        Collections.sort(list);
        for (int i = list.size() - 1; i >= 0; --i) {
            Version ver = (Version)list.get(i);
            if (!this.satisfies(ver)) continue;
            return ver;
        }
        return null;
    }

    public boolean outside(Version version) {
        if (version == null) {
            return true;
        }
        if (this.min.compareTo(this.max) > 0) {
            return true;
        }
        return this.greater(version) || this.less(version);
    }

    public boolean greater(Version version) {
        if (version == null) {
            return true;
        }
        if (this.min.compareTo(this.max) > 0) {
            return false;
        }
        return this.minClose ? this.min.compareTo(version) > 0 : this.min.compareTo(version) >= 0;
    }

    public boolean less(Version version) {
        if (version == null) {
            return false;
        }
        if (this.min.compareTo(this.max) > 0) {
            return false;
        }
        return this.maxClose ? this.max.compareTo(version) < 0 : this.max.compareTo(version) <= 0;
    }

    public boolean satisfies(String version) {
        return this.satisfies(new Version(version));
    }

    public Version maxSatisfying(Version ... versions) {
        return this.maxSatisfying(Arrays.asList(versions));
    }

    public Version maxSatisfying(String ... versions) {
        LinkedList<Version> list = new LinkedList<Version>();
        for (String version : versions) {
            list.add(new Version(version));
        }
        return this.maxSatisfying(list);
    }

    public boolean outside(String version) {
        return this.outside(new Version(version));
    }

    public boolean greater(String version) {
        return this.greater(new Version(version));
    }

    public boolean less(String version) {
        return this.less(new Version(version));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Range) {
            Range that = (Range)o;
            return this.min.equals(that.min) && this.max.equals(that.max) && this.minClose == that.minClose && this.maxClose == that.maxClose;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        for (int code : Arrays.asList(this.min.hashCode(), this.max.hashCode(), Boolean.valueOf(this.minClose).hashCode(), Boolean.valueOf(this.maxClose).hashCode())) {
            result = 31 * result + code;
        }
        return result;
    }

    public String toString() {
        if (this.min == MIN && this.max == MAX) {
            return ">0.0.0 <0.0.0";
        }
        if (this.min == MIN) {
            return (this.maxClose ? "<=" : "<") + this.max.toString();
        }
        if (this.max == MAX) {
            return (this.minClose ? ">=" : ">") + this.min.toString();
        }
        return (this.maxClose ? "<=" : "<") + this.max.toString() + " " + (this.minClose ? ">=" : ">") + this.min.toString();
    }

    public static boolean valid(String range) {
        try {
            new RangeParser(range).parse();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static Range empty() {
        return EmptyRange.RANGE;
    }

    public static Range any() {
        return AnyRange.RANGE;
    }

    public static Range valueOf(String range) {
        return new RangeParser(range.trim()).parse();
    }

    public static Range compositeOr(String ... rgs) {
        return Range.composite(false, rgs);
    }

    public static Range compositeAnd(String ... rgs) {
        return Range.composite(true, rgs);
    }

    public static Range compositeOr(Range ... rgs) {
        return Range.composite(false, Arrays.asList(rgs));
    }

    public static Range compositeAnd(Range ... rgs) {
        return Range.composite(true, Arrays.asList(rgs));
    }

    private static Range composite(boolean and, List<Range> rgs) {
        return new CompositRange(rgs, and);
    }

    private static Range composite(boolean and, String ... rgs) {
        LinkedList<Range> ranges = new LinkedList<Range>();
        for (String rg : rgs) {
            ranges.add(new RangeParser(rg).parse());
        }
        return Range.composite(and, ranges);
    }

    public static Range exact(Version version) {
        return new Range(version, version, true, true);
    }

    public static Range exact(String version) {
        return Range.exact(new Version(version));
    }

    public static Range greaterThan(String version) {
        return Range.greaterThan(new Version(version));
    }

    public static Range greaterThan(Version version) {
        return new Range(version, MAX);
    }

    public static Range lessThan(String version) {
        return Range.lessThan(new Version(version));
    }

    public static Range lessThan(Version version) {
        return new Range(MIN, version);
    }

    public static Range greaterAndEqualThan(String version) {
        return Range.greaterAndEqualThan(new Version(version));
    }

    public static Range greaterAndEqualThan(Version version) {
        return new Range(version, MAX, true, false);
    }

    public static Range lessAndEqualThan(String version) {
        return Range.lessAndEqualThan(new Version(version));
    }

    public static Range lessAndEqualThan(Version version) {
        return new Range(MIN, version, false, true);
    }

    public static Range between(String start, String end, boolean sClosed, boolean eClosed) {
        return Range.between(new Version(start), new Version(end), sClosed, eClosed);
    }

    public static Range between(Version start, Version end, boolean sClosed, boolean eClosed) {
        return new Range(start, end, sClosed, eClosed);
    }
}

