/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator;

import com.github.vincentrussell.json.datagenerator.JsonDataGeneratorException;
import com.github.vincentrussell.json.datagenerator.functions.FunctionRegistry;
import com.github.vincentrussell.json.datagenerator.impl.JsonDataGeneratorImpl;
import com.github.vincentrussell.json.datagenerator.impl.NonCloseableBufferedOutputStream;
import com.github.vincentrussell.json.datagenerator.impl.TimeoutInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;

public final class CLIMain {
    private static TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    public static final String ENTER_JSON_TEXT = "Enter input json:\n\n ";

    private CLIMain() {
    }

    private static Options buildOptions() {
        Options options = new Options();
        Option o = new Option("s", "sourceFile", true, "the source file.");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("d", "destinationFile", true, "the destination file.  Defaults to System.out");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("f", "functionClasses", true, "additional function classes that are on the classpath and should be loaded");
        o.setRequired(false);
        o.setArgs(-2);
        options.addOption(o);
        o = new Option("i", "interactiveMode", false, "interactive mode");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("t", "timeZone", true, "default time zone to use when dealing with dates");
        o.setRequired(false);
        options.addOption(o);
        o = new Option("p", "pipeMode", false, "pipe mode");
        o.setRequired(false);
        options.addOption(o);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, JsonDataGeneratorException, ParseException, ClassNotFoundException {
        try {
            TimeZone.setDefault(DEFAULT_TIMEZONE);
            Options options = CLIMain.buildOptions();
            DefaultParser parser = new DefaultParser();
            HelpFormatter help = new HelpFormatter();
            help.setOptionComparator((Comparator)new OptionComparator(Arrays.asList("s", "d", "f", "i", "t", "p")));
            CommandLine cmd = null;
            try {
                File destinationFile;
                cmd = parser.parse(options, args);
                String source = cmd.getOptionValue("s");
                boolean interactiveMode = cmd.hasOption('i');
                boolean pipeMode = cmd.hasOption('p');
                String[] functionClasses = cmd.getOptionValues("f");
                String timeZone = cmd.getOptionValue("t");
                if (timeZone != null) {
                    TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
                }
                FunctionRegistry functionRegistry = new FunctionRegistry();
                if (functionClasses != null) {
                    for (String string : functionClasses) {
                        functionRegistry.registerClass(Class.forName(string));
                    }
                }
                if (interactiveMode) {
                    System.out.println(ENTER_JSON_TEXT);
                    try (TimeoutInputStream inputStream = new TimeoutInputStream(System.in, 1L, TimeUnit.SECONDS);){
                        Throwable throwable = null;
                        try (NonCloseableBufferedOutputStream outputStream = new NonCloseableBufferedOutputStream(System.out);){
                            IOUtils.write((String)"\n\n\n\n\n", (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
                            JsonDataGeneratorImpl jsonDataGenerator = new JsonDataGeneratorImpl(functionRegistry);
                            jsonDataGenerator.generateTestDataJson(inputStream, (OutputStream)outputStream);
                        }
                        catch (Throwable jsonDataGenerator) {
                            Throwable throwable2 = jsonDataGenerator;
                            throw jsonDataGenerator;
                        }
                    }
                    System.exit(0);
                } else if (pipeMode) {
                    JsonDataGeneratorImpl jsonDataGenerator = new JsonDataGeneratorImpl(functionRegistry);
                    jsonDataGenerator.generateTestDataJson(System.in, (OutputStream)System.out);
                    System.exit(0);
                }
                String destination = cmd.getOptionValue("d");
                if (source == null) {
                    throw new ParseException("Missing required option: s or i");
                }
                File sourceFile = new File(source);
                File file = destinationFile = destination != null ? new File(destination) : null;
                if (!sourceFile.exists()) {
                    throw new FileNotFoundException(source + " cannot be found");
                }
                if (destination != null && destinationFile.exists()) {
                    throw new IOException(destination + " already exists");
                }
                JsonDataGeneratorImpl jsonDataGeneratorImpl = new JsonDataGeneratorImpl(functionRegistry);
                try (FileInputStream inputStream = new FileInputStream(sourceFile);
                     OutputStream outputStream = destinationFile != null ? new FileOutputStream(destinationFile) : new NonCloseableBufferedOutputStream(System.out);){
                    jsonDataGeneratorImpl.generateTestDataJson(inputStream, outputStream);
                }
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                help.printHelp(CLIMain.class.getName(), options, true);
                throw e;
            }
        }
        finally {
            TimeZone.setDefault(DEFAULT_TIMEZONE);
        }
    }

    private static class OptionComparator
    implements Comparator<Option> {
        private final List<String> orderList;

        OptionComparator(List<String> orderList) {
            this.orderList = orderList;
        }

        @Override
        public int compare(Option o1, Option o2) {
            int index1 = this.orderList.indexOf(o1.getOpt());
            int index2 = this.orderList.indexOf(o2.getOpt());
            return index1 - index2;
        }
    }
}

