/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.functions;

import com.github.vincentrussell.json.datagenerator.functions.Function;
import com.github.vincentrussell.json.datagenerator.functions.FunctionInvocation;
import com.github.vincentrussell.json.datagenerator.impl.IndexHolder;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class FunctionRegistry {
    private final Map<FunctionInvocationHolder, MethodAndObjectHolder> functionInvocationHolderMethodConcurrentHashMap = new ConcurrentHashMap<FunctionInvocationHolder, MethodAndObjectHolder>();
    private final Map<Method, Object> methodInstanceMap = new ConcurrentHashMap<Method, Object>();
    private final Set<String> nonOverridableFunctionNames = new HashSet<String>();
    private final Map<String, String> getAndPutCache = new ConcurrentHashMap<String, String>();
    private final Map<String, IndexHolder> stringIndexHolderMap = new ConcurrentHashMap<String, IndexHolder>();

    public FunctionRegistry() {
        Reflections reflections = new Reflections(this.getClass().getPackage().getName() + ".impl", new Scanner[0]);
        Set functionClasses = reflections.getTypesAnnotatedWith(Function.class);
        for (Class clazz : functionClasses) {
            this.registerClass(clazz);
        }
    }

    public Map<String, String> getGetAndPutCache() {
        return this.getAndPutCache;
    }

    public Map<String, IndexHolder> getStringIndexHolderMap() {
        return this.stringIndexHolderMap;
    }

    public void registerClass(Class<?> clazz) {
        Function annotation = clazz.getAnnotation(Function.class);
        this.checkClassValidity(clazz, annotation);
        try {
            for (String annotationName : annotation.name()) {
                int zeroArgConstructorCount = this.getZeroArgConstructorCount(clazz);
                int functionRegistryConstructorArgumentCount = this.getFunctionRegistryConstructorArgumentCount(clazz);
                Object instance = null;
                if (functionRegistryConstructorArgumentCount == 1) {
                    instance = clazz.getConstructors()[0].newInstance(this);
                } else if (zeroArgConstructorCount == 1) {
                    instance = clazz.newInstance();
                } else {
                    throw new IllegalArgumentException("proper constructor for class " + clazz + " cannot be found");
                }
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(FunctionInvocation.class)) continue;
                    this.checkMethodValidity(method);
                    MethodAndObjectHolder methodAndObjectHolder = new MethodAndObjectHolder(method, instance);
                    this.functionInvocationHolderMethodConcurrentHashMap.put(new FunctionInvocationHolder(annotationName, method.getParameterTypes()), methodAndObjectHolder);
                    this.methodInstanceMap.put(method, instance);
                }
                if (annotation.overridable()) continue;
                this.nonOverridableFunctionNames.add(annotationName);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private int getFunctionRegistryConstructorArgumentCount(Class<?> clazz) {
        return Iterables.size((Iterable)Iterables.filter(Arrays.asList(clazz.getConstructors()), (Predicate)new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> constructor) {
                return constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0].equals(FunctionRegistry.class);
            }
        }));
    }

    private void checkMethodValidity(Method method) {
        int stringClassesCount = Iterables.size((Iterable)Iterables.filter(Arrays.asList(method.getParameterTypes()), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> aClass) {
                return aClass == String.class;
            }
        }));
        int stringArrayClassesCount = Iterables.size((Iterable)Iterables.filter(Arrays.asList(method.getParameterTypes()), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> aClass) {
                return aClass == String[].class;
            }
        }));
        if (!String.class.isAssignableFrom(method.getReturnType())) {
            throw new IllegalArgumentException("method " + method.getName() + " on class " + method.getDeclaringClass().getName() + " must return type String");
        }
        if (stringClassesCount != method.getParameterTypes().length && method.getParameterTypes().length > 1 || stringArrayClassesCount != 1 && stringClassesCount == 0 && method.getParameterTypes().length == 1) {
            throw new IllegalArgumentException("for method " + method.getName() + " on class " + method.getDeclaringClass().getName() + ": all method parameters need to be a String or a single String var-arg parameter");
        }
    }

    private void checkClassValidity(Class<?> clazz, Function annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(clazz.getName() + " must be annotated with " + Function.class.getName());
        }
        for (String annotationName : annotation.name()) {
            if (StringUtils.isEmpty((String)annotationName)) {
                throw new IllegalArgumentException(Function.class.getName() + "annotation on class" + clazz.getName() + " annotation must have name attribute populated");
            }
            if (!this.nonOverridableFunctionNames.contains(annotationName)) continue;
            throw new IllegalArgumentException(clazz.getName() + " can not override existing function with the same annotation: " + annotationName + " because it does not allow overriding.");
        }
        int zeroArgConstructorCount = this.getZeroArgConstructorCount(clazz);
        int functionRegistryConstructorArgumentCount = this.getFunctionRegistryConstructorArgumentCount(clazz);
        if (zeroArgConstructorCount != 1 && functionRegistryConstructorArgumentCount != 1) {
            throw new IllegalArgumentException(clazz.getName() + " must have a no-arg constructor");
        }
        int validMethodCount = Iterables.size((Iterable)Iterables.filter(Arrays.asList(clazz.getDeclaredMethods()), (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                return method.isAnnotationPresent(FunctionInvocation.class);
            }
        }));
        if (validMethodCount == 0) {
            throw new IllegalArgumentException(clazz.getName() + ": could not find any public methods annotated with " + FunctionInvocation.class.getName());
        }
    }

    private int getZeroArgConstructorCount(Class<?> clazz) {
        return Iterables.size((Iterable)Iterables.filter(Arrays.asList(clazz.getConstructors()), (Predicate)new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> constructor) {
                return constructor.getParameterTypes().length == 0;
            }
        }));
    }

    public String executeFunction(String functionName, String ... arguments) throws InvocationTargetException, IllegalAccessException {
        Method method = this.getMethod(functionName, arguments);
        return this.executeMethod(method, arguments);
    }

    private String executeMethod(Method method, String ... arguments) throws InvocationTargetException, IllegalAccessException {
        Object instance = this.methodInstanceMap.get(method);
        if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(String[].class)) {
            return method.invoke(instance, new Object[]{arguments}).toString();
        }
        return method.invoke(instance, (Object[])arguments).toString();
    }

    public Method getMethod(String functionName, String ... arguments) throws IllegalArgumentException {
        ArrayList classList = new ArrayList();
        if (arguments != null) {
            for (String argument : arguments) {
                if (argument == null) continue;
                classList.add(argument.getClass());
            }
        }
        MethodAndObjectHolder holder = null;
        try {
            holder = this.getHolder(functionName, classList);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        if (holder == null) {
            throw new IllegalArgumentException("could not find method to invoke.");
        }
        return holder.getMethod();
    }

    private MethodAndObjectHolder getHolder(String functionName, List<Class<?>> classList) throws IllegalAccessException {
        MethodAndObjectHolder holder = this.functionInvocationHolderMethodConcurrentHashMap.get(new FunctionInvocationHolder(functionName, classList.toArray(new Class[classList.size()])));
        if (holder == null) {
            holder = this.functionInvocationHolderMethodConcurrentHashMap.get(new FunctionInvocationHolder(functionName, new Class[]{String[].class}));
        }
        return holder;
    }

    private static final class FunctionInvocationHolder {
        private final String functionName;
        private final Class<?>[] parameterTypes;

        private FunctionInvocationHolder(String functionName, Class<?>[] parameterTypes) {
            Validate.notNull((Object)functionName, (String)"a function name must be provided");
            Validate.notNull(parameterTypes, (String)"parameter types must be provided");
            this.functionName = functionName;
            this.parameterTypes = parameterTypes;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            FunctionInvocationHolder functionInvocationHolder = (FunctionInvocationHolder)obj;
            return new EqualsBuilder().append((Object)this.functionName, (Object)functionInvocationHolder.functionName).append((Object[])this.parameterTypes, (Object[])functionInvocationHolder.parameterTypes).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(5, 33).append((Object)this.functionName).append((Object[])this.parameterTypes).toHashCode();
        }
    }

    private static final class MethodAndObjectHolder {
        private final Method method;
        private final Object instance;

        private MethodAndObjectHolder(Method method, Object instance) {
            this.method = method;
            this.instance = instance;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

