/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.functions.impl;

import com.github.vincentrussell.json.datagenerator.functions.Function;
import com.github.vincentrussell.json.datagenerator.functions.FunctionInvocation;
import com.github.vincentrussell.json.datagenerator.functions.FunctionRegistry;
import com.github.vincentrussell.json.datagenerator.impl.IndexHolder;
import java.util.Map;

@Function(name={"index"})
public class Index {
    static final String DEFAULT = "DEFAULT";
    private final FunctionRegistry functionRegistry;

    public Index(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    @FunctionInvocation
    public String getIndex() {
        return this.getIndex(DEFAULT);
    }

    @FunctionInvocation
    public String getIndex(String indexName) {
        try {
            return this.getIndex(DEFAULT, Integer.parseInt(indexName));
        }
        catch (NumberFormatException e) {
            return "" + this.getIndexHolder(indexName).getNextIndex();
        }
    }

    @FunctionInvocation
    public String getIndex(String indexName, String startingPoint) {
        return this.getIndex(indexName, Integer.parseInt(startingPoint));
    }

    private String getIndex(String indexName, int startingPoint) {
        return "" + this.getIndexHolder(indexName, startingPoint).getNextIndex();
    }

    private IndexHolder getIndexHolder(String indexName) {
        return this.getIndexHolder(indexName, 0);
    }

    private IndexHolder getIndexHolder(String indexName, int startingPoint) {
        Map<String, IndexHolder> stringIndexHolderMap = this.functionRegistry.getStringIndexHolderMap();
        if (stringIndexHolderMap.containsKey(indexName)) {
            return stringIndexHolderMap.get(indexName);
        }
        IndexHolder indexHolder = new IndexHolder(startingPoint);
        stringIndexHolderMap.put(indexName, indexHolder);
        return indexHolder;
    }
}

