/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.functions.impl;

import com.github.javafaker.service.FakeValuesService;
import com.github.javafaker.service.RandomService;
import com.github.vincentrussell.json.datagenerator.functions.Function;
import com.github.vincentrussell.json.datagenerator.functions.FunctionInvocation;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@Function(name={"regexify"})
public class Regexify {
    private static final LoadingCache<String, FakeValuesService> FAKE_VALUES_SERVICE_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, FakeValuesService>(){

        public FakeValuesService load(String locale) {
            return new FakeValuesService(new Locale(locale), new RandomService());
        }
    });

    @FunctionInvocation
    public final String regexify(String regex) {
        return this.regexify("en-US", regex);
    }

    @FunctionInvocation
    public final String regexify(String locale, String regex) {
        return Regexify.getFakeValuesService(locale).regexify(regex);
    }

    private static FakeValuesService getFakeValuesService(String locale) {
        try {
            return (FakeValuesService)FAKE_VALUES_SERVICE_CACHE.get((Object)locale);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

