/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.functions.impl;

import com.github.vincentrussell.json.datagenerator.functions.Function;
import com.github.vincentrussell.json.datagenerator.functions.FunctionInvocation;
import com.github.vincentrussell.json.datagenerator.functions.FunctionRegistry;
import com.github.vincentrussell.json.datagenerator.impl.IndexHolder;
import java.util.Map;

@Function(name={"resetIndex"})
public class ResetIndex {
    private final FunctionRegistry functionRegistry;

    public ResetIndex(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    @FunctionInvocation
    public String resetIndex() {
        return this.resetIndex("DEFAULT");
    }

    @FunctionInvocation
    public String resetIndex(String indexName) {
        IndexHolder indexHolder = this.getIndexHolder(indexName);
        indexHolder.resetIndex();
        return "";
    }

    private IndexHolder getIndexHolder(String indexName) {
        Map<String, IndexHolder> stringIndexHolderMap = this.functionRegistry.getStringIndexHolderMap();
        if (stringIndexHolderMap.containsKey(indexName)) {
            return stringIndexHolderMap.get(indexName);
        }
        throw new IllegalStateException("could not find index with name " + indexName);
    }
}

