/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.functions.impl;

import com.github.vincentrussell.json.datagenerator.functions.Function;
import com.github.vincentrussell.json.datagenerator.functions.FunctionInvocation;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;

@Function(name={"time"})
public class Time {
    public static final String DEFAULT_INPUT_FORMAT = "h[:mm][ ]a";
    public static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("h[:mm][ ]a");

    @FunctionInvocation
    public String time() {
        return this.time(DEFAULT_INPUT_FORMAT);
    }

    @FunctionInvocation
    public String time(String outputTimeFormat) {
        return this.format(LocalTime.now(), outputTimeFormat);
    }

    private String format(LocalTime localTime, String defaultInputFormat) {
        return localTime.format(DateTimeFormatter.ofPattern(defaultInputFormat));
    }

    @FunctionInvocation
    public String time(String startTime, String endTime, String outputFormat) {
        LocalTime time1 = LocalTime.parse(startTime, DEFAULT_FORMATTER);
        LocalTime time2 = LocalTime.parse(endTime, DEFAULT_FORMATTER);
        int secondOfDayTime1 = time1.toSecondOfDay();
        int secondOfDayTime2 = time2.toSecondOfDay();
        Random random = new Random();
        int randomSecondOfDay = secondOfDayTime1 + random.nextInt(secondOfDayTime2 - secondOfDayTime1);
        return LocalTime.ofSecondOfDay(randomSecondOfDay).format(DateTimeFormatter.ofPattern(outputFormat));
    }
}

