/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.functions.impl;

import com.github.vincentrussell.json.datagenerator.functions.Function;
import com.github.vincentrussell.json.datagenerator.functions.FunctionInvocation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

@Function(name={"toTimestamp"})
public class ToTimestamp {
    public static final String DEFAULT_DATE_STRING = "EEE, d MMM yyyy HH:mm:ss z";

    @FunctionInvocation
    public String toTimestamp(String string) {
        return this.toTimestamp(string, DEFAULT_DATE_STRING);
    }

    @FunctionInvocation
    public String toTimestamp(String string, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(formatter.parse(string));
            Long timeInMillis = cal.getTimeInMillis();
            return "" + timeInMillis;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

