/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.impl;

import com.github.vincentrussell.json.datagenerator.TokenResolver;
import com.github.vincentrussell.json.datagenerator.functions.FunctionRegistry;
import com.github.vincentrussell.json.datagenerator.parser.FunctionParser;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionTokenResolver
implements TokenResolver {
    private final FunctionRegistry functionRegistry;
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionTokenResolver.class);

    public FunctionTokenResolver(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    @Override
    public String resolveToken(CharSequence s) {
        try {
            FunctionParser functionParser = new FunctionParser(new ByteArrayInputStream(s.toString().getBytes(Charsets.UTF_8)), Charsets.UTF_8);
            functionParser.setFunctionRegistry(this.functionRegistry);
            return functionParser.Parse();
        }
        catch (Throwable e) {
            LOGGER.warn(e.getMessage(), e);
            throw new IllegalArgumentException("cannot parse function: " + s, e);
        }
    }
}

