/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.impl;

import org.apache.commons.lang.mutable.MutableInt;

public class IndexHolder {
    private final ResettingMutableInt index;

    public IndexHolder(int startingIndex) {
        this.index = new ResettingMutableInt(startingIndex);
    }

    public int getNextIndex() {
        return this.index.getNextNumber();
    }

    public void resetIndex() {
        this.index.reset();
    }

    private static class ResettingMutableInt
    extends MutableInt {
        private final int startingPoint;

        ResettingMutableInt(int startingPoint) {
            super(startingPoint);
            this.startingPoint = startingPoint;
        }

        public void reset() {
            this.setValue(this.startingPoint);
        }

        public int getNextNumber() {
            try {
                int n = this.toInteger();
                return n;
            }
            finally {
                this.increment();
            }
        }
    }
}

