/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.json.datagenerator.impl;

import com.github.vincentrussell.json.datagenerator.JsonDataGenerator;
import com.github.vincentrussell.json.datagenerator.JsonDataGeneratorException;
import com.github.vincentrussell.json.datagenerator.functions.FunctionRegistry;
import com.github.vincentrussell.json.datagenerator.impl.ByteArrayBackupToFileOutputStream;
import com.github.vincentrussell.json.datagenerator.impl.FunctionReplacingReader;
import com.github.vincentrussell.json.datagenerator.impl.FunctionTokenResolver;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class JsonDataGeneratorImpl
implements JsonDataGenerator {
    public static final String REPEAT = "'{{repeat(";
    private static final byte[] CLOSE_BRACKET_BYTE_ARRAY = "]".getBytes(Charsets.UTF_8);
    private static final byte[] COMMA_NEWLINE_BYTE_ARRAY = ",\n".getBytes(Charsets.UTF_8);
    private static final byte[] NEWLINE_BYTE_ARRAY = "\n".getBytes(Charsets.UTF_8);
    public static final int DEFAULT_READ_AHEAD_LIMIT = 1000;
    private final FunctionRegistry functionRegistry;

    public JsonDataGeneratorImpl(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    public JsonDataGeneratorImpl() {
        this(new FunctionRegistry());
    }

    @Override
    public void generateTestDataJson(String text, OutputStream outputStream) throws JsonDataGeneratorException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(text.getBytes(Charsets.UTF_8));){
            this.generateTestDataJson(byteArrayInputStream, outputStream);
        }
        catch (JsonDataGeneratorException | IOException e) {
            throw new JsonDataGeneratorException(e);
        }
    }

    @Override
    public void generateTestDataJson(URL classPathResource, OutputStream outputStream) throws JsonDataGeneratorException {
        try {
            this.generateTestDataJson(classPathResource.openStream(), outputStream);
        }
        catch (IOException e) {
            throw new JsonDataGeneratorException(e);
        }
    }

    @Override
    public void generateTestDataJson(File file, OutputStream outputStream) throws JsonDataGeneratorException {
        Validate.notNull((Object)file, (String)"file can not be null");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.generateTestDataJson(fileInputStream, outputStream);
        }
        catch (IOException e) {
            throw new JsonDataGeneratorException(e);
        }
    }

    @Override
    public void generateTestDataJson(File file, File outputFile) throws JsonDataGeneratorException {
        Validate.notNull((Object)file, (String)"file can not be null");
        Validate.notNull((Object)outputFile, (String)"outputFile can not be null");
        Validate.isTrue((!outputFile.exists() ? 1 : 0) != 0, (String)"outputFile can not exist");
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            this.generateTestDataJson(fileInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            throw new JsonDataGeneratorException(e);
        }
    }

    @Override
    public void generateTestDataJson(InputStream inputStream, OutputStream outputStream) throws JsonDataGeneratorException {
        try (ByteArrayBackupToFileOutputStream byteArrayBackupToFileOutputStream = new ByteArrayBackupToFileOutputStream();){
            this.handleRepeats(inputStream, byteArrayBackupToFileOutputStream, true);
            try (InputStream copyInputStream = byteArrayBackupToFileOutputStream.getNewInputStream();){
                this.handleNestedFunctions(copyInputStream, outputStream);
            }
        }
        catch (IOException e) {
            throw new JsonDataGeneratorException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleRepeats(InputStream inputStream, OutputStream outputStream, boolean shouldWriteToRepeatStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
        CircularFifoQueue lastCharQueue = new CircularFifoQueue(REPEAT.length());
        LinkedList<Character> xmlRepeatTagList = new LinkedList<Character>();
        boolean isRepeating = false;
        int bracketCount = 0;
        int repeatTimes = 0;
        int firstNonWhitespaceCharacter = -1;
        int xmlTag = 0;
        String xmlRepeatTag = "";
        try (ByteArrayBackupToFileOutputStream tempBuffer = new ByteArrayBackupToFileOutputStream();
             ByteArrayBackupToFileOutputStream repeatBuffer = new ByteArrayBackupToFileOutputStream();){
            int i;
            while ((i = bufferedReader.read()) != -1) {
                String charAsUTF8String = Character.valueOf((char)i).toString();
                if (isRepeating) {
                    Throwable throwable;
                    InputStream newCopyOutputStreamNewInputStream;
                    Throwable throwable2;
                    ByteArrayBackupToFileOutputStream recursiveOutputStream;
                    Throwable throwable3;
                    ByteArrayBackupToFileOutputStream newCopyOutputStream;
                    block156: {
                        repeatBuffer.write(charAsUTF8String.getBytes(Charsets.UTF_8));
                        if (!Character.isWhitespace(i) && firstNonWhitespaceCharacter == -1) {
                            firstNonWhitespaceCharacter = i;
                        }
                        if (123 == i) {
                            ++bracketCount;
                        } else if (125 == i || 93 == i && bracketCount == 0) {
                            if (--bracketCount == 0 && xmlTag == 0) {
                                bufferedReader.mark(1);
                                i = bufferedReader.read();
                                charAsUTF8String = Character.valueOf((char)i).toString();
                                if (i == firstNonWhitespaceCharacter) {
                                    repeatBuffer.write(charAsUTF8String.getBytes(Charsets.UTF_8));
                                } else {
                                    bufferedReader.reset();
                                }
                                newCopyOutputStream = new ByteArrayBackupToFileOutputStream();
                                throwable3 = null;
                                try {
                                    repeatBuffer.copyToOutputStream(newCopyOutputStream);
                                    this.copyRepeatStream(repeatTimes, repeatBuffer, newCopyOutputStream, COMMA_NEWLINE_BYTE_ARRAY);
                                    recursiveOutputStream = new ByteArrayBackupToFileOutputStream();
                                    throwable2 = null;
                                    try {
                                        newCopyOutputStreamNewInputStream = newCopyOutputStream.getNewInputStream();
                                        throwable = null;
                                        try {
                                            this.handleRepeats(newCopyOutputStreamNewInputStream, recursiveOutputStream, !isRepeating || isRepeating && repeatTimes > 0);
                                        }
                                        catch (Throwable throwable4) {
                                            throwable = throwable4;
                                            throw throwable4;
                                        }
                                        finally {
                                            if (newCopyOutputStreamNewInputStream != null) {
                                                if (throwable != null) {
                                                    try {
                                                        newCopyOutputStreamNewInputStream.close();
                                                    }
                                                    catch (Throwable throwable5) {
                                                        throwable.addSuppressed(throwable5);
                                                    }
                                                } else {
                                                    newCopyOutputStreamNewInputStream.close();
                                                }
                                            }
                                        }
                                        recursiveOutputStream.copyToOutputStream(outputStream);
                                        repeatBuffer.setLength(0L);
                                        tempBuffer.setLength(0L);
                                        isRepeating = false;
                                        bracketCount = 0;
                                        break block156;
                                    }
                                    catch (Throwable newCopyOutputStreamNewInputStream2) {
                                        throwable2 = newCopyOutputStreamNewInputStream2;
                                        throw newCopyOutputStreamNewInputStream2;
                                    }
                                    finally {
                                        if (recursiveOutputStream != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    recursiveOutputStream.close();
                                                }
                                                catch (Throwable newCopyOutputStreamNewInputStream2) {
                                                    throwable2.addSuppressed(newCopyOutputStreamNewInputStream2);
                                                }
                                            } else {
                                                recursiveOutputStream.close();
                                            }
                                        }
                                    }
                                }
                                catch (Throwable recursiveOutputStream2) {
                                    throwable3 = recursiveOutputStream2;
                                    throw recursiveOutputStream2;
                                }
                                finally {
                                    if (newCopyOutputStream != null) {
                                        if (throwable3 != null) {
                                            try {
                                                newCopyOutputStream.close();
                                            }
                                            catch (Throwable recursiveOutputStream2) {
                                                throwable3.addSuppressed(recursiveOutputStream2);
                                            }
                                        } else {
                                            newCopyOutputStream.close();
                                        }
                                    }
                                }
                            }
                            if (bracketCount == -1) {
                                repeatBuffer.setLength(repeatBuffer.getLength() - 1L);
                                throwable3 = null;
                                try (ByteArrayBackupToFileOutputStream newCopyFileStream = new ByteArrayBackupToFileOutputStream();){
                                    repeatBuffer.copyToOutputStream(newCopyFileStream);
                                    this.copyRepeatStream(repeatTimes, repeatBuffer, newCopyFileStream, COMMA_NEWLINE_BYTE_ARRAY);
                                    newCopyFileStream.write(CLOSE_BRACKET_BYTE_ARRAY);
                                    recursiveOutputStream = new ByteArrayBackupToFileOutputStream();
                                    throwable2 = null;
                                    try {
                                        throwable = null;
                                        try (InputStream inputStream1 = newCopyFileStream.getNewInputStream();){
                                            this.handleRepeats(inputStream1, recursiveOutputStream, shouldWriteToRepeatStream);
                                        }
                                        catch (Throwable throwable6) {
                                            throwable = throwable6;
                                            throw throwable6;
                                        }
                                        recursiveOutputStream.copyToOutputStream(outputStream);
                                    }
                                    catch (Throwable inputStream1) {
                                        throwable2 = inputStream1;
                                        throw inputStream1;
                                    }
                                    finally {
                                        if (recursiveOutputStream != null) {
                                            if (throwable2 != null) {
                                                try {
                                                    recursiveOutputStream.close();
                                                }
                                                catch (Throwable inputStream1) {
                                                    throwable2.addSuppressed(inputStream1);
                                                }
                                            } else {
                                                recursiveOutputStream.close();
                                            }
                                        }
                                    }
                                    repeatBuffer.setLength(0L);
                                    tempBuffer.setLength(0L);
                                    isRepeating = false;
                                    bracketCount = 0;
                                }
                                catch (Throwable recursiveOutputStream3) {
                                    throwable3 = recursiveOutputStream3;
                                    throw recursiveOutputStream3;
                                }
                            }
                        }
                    }
                    if (60 == i && xmlTag == 0) {
                        i = bufferedReader.read();
                        while (62 != i && i != -1) {
                            charAsUTF8String = Character.valueOf((char)i).toString();
                            xmlRepeatTagList.add(Character.valueOf((char)i));
                            repeatBuffer.write(charAsUTF8String.getBytes(Charsets.UTF_8));
                            i = bufferedReader.read();
                            charAsUTF8String = Character.valueOf((char)i).toString();
                        }
                        ++xmlTag;
                        repeatBuffer.write(charAsUTF8String.getBytes(Charsets.UTF_8));
                        xmlRepeatTag = "</" + this.readAsString(xmlRepeatTagList) + ">";
                    }
                    if (repeatBuffer.getLength() > 0L && !xmlRepeatTag.isEmpty() && repeatBuffer.toString().endsWith(xmlRepeatTag)) {
                        newCopyOutputStream = new ByteArrayBackupToFileOutputStream();
                        throwable3 = null;
                        try {
                            repeatBuffer.copyToOutputStream(newCopyOutputStream);
                            this.copyRepeatStream(repeatTimes, repeatBuffer, newCopyOutputStream, NEWLINE_BYTE_ARRAY);
                            recursiveOutputStream = new ByteArrayBackupToFileOutputStream();
                            throwable2 = null;
                            try {
                                newCopyOutputStreamNewInputStream = newCopyOutputStream.getNewInputStream();
                                throwable = null;
                                try {
                                    this.handleRepeats(newCopyOutputStreamNewInputStream, recursiveOutputStream, shouldWriteToRepeatStream);
                                }
                                catch (Throwable throwable7) {
                                    throwable = throwable7;
                                    throw throwable7;
                                }
                                finally {
                                    if (newCopyOutputStreamNewInputStream != null) {
                                        if (throwable != null) {
                                            try {
                                                newCopyOutputStreamNewInputStream.close();
                                            }
                                            catch (Throwable throwable8) {
                                                throwable.addSuppressed(throwable8);
                                            }
                                        } else {
                                            newCopyOutputStreamNewInputStream.close();
                                        }
                                    }
                                }
                                recursiveOutputStream.copyToOutputStream(outputStream);
                                repeatBuffer.setLength(0L);
                                tempBuffer.setLength(0L);
                                isRepeating = false;
                                bracketCount = 0;
                                xmlTag = 0;
                            }
                            catch (Throwable throwable9) {
                                throwable2 = throwable9;
                                throw throwable9;
                            }
                            finally {
                                if (recursiveOutputStream != null) {
                                    if (throwable2 != null) {
                                        try {
                                            recursiveOutputStream.close();
                                        }
                                        catch (Throwable throwable10) {
                                            throwable2.addSuppressed(throwable10);
                                        }
                                    } else {
                                        recursiveOutputStream.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable11) {
                            throwable3 = throwable11;
                            throw throwable11;
                        }
                        finally {
                            if (newCopyOutputStream != null) {
                                if (throwable3 != null) {
                                    try {
                                        newCopyOutputStream.close();
                                    }
                                    catch (Throwable throwable12) {
                                        throwable3.addSuppressed(throwable12);
                                    }
                                } else {
                                    newCopyOutputStream.close();
                                }
                            }
                        }
                    }
                } else {
                    tempBuffer.write(charAsUTF8String.getBytes(Charsets.UTF_8));
                    lastCharQueue.add((Object)Character.valueOf((char)i));
                }
                if (lastCharQueue.peek() == null || !((Character)lastCharQueue.peek()).equals(Character.valueOf('\'')) || !REPEAT.equals(this.readAsString((CircularFifoQueue<Character>)lastCharQueue))) continue;
                tempBuffer.mark();
                bufferedReader.mark(1000);
                try {
                    i = bufferedReader.read();
                    charAsUTF8String = Character.valueOf((char)i).toString();
                    tempBuffer.write(charAsUTF8String.getBytes());
                    String repeatFunction = REPEAT;
                    while (i != 125) {
                        repeatFunction = repeatFunction + Character.toString((char)i);
                        i = bufferedReader.read();
                        charAsUTF8String = Character.valueOf((char)i).toString();
                        if (i == 125) continue;
                        tempBuffer.write(charAsUTF8String.getBytes());
                    }
                    tempBuffer.write((char)i);
                    i = bufferedReader.read();
                    tempBuffer.write((char)i);
                    if (i != 125) {
                        throw new IllegalStateException();
                    }
                    i = bufferedReader.read();
                    tempBuffer.write((char)i);
                    if (i != 39) {
                        throw new IllegalStateException();
                    }
                    i = bufferedReader.read();
                    tempBuffer.write((char)i);
                    if (i != 44) {
                        throw new IllegalStateException();
                    }
                    repeatTimes = this.parseRepeats(repeatFunction);
                    tempBuffer.setLength(tempBuffer.getLength() - (long)repeatFunction.length() - 4L);
                    tempBuffer.copyToOutputStream(outputStream);
                    tempBuffer.setLength(0L);
                    repeatBuffer.setLength(0L);
                    isRepeating = true;
                    bracketCount = 0;
                    lastCharQueue.clear();
                    xmlRepeatTagList.clear();
                }
                catch (IllegalStateException e) {
                    this.setQueueCharacters((CircularFifoQueue<Character>)lastCharQueue, REPEAT);
                    bufferedReader.reset();
                    tempBuffer.reset();
                }
            }
            bufferedReader.close();
            if (!shouldWriteToRepeatStream) return;
            tempBuffer.copyToOutputStream(outputStream);
            return;
        }
        finally {
            bufferedReader.close();
        }
    }

    private void copyRepeatStream(int repeatTimes, ByteArrayBackupToFileOutputStream repeatBuffer, ByteArrayBackupToFileOutputStream newCopyFileStream, byte[] separatorBytes) throws IOException {
        for (int j = 1; j < repeatTimes; ++j) {
            newCopyFileStream.write(separatorBytes);
            repeatBuffer.copyToOutputStream(newCopyFileStream);
        }
    }

    private int parseRepeats(String repeatArguments) {
        FunctionTokenResolver functionTokenResolver = new FunctionTokenResolver(this.functionRegistry);
        String result = functionTokenResolver.resolveToken(repeatArguments.substring(3));
        return Integer.parseInt(result);
    }

    private String readAsString(CircularFifoQueue<Character> characters) {
        char[] charArray = new char[characters.size()];
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = ((Character)characters.get(i)).charValue();
        }
        return new String(charArray);
    }

    private String readAsString(List<Character> characters) {
        char[] charArray = new char[characters.size()];
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = characters.get(i).charValue();
        }
        return new String(charArray);
    }

    private void setQueueCharacters(CircularFifoQueue<Character> characters, String string) {
        characters.clear();
        char[] charArray = string.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            characters.add((Object)Character.valueOf(charArray[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNestedFunctions(InputStream inputStream, OutputStream outputStream) throws IOException {
        FunctionReplacingReader reader = new FunctionReplacingReader(new InputStreamReader(inputStream, Charsets.UTF_8), new FunctionTokenResolver(this.functionRegistry));
        int data = 0;
        try {
            while ((data = ((Reader)reader).read()) != -1) {
                String charAsUTF8String = Character.valueOf((char)data).toString();
                outputStream.write(charAsUTF8String.getBytes(Charsets.UTF_8));
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((Reader)reader);
        }
    }
}

