/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.visitor;

import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.schema.Column;

public class OnVisitorMatchLookupBuilder
extends ExpressionVisitorAdapter {
    private String joinAliasTable;
    private String baseAliasTable;

    public OnVisitorMatchLookupBuilder(String joinAliasTable, String baseAliasTable) {
        this.joinAliasTable = joinAliasTable;
        this.baseAliasTable = baseAliasTable;
    }

    public void visit(Column column) {
        if (SqlUtils.isColumn((Expression)column)) {
            String columnName = column.getTable() != null ? SqlUtils.getColumnNameFromColumn(column) : column.getColumnName();
            if (!SqlUtils.isTableAliasOfColumn(column, this.joinAliasTable)) {
                if (column.getTable() == null || SqlUtils.isTableAliasOfColumn(column, this.baseAliasTable)) {
                    column.setColumnName("$$" + columnName.replace(".", "_").toLowerCase());
                } else {
                    column.setColumnName("$$" + column.getName(false).replace(".", "_").toLowerCase());
                }
                column.setTable(null);
            } else {
                column.setTable(null);
                column.setColumnName("$" + columnName);
            }
        }
    }
}

