/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter;

import com.github.vincentrussell.query.mongodb.sql.converter.NonCloseableBufferedOutputStream;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.QueryConverter;
import com.github.vincentrussell.query.mongodb.sql.converter.QueryResultIterator;
import com.github.vincentrussell.query.mongodb.sql.converter.TimeoutInputStream;
import com.github.vincentrussell.query.mongodb.sql.converter.UncloseableInputStream;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mongodb.Block;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.bson.Document;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;

public final class Main {
    public static final int DEFAULT_RESULT_BATCH_SIZE = 50;
    private static final JsonWriterSettings JSON_WRITER_SETTINGS = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).indentCharacters("\t").newLineCharacters("\n").build();
    public static final String ENTER_SQL_TEXT = "Enter input sql:\n\n ";
    public static final String CONTINUE_TEXT = "Would you like to continue? (y/n):\n\n ";
    private static final String DEFAULT_MONGO_PORT = "27017";
    public static final String D_AGGREGATION_ALLOW_DISK_USE = "aggregationAllowDiskUse";
    public static final String D_AGGREGATION_BATCH_SIZE = "aggregationBatchSize";

    private Main() {
    }

    private static Options buildOptions() {
        Options options = new Options();
        OptionGroup sourceOptionGroup = new OptionGroup();
        sourceOptionGroup.setRequired(false);
        sourceOptionGroup.addOption(Option.builder((String)"s").longOpt("sourceFile").hasArg(true).required(false).desc("the source file.").build());
        sourceOptionGroup.addOption(Option.builder((String)"i").longOpt("interactiveMode").hasArg(false).required(false).desc("interactive mode").build());
        sourceOptionGroup.addOption(Option.builder((String)"sql").longOpt("sql").hasArg(true).required(false).desc("the sql select statement").build());
        options.addOption(Option.builder((String)"d").longOpt("destinationFile").hasArg(true).required(false).desc("the destination file.  Defaults to System.out").build());
        options.addOption(Option.builder((String)"h").longOpt("host").hasArg(true).required(false).desc("hosts and ports in the following format (host:port) default port is 27017").build());
        options.addOption(Option.builder((String)"db").longOpt("database").hasArg(true).required(false).desc("mongo database").build());
        options.addOption(Option.builder((String)"a").longOpt("auth database").hasArg(true).required(false).desc("auth mongo database").build());
        options.addOption(Option.builder((String)"u").longOpt("username").hasArg(true).required(false).desc("usename").build());
        options.addOption(Option.builder((String)"p").longOpt("password").hasArg(true).required(false).desc("password").build());
        options.addOption(Option.builder((String)"b").longOpt("batchSize").hasArg(true).required(false).desc("batch size for query results").build());
        options.addOption(Option.builder((String)"l").longOpt("loopMode").hasArg(false).required(false).desc("interactive loopMode mode").build());
        options.addOptionGroup(sourceOptionGroup);
        return options;
    }

    /*
     * Exception decompiling
     */
    public static void main(String[] args) throws IOException, ParseException, org.apache.commons.cli.ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean shouldContinue() throws IOException {
        return "y".equals(Main.getCharacterInput(CONTINUE_TEXT).trim().toLowerCase());
    }

    private static void verifyArguments(CommandLine cmd) throws org.apache.commons.cli.ParseException {
        String source = cmd.getOptionValue("s");
        boolean interactiveMode = cmd.hasOption('i');
        String[] hosts = cmd.getOptionValues("h");
        String sql = cmd.getOptionValue("sql");
        String db = cmd.getOptionValue("db");
        String username = cmd.getOptionValue("u");
        String password = cmd.getOptionValue("p");
        String authdb = cmd.getOptionValue("a");
        Main.isTrue(interactiveMode || source != null || sql != null, "Missing required option: s or i or sql");
        Main.isFalse(hosts != null && db == null, "provided option h, but missing db");
        Main.isFalse(username != null && (password == null || authdb == null), "provided option u, but missing p or a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runQueryInMongo(CommandLine cmd, String[] hosts, OutputStream outputStream, QueryConverter queryConverter) throws ParseException, IOException {
        String db = cmd.getOptionValue("db");
        String username = cmd.getOptionValue("u");
        String password = cmd.getOptionValue("p");
        String authdb = cmd.getOptionValue("a");
        int batchSize = Integer.parseInt(cmd.getOptionValue("b", "50"));
        try (MongoClient mongoClient = null;){
            mongoClient = Main.getMongoClient(hosts, authdb, username, password);
            Object result = queryConverter.run(mongoClient.getDatabase(db));
            if (Long.class.isInstance(result) || Long.TYPE.isInstance(result)) {
                IOUtils.write((String)"\n\n******Query Results:*********\n\n", (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
                IOUtils.write((String)("" + result), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
                IOUtils.write((String)"\n\n", (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
            } else if (QueryResultIterator.class.isInstance(result)) {
                Main.processMongoResults(batchSize, outputStream, (QueryResultIterator)((Object)result));
            }
        }
    }

    private static QueryConverter getQueryConverter(InputStream inputStream) throws ParseException {
        QueryConverter.Builder builder = new QueryConverter.Builder().sqlInputStream(inputStream);
        if (System.getProperty(D_AGGREGATION_ALLOW_DISK_USE) != null) {
            builder.aggregationAllowDiskUse(Boolean.valueOf(System.getProperty(D_AGGREGATION_ALLOW_DISK_USE)));
        }
        if (System.getProperty(D_AGGREGATION_BATCH_SIZE) != null) {
            try {
                builder.aggregationBatchSize(Integer.valueOf(System.getProperty(D_AGGREGATION_BATCH_SIZE)));
            }
            catch (NumberFormatException formatException) {
                System.err.println(formatException.getMessage());
            }
        }
        return builder.build();
    }

    private static OutputStream getOutputStream(CommandLine cmd) throws IOException {
        String destination = cmd.getOptionValue("d");
        OutputStream outputStream = null;
        if (destination != null) {
            File destinationFile = new File(destination);
            if (destinationFile.exists()) {
                throw new IOException(destination + " already exists");
            }
            outputStream = new FileOutputStream(destinationFile);
        } else {
            outputStream = new NonCloseableBufferedOutputStream(System.out);
        }
        return outputStream;
    }

    private static InputStream getInputStream(CommandLine cmd) throws FileNotFoundException {
        String source = cmd.getOptionValue("s");
        boolean interactiveMode = cmd.hasOption('i');
        String sql = cmd.getOptionValue("sql");
        InputStream inputStream = null;
        if (interactiveMode) {
            inputStream = new TimeoutInputStream(new UncloseableInputStream(System.in), 1L, TimeUnit.SECONDS);
            System.out.println(ENTER_SQL_TEXT);
        } else if (sql != null) {
            inputStream = new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8));
        } else {
            File sourceFile = new File(source);
            if (!sourceFile.exists()) {
                throw new FileNotFoundException(source + " cannot be found");
            }
            inputStream = new FileInputStream(sourceFile);
        }
        return inputStream;
    }

    private static void processMongoResults(int batchSize, OutputStream outputStream, QueryResultIterator result) throws IOException {
        QueryResultIterator iterator = result;
        if (FileOutputStream.class.isInstance(outputStream)) {
            IOUtils.write((String)"[", (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
            while (iterator.hasNext()) {
                IOUtils.write((String)((Document)iterator.next()).toJson(), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
                if (!iterator.hasNext()) continue;
                IOUtils.write((String)",\n", (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
            }
            IOUtils.write((String)"]", (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
        } else {
            IOUtils.write((String)"\n\n******Query Results:*********\n\n", (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
            UnmodifiableIterator listIterator = Iterators.partition((Iterator)((Object)iterator), (int)batchSize);
            block1: while (listIterator.hasNext()) {
                String continueString;
                List documents = (List)listIterator.next();
                IOUtils.write((String)(Main.toJson(documents) + "\n\n"), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
                outputStream.flush();
                if (!listIterator.hasNext()) continue;
                while (!"n".equals((continueString = Main.getCharacterInput("more results? (y/n): ")).trim().toLowerCase())) {
                    if (!"y".equals(continueString.trim().toLowerCase())) continue;
                    continue block1;
                }
                break block1;
            }
        }
    }

    private static String getCharacterInput(final String question) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        Future<String> future = executorService.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String choice;
                Scanner scanner;
                System.out.print(question);
                while (true) {
                    scanner = new Scanner((InputStream)new UncloseableInputStream(System.in), Charsets.UTF_8.displayName());
                    choice = "";
                    if (scanner.hasNext()) break;
                    Thread.sleep(200L);
                }
                choice = scanner.next();
                return choice;
            }
        });
        try {
            return future.get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IOException(e);
        }
    }

    private static String toJson(List<Document> documents) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.write((String)"[", (Writer)stringWriter);
        IOUtils.write((String)Joiner.on((String)",").join((Iterable)Lists.transform(documents, (Function)new Function<Document, String>(){

            public String apply(@Nonnull Document document) {
                return document.toJson(JSON_WRITER_SETTINGS);
            }
        })), (Writer)stringWriter);
        IOUtils.write((String)"]", (Writer)stringWriter);
        return stringWriter.toString();
    }

    private static MongoClient getMongoClient(String[] hosts, String authdb, String username, String password) {
        final Pattern hostAndPort = Pattern.compile("^(.[^:]*){1}([:]){0,1}(\\d+){0,1}$");
        final List serverAddresses = Lists.transform(Arrays.asList(hosts), (Function)new Function<String, ServerAddress>(){

            public ServerAddress apply(@Nonnull String string) {
                Matcher matcher = hostAndPort.matcher(string.trim());
                if (matcher.matches()) {
                    String hostname = matcher.group(1);
                    String port = matcher.group(3);
                    return new ServerAddress(hostname, port != null ? Integer.parseInt(port) : Integer.parseInt(Main.DEFAULT_MONGO_PORT));
                }
                throw new IllegalArgumentException(string + " doesn't appear to be a hostname.");
            }
        });
        MongoClientSettings.Builder mongoClientSettingsBuilder = MongoClientSettings.builder();
        mongoClientSettingsBuilder.applyToClusterSettings((Block)new Block<ClusterSettings.Builder>(){

            public void apply(ClusterSettings.Builder builder) {
                builder.hosts(serverAddresses);
            }
        });
        if (username != null && password != null) {
            char[] p = password.toCharArray();
            MongoCredential credential = MongoCredential.createCredential((String)username, (String)authdb, (char[])p);
            mongoClientSettingsBuilder.credential(credential);
        }
        return MongoClients.create((MongoClientSettings)mongoClientSettingsBuilder.build());
    }

    private static void isTrue(boolean expression, String message) throws org.apache.commons.cli.ParseException {
        if (!expression) {
            throw new org.apache.commons.cli.ParseException(message);
        }
    }

    private static void isFalse(boolean expression, String message) throws org.apache.commons.cli.ParseException {
        if (expression) {
            throw new org.apache.commons.cli.ParseException(message);
        }
    }

    private static class OptionComparator
    implements Comparator<Option>,
    Serializable {
        private final List<String> orderList;

        OptionComparator(List<String> orderList) {
            this.orderList = orderList;
        }

        @Override
        public int compare(Option o1, Option o2) {
            int index1 = this.orderList.indexOf(o1.getOpt());
            int index2 = this.orderList.indexOf(o2.getOpt());
            return index1 - index2;
        }
    }
}

