/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 332235693126829948L;

    public ParseException(String message) {
        super(message);
    }

    public ParseException(String message, Throwable cause) {
        super(message, cause);
    }

    public ParseException(Throwable e) {
        super(ParseException.fixErrorMessage(e));
    }

    private static Throwable fixErrorMessage(Throwable e) {
        if (e.getMessage().startsWith("Encountered unexpected token: \"=\" \"=\"")) {
            return new ParseException("unable to parse complete sql string. one reason for this is the use of double equals (==).", e);
        }
        if (e.getMessage().startsWith("Encountered \" \"(\" \"( \"\"")) {
            return new ParseException("Only one simple table name is supported.", e);
        }
        if (e.getMessage().contains("Was expecting:" + System.getProperty("line.separator") + "    \"SELECT\"")) {
            return new ParseException("Only select statements are supported.", e);
        }
        return e;
    }
}

