/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.holder;

import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import java.util.Collections;
import java.util.Map;

public class AliasHolder {
    private Map<String, String> aliasFromFieldHash;
    private Map<String, String> fieldFromAliasHash;

    public AliasHolder(Map<String, String> aliasFromFieldMap, Map<String, String> fieldFromAliasMap) {
        this.aliasFromFieldHash = aliasFromFieldMap;
        this.fieldFromAliasHash = fieldFromAliasMap;
    }

    public AliasHolder() {
        this(Collections.emptyMap(), Collections.emptyMap());
    }

    public String getAliasFromFieldExp(String field) {
        return this.aliasFromFieldHash.get(field);
    }

    public boolean containsAliasForFieldExp(String field) {
        return this.aliasFromFieldHash.containsKey(field);
    }

    public String getFieldFromAliasOrField(String fieldOrAlias) throws ParseException {
        if (!this.isAmbiguous(fieldOrAlias)) {
            String field = this.fieldFromAliasHash.get(fieldOrAlias);
            if (field == null) {
                return fieldOrAlias;
            }
            return field;
        }
        throw new ParseException("Ambiguous field: " + fieldOrAlias);
    }

    public boolean isEmpty() {
        return this.aliasFromFieldHash.isEmpty();
    }

    private boolean isAmbiguous(String fieldOrAlias) {
        String aliasFromField = this.aliasFromFieldHash.get(fieldOrAlias);
        String fieldFromAlias = this.fieldFromAliasHash.get(fieldOrAlias);
        return aliasFromField != null && fieldFromAlias != null && !aliasFromField.equals(fieldFromAlias);
    }

    public void combine(AliasHolder aliasHolder) {
        this.aliasFromFieldHash.putAll(aliasHolder.aliasFromFieldHash);
        this.fieldFromAliasHash.putAll(aliasHolder.fieldFromAliasHash);
    }
}

