/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.processor;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.AliasHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.util.DateFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.ObjectIdFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.RegexFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import org.bson.Document;

public class WhereClauseProcessor {
    private final FieldType defaultFieldType;
    private final Map<String, FieldType> fieldNameToFieldTypeMapping;
    private final boolean requiresMultistepAggregation;
    protected AliasHolder aliasHolder;

    public WhereClauseProcessor(FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping, boolean requiresMultistepAggregation, AliasHolder aliasHolder) {
        this.defaultFieldType = defaultFieldType;
        this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping;
        this.requiresMultistepAggregation = requiresMultistepAggregation;
        this.aliasHolder = aliasHolder;
    }

    public WhereClauseProcessor(FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping, boolean requiresMultistepAggregation) {
        this(defaultFieldType, fieldNameToFieldTypeMapping, requiresMultistepAggregation, new AliasHolder());
    }

    public WhereClauseProcessor(FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) {
        this(defaultFieldType, fieldNameToFieldTypeMapping, false);
    }

    private void parseComparativeExpr(Document query, Expression leftExpression, Expression rightExpression, String comparatorType) throws ParseException {
        String operator = "$" + comparatorType;
        if (net.sf.jsqlparser.expression.Function.class.isInstance(leftExpression)) {
            Document doc = new Document();
            Object leftParse = this.parseExpression(new Document(), leftExpression, rightExpression);
            Object rightParse = this.parseExpression(new Document(), rightExpression, leftExpression);
            doc.put(operator, Arrays.asList(leftParse, SqlUtils.isColumn(rightExpression) && !rightExpression.toString().startsWith("$") ? "$" + rightParse : rightParse));
            if (this.requiresMultistepAggregation) {
                query.put("$expr", (Object)doc);
            } else {
                query.putAll((Map)doc);
            }
        } else if (SqlUtils.isColumn(leftExpression) && SqlUtils.isColumn(rightExpression)) {
            if (this.requiresMultistepAggregation) {
                Document doc = new Document();
                String leftName = ((Column)leftExpression).getName(false);
                String rightName = ((Column)rightExpression).getName(false);
                doc.put(operator, Arrays.asList(leftName.startsWith("$") ? leftName : "$" + leftName, rightName.startsWith("$") ? rightName : "$" + rightName));
                query.put("$expr", (Object)doc);
            } else {
                query.put(this.parseExpression(new Document(), leftExpression, rightExpression).toString(), this.parseExpression(new Document(), rightExpression, leftExpression));
            }
        } else if (net.sf.jsqlparser.expression.Function.class.isInstance(rightExpression)) {
            Document doc = new Document();
            Object leftParse = this.parseExpression(new Document(), rightExpression, leftExpression);
            Object rightParse = this.parseExpression(new Document(), leftExpression, rightExpression);
            doc.put(operator, Arrays.asList(leftParse, SqlUtils.isColumn(leftExpression) && !leftExpression.toString().startsWith("$") ? "$" + rightParse : rightParse));
            if (this.requiresMultistepAggregation) {
                query.put("$expr", (Object)doc);
            } else {
                query.putAll((Map)doc);
            }
        } else if (SqlUtils.isColumn(leftExpression)) {
            Document subdocument = new Document();
            if (operator.equals("$eq")) {
                query.put(this.parseExpression(new Document(), leftExpression, rightExpression).toString(), this.parseExpression(new Document(), rightExpression, leftExpression));
            } else {
                subdocument.put(operator, this.parseExpression(new Document(), rightExpression, leftExpression));
                query.put(this.parseExpression(new Document(), leftExpression, rightExpression).toString(), (Object)subdocument);
            }
        } else {
            Document doc = new Document();
            Object leftParse = this.parseExpression(new Document(), leftExpression, rightExpression);
            doc.put(operator, Arrays.asList(leftParse, SqlUtils.nonFunctionToNode(rightExpression, this.requiresMultistepAggregation)));
            if (this.requiresMultistepAggregation) {
                query.put("$expr", (Object)doc);
            } else {
                Document subdocument = new Document();
                if ("eq".equals(comparatorType) && String.class.isInstance(leftParse)) {
                    query.put(leftParse.toString(), this.parseExpression(new Document(), rightExpression, leftExpression));
                } else if (String.class.isInstance(leftParse)) {
                    subdocument.put(operator, this.parseExpression(new Document(), rightExpression, leftExpression));
                    query.put(this.parseExpression(new Document(), leftExpression, rightExpression).toString(), (Object)subdocument);
                } else {
                    query.putAll((Map)doc);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object parseExpression(Document query, Expression incomingExpression, Expression otherSide) throws ParseException {
        if (ComparisonOperator.class.isInstance(incomingExpression)) {
            RegexFunction regexFunction = SqlUtils.isRegexFunction(incomingExpression);
            DateFunction dateFunction = SqlUtils.getDateFunction(incomingExpression);
            ObjectIdFunction objectIdFunction = SqlUtils.isObjectIdFunction(this, incomingExpression);
            if (regexFunction != null) {
                Document regexDocument = new Document("$regex", (Object)regexFunction.getRegex());
                if (regexFunction.getOptions() != null) {
                    regexDocument.append("$options", (Object)regexFunction.getOptions());
                }
                query.put(regexFunction.getColumn(), this.wrapIfIsNot(regexDocument, regexFunction));
                return query;
            }
            if (dateFunction != null) {
                query.put(dateFunction.getColumn(), (Object)new Document(dateFunction.getComparisonExpression(), (Object)dateFunction.getDate()));
                return query;
            }
            if (objectIdFunction != null) {
                query.put(objectIdFunction.getColumn(), objectIdFunction.toDocument());
                return query;
            }
            if (EqualsTo.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((EqualsTo)incomingExpression).getLeftExpression();
                Expression rightExpression = ((EqualsTo)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "eq");
                return query;
            }
            if (NotEqualsTo.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((NotEqualsTo)incomingExpression).getLeftExpression();
                Expression rightExpression = ((NotEqualsTo)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "ne");
                return query;
            }
            if (GreaterThan.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((GreaterThan)incomingExpression).getLeftExpression();
                Expression rightExpression = ((GreaterThan)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "gt");
                return query;
            }
            if (MinorThan.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((MinorThan)incomingExpression).getLeftExpression();
                Expression rightExpression = ((MinorThan)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "lt");
                return query;
            }
            if (GreaterThanEquals.class.isInstance(incomingExpression)) {
                Expression leftExpression = ((GreaterThanEquals)incomingExpression).getLeftExpression();
                Expression rightExpression = ((GreaterThanEquals)incomingExpression).getRightExpression();
                this.parseComparativeExpr(query, leftExpression, rightExpression, "gte");
                return query;
            }
            if (!MinorThanEquals.class.isInstance(incomingExpression)) return query;
            Expression leftExpression = ((MinorThanEquals)incomingExpression).getLeftExpression();
            Expression rightExpression = ((MinorThanEquals)incomingExpression).getRightExpression();
            this.parseComparativeExpr(query, leftExpression, rightExpression, "lte");
            return query;
        }
        if (LikeExpression.class.isInstance(incomingExpression) && Column.class.isInstance(((LikeExpression)incomingExpression).getLeftExpression()) && (StringValue.class.isInstance(((LikeExpression)incomingExpression).getRightExpression()) || Column.class.isInstance(((LikeExpression)incomingExpression).getRightExpression()))) {
            LikeExpression likeExpression = (LikeExpression)incomingExpression;
            String stringValueLeftSide = SqlUtils.getStringValue(likeExpression.getLeftExpression());
            String stringValueRightSide = SqlUtils.getStringValue(likeExpression.getRightExpression());
            String convertedRegexString = "^" + SqlUtils.replaceRegexCharacters(stringValueRightSide) + "$";
            Document document = new Document("$regex", (Object)convertedRegexString);
            document = likeExpression.isNot() ? new Document(stringValueLeftSide, (Object)new Document("$not", (Object)Pattern.compile(convertedRegexString))) : new Document(stringValueLeftSide, (Object)document);
            query.putAll((Map)document);
            return query;
        }
        if (IsNullExpression.class.isInstance(incomingExpression)) {
            IsNullExpression isNullExpression = (IsNullExpression)incomingExpression;
            if (net.sf.jsqlparser.expression.Function.class.isInstance(isNullExpression.getLeftExpression())) {
                Document result = ((Document)this.recurseFunctions(new Document(), isNullExpression.getLeftExpression(), this.defaultFieldType, this.fieldNameToFieldTypeMapping)).append("$exists", (Object)isNullExpression.isNot());
                query.putAll((Map)result);
                return query;
            }
            query.put(SqlUtils.getStringValue(isNullExpression.getLeftExpression()), (Object)new Document("$exists", (Object)isNullExpression.isNot()));
            return query;
        }
        if (InExpression.class.isInstance(incomingExpression)) {
            InExpression inExpression = (InExpression)incomingExpression;
            final Expression leftExpression = ((InExpression)incomingExpression).getLeftExpression();
            String leftExpressionAsString = SqlUtils.getStringValue(leftExpression);
            ObjectIdFunction objectIdFunction = SqlUtils.isObjectIdFunction(this, incomingExpression);
            if (objectIdFunction != null) {
                query.put(objectIdFunction.getColumn(), objectIdFunction.toDocument());
                return query;
            }
            List objectList = Lists.transform((List)((ExpressionList)inExpression.getRightItemsList()).getExpressions(), (Function)new Function<Expression, Object>(){

                public Object apply(Expression expression) {
                    try {
                        return WhereClauseProcessor.this.parseExpression(new Document(), expression, leftExpression);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            if (net.sf.jsqlparser.expression.Function.class.isInstance(leftExpression)) {
                String mongoInFunction = inExpression.isNot() ? "$fnin" : "$fin";
                query.put(mongoInFunction, (Object)new Document("function", this.parseExpression(new Document(), leftExpression, otherSide)).append("list", (Object)objectList));
                return query;
            }
            String mongoInFunction = inExpression.isNot() ? "$nin" : "$in";
            Document doc = new Document();
            if (this.requiresMultistepAggregation) {
                List<Object> lobj = Arrays.asList(SqlUtils.nonFunctionToNode(leftExpression, this.requiresMultistepAggregation), objectList);
                doc.put(mongoInFunction, lobj);
                query.put("$expr", (Object)doc);
                return query;
            }
            doc.put(leftExpressionAsString, (Object)new Document().append(mongoInFunction, (Object)objectList));
            query.putAll((Map)doc);
            return query;
        }
        if (Between.class.isInstance(incomingExpression)) {
            Between between = (Between)incomingExpression;
            GreaterThanEquals start = new GreaterThanEquals();
            start.setLeftExpression(between.getLeftExpression());
            start.setRightExpression(between.getBetweenExpressionStart());
            MinorThanEquals end = new MinorThanEquals();
            end.setLeftExpression(between.getLeftExpression());
            end.setRightExpression(between.getBetweenExpressionEnd());
            AndExpression andExpression = new AndExpression((Expression)(between.isNot() ? new NotExpression((Expression)start) : start), (Expression)(between.isNot() ? new NotExpression((Expression)end) : end));
            return this.parseExpression(query, (Expression)andExpression, otherSide);
        }
        if (AndExpression.class.isInstance(incomingExpression)) {
            this.handleAndOr("$and", (BinaryExpression)incomingExpression, query);
            return query;
        }
        if (OrExpression.class.isInstance(incomingExpression)) {
            this.handleAndOr("$or", (BinaryExpression)incomingExpression, query);
            return query;
        }
        if (Parenthesis.class.isInstance(incomingExpression)) {
            Parenthesis parenthesis = (Parenthesis)incomingExpression;
            return this.parseExpression(new Document(), parenthesis.getExpression(), null);
        }
        if (NotExpression.class.isInstance(incomingExpression)) {
            NotExpression notExpression = (NotExpression)incomingExpression;
            Expression expression = notExpression.getExpression();
            if (Parenthesis.class.isInstance(expression)) {
                return new Document("$nor", Arrays.asList(this.parseExpression(query, expression, otherSide)));
            }
            if (Column.class.isInstance(expression)) {
                return new Document(SqlUtils.getStringValue(expression), (Object)new Document("$ne", (Object)true));
            }
            if (!ComparisonOperator.class.isInstance(expression)) return query;
            Document parsedDocument = (Document)this.parseExpression(query, expression, otherSide);
            String column = (String)parsedDocument.keySet().iterator().next();
            Document value = (Document)parsedDocument.get((Object)column, Document.class);
            return new Document(column, (Object)new Document("$not", (Object)value));
        }
        if (!net.sf.jsqlparser.expression.Function.class.isInstance(incomingExpression)) {
            if (otherSide != null) return SqlUtils.getNormalizedValue(incomingExpression, otherSide, this.defaultFieldType, this.fieldNameToFieldTypeMapping, this.aliasHolder, null);
            return new Document(SqlUtils.getStringValue(incomingExpression), (Object)true);
        }
        net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)incomingExpression;
        RegexFunction regexFunction = SqlUtils.isRegexFunction(incomingExpression);
        ObjectIdFunction objectIdFunction = SqlUtils.isObjectIdFunction(this, incomingExpression);
        if (regexFunction == null) {
            if (objectIdFunction == null) return this.recurseFunctions(query, function, this.defaultFieldType, this.fieldNameToFieldTypeMapping);
            return objectIdFunction.toDocument();
        }
        Document regexDocument = new Document("$regex", (Object)regexFunction.getRegex());
        if (regexFunction.getOptions() != null) {
            regexDocument.append("$options", (Object)regexFunction.getOptions());
        }
        query.put(regexFunction.getColumn(), this.wrapIfIsNot(regexDocument, regexFunction));
        return query;
    }

    private Object wrapIfIsNot(Document regexDocument, RegexFunction regexFunction) {
        if (regexFunction.isNot()) {
            if (regexFunction.getOptions() != null) {
                throw new IllegalArgumentException("$not regex not supported with options");
            }
            return new Document("$not", (Object)Pattern.compile(regexFunction.getRegex()));
        }
        return regexDocument;
    }

    protected Object recurseFunctions(Document query, Object object, FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping) throws ParseException {
        if (net.sf.jsqlparser.expression.Function.class.isInstance(object)) {
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)object;
            query.put("$" + SqlUtils.translateFunctionName(function.getName()), this.recurseFunctions(new Document(), function.getParameters(), defaultFieldType, fieldNameToFieldTypeMapping));
        } else {
            if (ExpressionList.class.isInstance(object)) {
                ExpressionList expressionList = (ExpressionList)object;
                ArrayList<Object> objectList = new ArrayList<Object>();
                for (Expression expression : expressionList.getExpressions()) {
                    objectList.add(this.recurseFunctions(new Document(), expression, defaultFieldType, fieldNameToFieldTypeMapping));
                }
                return objectList.size() == 1 ? objectList.get(0) : objectList;
            }
            if (Expression.class.isInstance(object)) {
                return SqlUtils.getNormalizedValue((Expression)object, null, defaultFieldType, fieldNameToFieldTypeMapping, null);
            }
        }
        return query.isEmpty() ? null : query;
    }

    private void handleAndOr(String key, BinaryExpression incomingExpression, Document query) throws ParseException {
        Expression rightExpression;
        Expression leftExpression = incomingExpression.getLeftExpression();
        List result = this.flattenOrsOrAnds(new ArrayList(), leftExpression, leftExpression, rightExpression = incomingExpression.getRightExpression());
        if (result != null) {
            query.put(key, (Object)Lists.reverse((List)result));
        } else {
            query.put(key, Arrays.asList(this.parseExpression(new Document(), leftExpression, rightExpression), this.parseExpression(new Document(), rightExpression, leftExpression)));
        }
    }

    private List flattenOrsOrAnds(List arrayList, Expression firstExpression, Expression leftExpression, Expression rightExpression) throws ParseException {
        if (firstExpression.getClass().isInstance(leftExpression) && this.isOrAndExpression(leftExpression) && !this.isOrAndExpression(rightExpression)) {
            Expression left = ((BinaryExpression)leftExpression).getLeftExpression();
            Expression right = ((BinaryExpression)leftExpression).getRightExpression();
            arrayList.add(this.parseExpression(new Document(), rightExpression, null));
            List result = this.flattenOrsOrAnds(arrayList, firstExpression, left, right);
            if (result != null) {
                return arrayList;
            }
        } else {
            if (this.isOrAndExpression(firstExpression) && !this.isOrAndExpression(leftExpression) && !this.isOrAndExpression(rightExpression)) {
                arrayList.add(this.parseExpression(new Document(), rightExpression, null));
                arrayList.add(this.parseExpression(new Document(), leftExpression, null));
                return arrayList;
            }
            return null;
        }
        return null;
    }

    private boolean isOrAndExpression(Expression expression) {
        return OrExpression.class.isInstance(expression) || AndExpression.class.isInstance(expression);
    }
}

