/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.util;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.AliasHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.processor.WhereClauseProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.util.DateFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.ObjectIdFunction;
import com.github.vincentrussell.query.mongodb.sql.converter.util.RegexFunction;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.Parser;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.bson.Document;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class SqlUtils {
    private static final Pattern SURROUNDED_IN_QUOTES = Pattern.compile("^\"(.+)*\"$");
    private static final Pattern LIKE_RANGE_REGEX = Pattern.compile("(\\[.+?\\])");
    private static final String REGEXMATCH_FUNCTION = "regexMatch";
    private static final String NOT_REGEXMATCH_FUNCTION = "notRegexMatch";
    private static final DateTimeFormatter YY_MM_DDFORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter YYMMDDFORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private static final Map<String, String> FUNCTION_MAPPER = new ImmutableMap.Builder().put((Object)"OID", (Object)"toObjectId").put((Object)"TIMESTAMP", (Object)"toDate").build();
    private static final Collection<DateTimeFormatter> FORMATTERS = Collections.unmodifiableList(Arrays.asList(ISODateTimeFormat.dateTime(), YY_MM_DDFORMATTER, YYMMDDFORMATTER));
    private static final Character NEGATIVE_NUMBER_SIGN = Character.valueOf('-');

    private SqlUtils() {
    }

    public static String getStringValue(Expression expression) {
        if (StringValue.class.isInstance(expression)) {
            return ((StringValue)expression).getValue();
        }
        if (Column.class.isInstance(expression)) {
            String columnName = expression.toString();
            Matcher matcher = SURROUNDED_IN_QUOTES.matcher(columnName);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return columnName;
        }
        return expression.toString();
    }

    public static Object getNormalizedValue(Expression incomingExpression, Expression otherSide, FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping, Character sign) throws ParseException {
        return SqlUtils.getNormalizedValue(incomingExpression, otherSide, defaultFieldType, fieldNameToFieldTypeMapping, new AliasHolder(), sign);
    }

    public static Object getNormalizedValue(Expression incomingExpression, Expression otherSide, FieldType defaultFieldType, Map<String, FieldType> fieldNameToFieldTypeMapping, AliasHolder aliasHolder, Character sign) throws ParseException {
        FieldType fieldType;
        FieldType fieldType2 = fieldType = otherSide != null ? (FieldType)((Object)MoreObjects.firstNonNull((Object)((Object)fieldNameToFieldTypeMapping.get(SqlUtils.getStringValue(otherSide))), (Object)((Object)defaultFieldType))) : FieldType.UNKNOWN;
        if (LongValue.class.isInstance(incomingExpression)) {
            return SqlUtils.getNormalizedValue(SqlUtils.convertToNegativeIfNeeded(((LongValue)incomingExpression).getValue(), sign), fieldType);
        }
        if (DoubleValue.class.isInstance(incomingExpression)) {
            return SqlUtils.getNormalizedValue(SqlUtils.convertToNegativeIfNeeded(((DoubleValue)incomingExpression).getValue(), sign), fieldType);
        }
        if (SignedExpression.class.isInstance(incomingExpression)) {
            SignedExpression signedExpression = (SignedExpression)incomingExpression;
            return SqlUtils.getNormalizedValue(signedExpression.getExpression(), otherSide, defaultFieldType, fieldNameToFieldTypeMapping, aliasHolder, Character.valueOf(signedExpression.getSign()));
        }
        if (StringValue.class.isInstance(incomingExpression)) {
            return SqlUtils.getNormalizedValue(((StringValue)incomingExpression).getValue(), fieldType);
        }
        if (Column.class.isInstance(incomingExpression)) {
            Object normalizedColumn = SqlUtils.getNormalizedValue(SqlUtils.getStringValue(incomingExpression), fieldType);
            if (aliasHolder != null && !aliasHolder.isEmpty() && String.class.isInstance(normalizedColumn) && aliasHolder.containsAliasForFieldExp((String)normalizedColumn)) {
                return aliasHolder.getAliasFromFieldExp((String)normalizedColumn);
            }
            return normalizedColumn;
        }
        if (TimestampValue.class.isInstance(incomingExpression)) {
            return SqlUtils.getNormalizedValue(new Date(((TimestampValue)incomingExpression).getValue().getTime()), fieldType);
        }
        if (DateValue.class.isInstance(incomingExpression)) {
            return SqlUtils.getNormalizedValue(((DateValue)incomingExpression).getValue(), fieldType);
        }
        throw new ParseException("can not parseNaturalLanguageDate: " + incomingExpression.toString());
    }

    private static Object convertToNegativeIfNeeded(Number number, Character sign) throws ParseException {
        if (NEGATIVE_NUMBER_SIGN.equals(sign)) {
            if (Integer.class.isInstance(number)) {
                return -((Integer)number).intValue();
            }
            if (Long.class.isInstance(number)) {
                return -((Long)number).longValue();
            }
            if (Double.class.isInstance(number)) {
                return -((Double)number).doubleValue();
            }
            if (Float.class.isInstance(number)) {
                return Float.valueOf(-((Float)number).floatValue());
            }
            throw new ParseException(String.format("could not convert %s into negative number", number));
        }
        return number;
    }

    public static Object getNormalizedValue(Object value, FieldType fieldType) throws ParseException {
        if (fieldType == null || FieldType.UNKNOWN.equals((Object)fieldType)) {
            Object bool = SqlUtils.getObjectAsBoolean(value);
            return bool != null ? bool : value;
        }
        if (FieldType.STRING.equals((Object)fieldType)) {
            return SqlUtils.fixDoubleSingleQuotes(SqlUtils.forceString(value));
        }
        if (FieldType.NUMBER.equals((Object)fieldType)) {
            return SqlUtils.getObjectAsNumber(value);
        }
        if (FieldType.DATE.equals((Object)fieldType)) {
            return SqlUtils.getObjectAsDate(value);
        }
        if (FieldType.BOOLEAN.equals((Object)fieldType)) {
            return Boolean.valueOf(value.toString());
        }
        throw new ParseException("could not normalize value:" + value);
    }

    private static long getLongFromStringIfInteger(String stringValue) throws ParseException {
        BigInteger bigInt = new BigInteger(stringValue);
        SqlUtils.isFalse(bigInt.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0, stringValue + ": value is too large");
        return bigInt.longValue();
    }

    public static long getLimitAsLong(Limit limit) throws ParseException {
        if (limit != null) {
            return SqlUtils.getLongFromStringIfInteger(SqlUtils.getStringValue(limit.getRowCount()));
        }
        return -1L;
    }

    public static long getOffsetAsLong(Offset offset) {
        if (offset != null && LongValue.class.isInstance(offset.getOffset())) {
            return ((LongValue)offset.getOffset()).getValue();
        }
        return -1L;
    }

    public static String fixDoubleSingleQuotes(String regex) {
        return regex.replaceAll("''", "'");
    }

    public static boolean isSelectAll(List<SelectItem> selectItems) {
        if (selectItems != null && selectItems.size() == 1) {
            SelectItem firstItem = selectItems.get(0);
            return AllColumns.class.isInstance(firstItem);
        }
        return false;
    }

    public static boolean isCountAll(List<SelectItem> selectItems) {
        net.sf.jsqlparser.expression.Function function;
        SelectItem firstItem;
        return selectItems != null && selectItems.size() == 1 && SelectExpressionItem.class.isInstance(firstItem = selectItems.get(0)) && net.sf.jsqlparser.expression.Function.class.isInstance(((SelectExpressionItem)firstItem).getExpression()) && "count(*)".equals((function = (net.sf.jsqlparser.expression.Function)((SelectExpressionItem)firstItem).getExpression()).toString());
    }

    public static Object getObjectAsBoolean(Object value) {
        if (value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("false")) {
            return Boolean.valueOf(value.toString());
        }
        return null;
    }

    public static Object getObjectAsDate(Object value) throws ParseException {
        if (String.class.isInstance(value)) {
            for (DateTimeFormatter formatter : FORMATTERS) {
                try {
                    DateTime dt = formatter.parseDateTime((String)value);
                    return dt.toDate();
                }
                catch (Exception exception) {
                }
            }
            try {
                return SqlUtils.parseNaturalLanguageDate((String)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException("could not convert " + value + " to a date");
    }

    public static Date parseNaturalLanguageDate(String text) {
        Parser parser = new Parser();
        List groups = parser.parse(text);
        for (DateGroup group : groups) {
            List dates = group.getDates();
            if (dates.size() <= 0) continue;
            return (Date)dates.get(0);
        }
        throw new IllegalArgumentException("could not natural language date: " + text);
    }

    public static Object getObjectAsNumber(Object value) throws ParseException {
        if (String.class.isInstance(value)) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e1) {
                try {
                    return Double.parseDouble((String)value);
                }
                catch (NumberFormatException e2) {
                    try {
                        return Float.valueOf(Float.parseFloat((String)value));
                    }
                    catch (NumberFormatException e3) {
                        throw new ParseException("could not convert " + value + " to number", e3);
                    }
                }
            }
        }
        return value;
    }

    public static String forceString(Object value) {
        if (String.class.isInstance(value)) {
            return (String)value;
        }
        return "" + value + "";
    }

    public static ParseException convertParseException(net.sf.jsqlparser.parser.ParseException parseException) {
        return new ParseException((Throwable)parseException);
    }

    public static String replaceRegexCharacters(String value) {
        String newValue = value.replaceAll("%", ".*").replaceAll("_", ".{1}");
        Matcher m = LIKE_RANGE_REGEX.matcher(newValue);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1) + "{1}");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static List<String> getGroupByColumnReferences(PlainSelect plainSelect) {
        if (plainSelect.getGroupBy() == null) {
            return Collections.emptyList();
        }
        return Lists.transform((List)plainSelect.getGroupBy().getGroupByExpressions(), (Function)new Function<Expression, String>(){

            public String apply(@Nonnull Expression expression) {
                return SqlUtils.getStringValue(expression);
            }
        });
    }

    public static ObjectIdFunction isObjectIdFunction(final WhereClauseProcessor whereClauseProcessor, Expression incomingExpression) throws ParseException {
        net.sf.jsqlparser.expression.Function function;
        if (ComparisonOperator.class.isInstance(incomingExpression)) {
            net.sf.jsqlparser.expression.Function function2;
            ComparisonOperator comparisonOperator = (ComparisonOperator)incomingExpression;
            String rightExpression = SqlUtils.getStringValue(comparisonOperator.getRightExpression());
            if (net.sf.jsqlparser.expression.Function.class.isInstance(comparisonOperator.getLeftExpression())) {
                net.sf.jsqlparser.expression.Function function3 = (net.sf.jsqlparser.expression.Function)comparisonOperator.getLeftExpression();
                if ("toobjectid".equals(function3.getName().toLowerCase()) && function3.getParameters().getExpressions().size() == 1 && StringValue.class.isInstance(function3.getParameters().getExpressions().get(0))) {
                    String column = SqlUtils.getStringValue((Expression)function3.getParameters().getExpressions().get(0));
                    return new ObjectIdFunction(column, rightExpression, (Expression)comparisonOperator);
                }
                if ("objectid".equals(function3.getName().toLowerCase()) && function3.getParameters().getExpressions().size() == 1 && StringValue.class.isInstance(function3.getParameters().getExpressions().get(0))) {
                    String column = SqlUtils.getStringValue((Expression)function3.getParameters().getExpressions().get(0));
                    return new ObjectIdFunction(column, rightExpression, (Expression)comparisonOperator);
                }
            } else if (net.sf.jsqlparser.expression.Function.class.isInstance(comparisonOperator.getRightExpression()) && "toobjectid".equals(SqlUtils.translateFunctionName((function2 = (net.sf.jsqlparser.expression.Function)comparisonOperator.getRightExpression()).getName()).toLowerCase()) && function2.getParameters().getExpressions().size() == 1 && StringValue.class.isInstance(function2.getParameters().getExpressions().get(0))) {
                String column = SqlUtils.getStringValue(comparisonOperator.getLeftExpression());
                return new ObjectIdFunction(column, SqlUtils.getStringValue((Expression)function2.getParameters().getExpressions().get(0)), (Expression)comparisonOperator);
            }
        } else if (InExpression.class.isInstance(incomingExpression)) {
            net.sf.jsqlparser.expression.Function function4;
            InExpression inExpression = (InExpression)incomingExpression;
            final Expression leftExpression = ((InExpression)incomingExpression).getLeftExpression();
            if (net.sf.jsqlparser.expression.Function.class.isInstance(inExpression.getLeftExpression()) && "objectid".equals((function4 = (net.sf.jsqlparser.expression.Function)inExpression.getLeftExpression()).getName().toLowerCase()) && function4.getParameters().getExpressions().size() == 1 && StringValue.class.isInstance(function4.getParameters().getExpressions().get(0))) {
                String column = SqlUtils.getStringValue((Expression)function4.getParameters().getExpressions().get(0));
                List rightExpression = Lists.transform((List)((ExpressionList)inExpression.getRightItemsList()).getExpressions(), (Function)new Function<Expression, Object>(){

                    public Object apply(Expression expression) {
                        try {
                            return whereClauseProcessor.parseExpression(new Document(), expression, leftExpression);
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                return new ObjectIdFunction(column, rightExpression, (Expression)inExpression);
            }
        } else if (net.sf.jsqlparser.expression.Function.class.isInstance(incomingExpression) && "toobjectid".equals(SqlUtils.translateFunctionName((function = (net.sf.jsqlparser.expression.Function)incomingExpression).getName()).toLowerCase()) && function.getParameters().getExpressions().size() == 1 && StringValue.class.isInstance(function.getParameters().getExpressions().get(0))) {
            return new ObjectIdFunction(null, SqlUtils.getStringValue((Expression)function.getParameters().getExpressions().get(0)), (Expression)new EqualsTo());
        }
        return null;
    }

    public static DateFunction getDateFunction(Expression incomingExpression) throws ParseException {
        if (ComparisonOperator.class.isInstance(incomingExpression)) {
            net.sf.jsqlparser.expression.Function function;
            ComparisonOperator comparisonOperator = (ComparisonOperator)incomingExpression;
            String rightExpression = SqlUtils.getStringValue(comparisonOperator.getRightExpression());
            if (net.sf.jsqlparser.expression.Function.class.isInstance(comparisonOperator.getLeftExpression()) && "date".equals((function = (net.sf.jsqlparser.expression.Function)comparisonOperator.getLeftExpression()).getName().toLowerCase()) && function.getParameters().getExpressions().size() == 2 && StringValue.class.isInstance(function.getParameters().getExpressions().get(1))) {
                String column = SqlUtils.getStringValue((Expression)function.getParameters().getExpressions().get(0));
                try {
                    return new DateFunction(((StringValue)function.getParameters().getExpressions().get(1)).getValue(), rightExpression, column, comparisonOperator);
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException(e);
                }
            }
        }
        return null;
    }

    public static RegexFunction isRegexFunction(Expression incomingExpression) throws ParseException {
        net.sf.jsqlparser.expression.Function function;
        if (EqualsTo.class.isInstance(incomingExpression)) {
            net.sf.jsqlparser.expression.Function function2;
            EqualsTo equalsTo = (EqualsTo)incomingExpression;
            String rightExpression = equalsTo.getRightExpression().toString();
            if (net.sf.jsqlparser.expression.Function.class.isInstance(equalsTo.getLeftExpression()) && (REGEXMATCH_FUNCTION.equalsIgnoreCase((function2 = (net.sf.jsqlparser.expression.Function)equalsTo.getLeftExpression()).getName()) || NOT_REGEXMATCH_FUNCTION.equalsIgnoreCase(function2.getName())) && (function2.getParameters().getExpressions().size() == 2 || function2.getParameters().getExpressions().size() == 3) && StringValue.class.isInstance(function2.getParameters().getExpressions().get(1))) {
                Boolean rightExpressionValue = Boolean.valueOf(rightExpression);
                SqlUtils.isTrue(rightExpressionValue, "false is not allowed for regexMatch function");
                RegexFunction regexFunction = SqlUtils.getRegexFunction(function2, NOT_REGEXMATCH_FUNCTION.equalsIgnoreCase(function2.getName()));
                return regexFunction;
            }
        } else if (net.sf.jsqlparser.expression.Function.class.isInstance(incomingExpression) && (REGEXMATCH_FUNCTION.equalsIgnoreCase((function = (net.sf.jsqlparser.expression.Function)incomingExpression).getName()) || NOT_REGEXMATCH_FUNCTION.equalsIgnoreCase(function.getName())) && (function.getParameters().getExpressions().size() == 2 || function.getParameters().getExpressions().size() == 3) && StringValue.class.isInstance(function.getParameters().getExpressions().get(1))) {
            RegexFunction regexFunction = SqlUtils.getRegexFunction(function, NOT_REGEXMATCH_FUNCTION.equalsIgnoreCase(function.getName()));
            return regexFunction;
        }
        return null;
    }

    private static RegexFunction getRegexFunction(net.sf.jsqlparser.expression.Function function, boolean isNot) throws ParseException {
        String column = SqlUtils.getStringValue((Expression)function.getParameters().getExpressions().get(0));
        String regex = SqlUtils.fixDoubleSingleQuotes(((StringValue)function.getParameters().getExpressions().get(1)).getValue());
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new ParseException(e);
        }
        RegexFunction regexFunction = new RegexFunction(column, regex, isNot);
        if (function.getParameters().getExpressions().size() == 3 && StringValue.class.isInstance(function.getParameters().getExpressions().get(2))) {
            regexFunction.setOptions(((StringValue)function.getParameters().getExpressions().get(2)).getValue());
        }
        return regexFunction;
    }

    public static void isTrue(boolean expression, String message) throws ParseException {
        if (!expression) {
            throw new ParseException(message);
        }
    }

    public static void isFalse(Boolean expression, String message) throws ParseException {
        if (expression.booleanValue()) {
            throw new ParseException(message);
        }
    }

    public static boolean isColumn(Expression expression) {
        return expression instanceof Column && !((Column)expression).getName(false).matches("^(\".*\"|true|false)$");
    }

    public static Column removeAliasFromColumn(Column column, String aliasBase) {
        column.setColumnName(column.getName(false).startsWith(aliasBase + ".") ? column.getName(false).substring(aliasBase.length() + 1) : column.getName(false));
        column.setTable(null);
        return column;
    }

    public static SelectExpressionItem removeAliasFromSelectExpressionItem(SelectExpressionItem selectExpressionItem, String aliasBase) {
        if (selectExpressionItem != null && Column.class.isInstance(selectExpressionItem.getExpression())) {
            SqlUtils.removeAliasFromColumn((Column)selectExpressionItem.getExpression(), aliasBase);
        }
        return selectExpressionItem;
    }

    public static String getColumnNameFromColumn(Column column) {
        String[] splitedNestedField = column.getName(false).split("\\.");
        if (splitedNestedField.length > 2) {
            return String.join((CharSequence)".", Arrays.copyOfRange(splitedNestedField, 1, splitedNestedField.length));
        }
        return splitedNestedField[splitedNestedField.length - 1];
    }

    public static boolean isTableAliasOfColumn(Column column, String tableAlias) {
        String columnName = column.getName(false);
        return columnName.startsWith(tableAlias);
    }

    public static void updateJoinType(Join join) {
        if (join.toString().toLowerCase().startsWith("join ")) {
            join.setInner(true);
        }
    }

    public static boolean isAggregateExpression(String field) {
        String fieldForAgg = field.trim().toLowerCase();
        return fieldForAgg.startsWith("sum(") || fieldForAgg.startsWith("avg(") || fieldForAgg.startsWith("min(") || fieldForAgg.startsWith("max(") || fieldForAgg.startsWith("count(");
    }

    public static Map.Entry<String, String> generateAggField(net.sf.jsqlparser.expression.Function function, Alias alias) throws ParseException {
        String aliasStr = alias == null ? null : alias.getName();
        return SqlUtils.generateAggField(function, aliasStr);
    }

    public static Map.Entry<String, String> generateAggField(net.sf.jsqlparser.expression.Function function, String alias) throws ParseException {
        String field = SqlUtils.getFieldFromFunction(function);
        String functionName = function.getName().toLowerCase();
        if ("*".equals(field) || functionName.equals("count")) {
            return new AbstractMap.SimpleEntry<String, String>(field, alias == null ? functionName : alias);
        }
        return new AbstractMap.SimpleEntry<String, String>(field, alias == null ? functionName + "_" + field.replaceAll("\\.", "_") : alias);
    }

    public static String getFieldFromFunction(net.sf.jsqlparser.expression.Function function) throws ParseException {
        List parameters;
        if (function.getParameters() != null && function.getParameters().getExpressions().size() == 1 && AllColumns.class.isInstance(function.getParameters().getExpressions().get(0))) {
            return null;
        }
        List list = parameters = function.getParameters() == null ? Collections.emptyList() : Lists.transform((List)function.getParameters().getExpressions(), (Function)new Function<Expression, String>(){

            public String apply(@Nonnull Expression expression) {
                return SqlUtils.getStringValue(expression);
            }
        });
        if (parameters.size() > 1) {
            throw new ParseException(function.getName() + " function can only have one parameter");
        }
        return parameters.size() > 0 ? (String)Iterables.get((Iterable)parameters, (int)0) : null;
    }

    public static Object nonFunctionToNode(Expression exp, boolean requiresMultistepAggregation) throws ParseException {
        return SqlUtils.isColumn(exp) && !exp.toString().startsWith("$") && requiresMultistepAggregation ? "$" + exp : SqlUtils.getNormalizedValue(exp, null, FieldType.UNKNOWN, null, null);
    }

    public static boolean isTotalGroup(List<SelectItem> selectItems) {
        for (SelectItem sitem : selectItems) {
            if (!SqlUtils.isAggregateExpression(sitem.toString())) continue;
            return true;
        }
        return false;
    }

    public static Expression cloneExpression(Expression expression) {
        if (expression == null) {
            return null;
        }
        try {
            return CCJSqlParserUtil.parseCondExpression((String)expression.toString());
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String translateFunctionName(String functionName) {
        String transfunction = FUNCTION_MAPPER.get(functionName);
        if (transfunction != null) {
            return transfunction;
        }
        return functionName;
    }
}

