/*
 * Decompiled with CFR 0.152.
 */
package com.github.vindell.jwt.token;

import com.github.vindell.jwt.JwtPayload;
import com.github.vindell.jwt.exception.IncorrectJwtException;
import com.github.vindell.jwt.exception.InvalidJwtToken;
import com.github.vindell.jwt.exception.JwtException;
import com.github.vindell.jwt.time.JwtTimeProvider;
import com.github.vindell.jwt.token.JwtRepository;
import com.github.vindell.jwt.utils.NimbusdsUtils;
import com.github.vindell.jwt.verifier.ExtendedECDSAVerifier;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SignedWithEcJWTRepository
implements JwtRepository<ECKey> {
    private JwtTimeProvider timeProvider = JwtTimeProvider.DEFAULT_TIME_PROVIDER;

    public String issueJwt(ECKey signingKey, String jwtId, String subject, String issuer, String audience, String roles, String permissions, String algorithm, long period) throws JwtException {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("roles", roles);
        claims.put("perms", permissions);
        return this.issueJwt(signingKey, jwtId, subject, issuer, audience, claims, algorithm, period);
    }

    public String issueJwt(ECKey signingKey, String jwtId, String subject, String issuer, String audience, Map<String, Object> claims, String algorithm, long period) throws JwtException {
        try {
            JWTClaimsSet.Builder builder = NimbusdsUtils.claimsSet(jwtId, subject, issuer, audience, claims, period);
            long currentTimeMillis = this.getTimeProvider().now();
            Date now = new Date(currentTimeMillis);
            builder.issueTime(now);
            builder.notBeforeTime(now);
            if (period >= 0L) {
                Date expiration = new Date(currentTimeMillis + period);
                builder.expirationTime(expiration);
            }
            JWTClaimsSet claimsSet = builder.build();
            JWSHeader jwsHeader = new JWSHeader.Builder(JWSAlgorithm.parse((String)algorithm)).build();
            SignedJWT signedJWT = new SignedJWT(jwsHeader, claimsSet);
            ECDSASigner signer = new ECDSASigner(signingKey);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (IllegalStateException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (KeyLengthException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (JOSEException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
    }

    public boolean verify(ECKey signingKey, String token, boolean checkExpiry) throws JwtException {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            ExtendedECDSAVerifier verifier = checkExpiry ? new ExtendedECDSAVerifier(signingKey, signedJWT.getJWTClaimsSet(), this.getTimeProvider()) : new ECDSAVerifier(signingKey);
            return signedJWT.verify((JWSVerifier)verifier);
        }
        catch (IllegalStateException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (ParseException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (JOSEException e) {
            throw new InvalidJwtToken((Throwable)e);
        }
    }

    public JwtPayload getPlayload(ECKey signingKey, String token, boolean checkExpiry) throws JwtException {
        try {
            ExtendedECDSAVerifier verifier;
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            ExtendedECDSAVerifier extendedECDSAVerifier = verifier = checkExpiry ? new ExtendedECDSAVerifier(signingKey, signedJWT.getJWTClaimsSet(), this.getTimeProvider()) : new ECDSAVerifier(signingKey);
            if (!signedJWT.verify((JWSVerifier)verifier)) {
                throw new JwtException(String.format("Invalid JSON Web Token (JWT) : %s", token));
            }
            return NimbusdsUtils.payload(signedJWT.getJWTClaimsSet());
        }
        catch (IllegalStateException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (ParseException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (JOSEException e) {
            throw new InvalidJwtToken((Throwable)e);
        }
    }

    public JwtTimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    public void setTimeProvider(JwtTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }
}

