/*
 * Decompiled with CFR 0.152.
 */
package com.github.vindell.jwt.token;

import com.github.vindell.jwt.JwtPayload;
import com.github.vindell.jwt.exception.IncorrectJwtException;
import com.github.vindell.jwt.exception.InvalidJwtToken;
import com.github.vindell.jwt.exception.JwtException;
import com.github.vindell.jwt.time.JwtTimeProvider;
import com.github.vindell.jwt.token.JwtRepository;
import com.github.vindell.jwt.utils.NimbusdsUtils;
import com.github.vindell.jwt.verifier.ExtendedEd25519Verifier;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.Ed25519Signer;
import com.nimbusds.jose.crypto.Ed25519Verifier;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SignedWithEdJWTRepository
implements JwtRepository<OctetKeyPair> {
    private JwtTimeProvider timeProvider = JwtTimeProvider.DEFAULT_TIME_PROVIDER;

    public String issueJwt(OctetKeyPair signingKey, String jwtId, String subject, String issuer, String audience, String roles, String permissions, String algorithm, long period) throws JwtException {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("roles", roles);
        claims.put("perms", permissions);
        return this.issueJwt(signingKey, jwtId, subject, issuer, audience, claims, algorithm, period);
    }

    public String issueJwt(OctetKeyPair signingKey, String jwtId, String subject, String issuer, String audience, Map<String, Object> claims, String algorithm, long period) throws JwtException {
        try {
            JWTClaimsSet.Builder builder = NimbusdsUtils.claimsSet(jwtId, subject, issuer, audience, claims, period);
            long currentTimeMillis = this.getTimeProvider().now();
            Date now = new Date(currentTimeMillis);
            builder.issueTime(now);
            builder.notBeforeTime(now);
            if (period >= 0L) {
                Date expiration = new Date(currentTimeMillis + period);
                builder.expirationTime(expiration);
            }
            JWTClaimsSet claimsSet = builder.build();
            JWSHeader jwsHeader = new JWSHeader.Builder(JWSAlgorithm.EdDSA).keyID(signingKey.getKeyID()).build();
            SignedJWT signedJWT = new SignedJWT(jwsHeader, claimsSet);
            Ed25519Signer signer = new Ed25519Signer(signingKey);
            signedJWT.sign((JWSSigner)signer);
            return signedJWT.serialize();
        }
        catch (IllegalStateException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (KeyLengthException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (JOSEException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
    }

    public boolean verify(OctetKeyPair signingKey, String token, boolean checkExpiry) throws JwtException {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            ExtendedEd25519Verifier verifier = checkExpiry ? new ExtendedEd25519Verifier(signingKey.toPublicJWK(), signedJWT.getJWTClaimsSet(), this.getTimeProvider()) : new Ed25519Verifier(signingKey.toPublicJWK());
            return signedJWT.verify((JWSVerifier)verifier);
        }
        catch (IllegalStateException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (ParseException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (JOSEException e) {
            throw new InvalidJwtToken((Throwable)e);
        }
    }

    public JwtPayload getPlayload(OctetKeyPair signingKey, String token, boolean checkExpiry) throws JwtException {
        try {
            ExtendedEd25519Verifier verifier;
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            ExtendedEd25519Verifier extendedEd25519Verifier = verifier = checkExpiry ? new ExtendedEd25519Verifier(signingKey.toPublicJWK(), signedJWT.getJWTClaimsSet(), this.getTimeProvider()) : new Ed25519Verifier(signingKey.toPublicJWK());
            if (!signedJWT.verify((JWSVerifier)verifier)) {
                throw new JwtException(String.format("Invalid JSON Web Token (JWT) : %s", token));
            }
            return NimbusdsUtils.payload(signedJWT.getJWTClaimsSet());
        }
        catch (IllegalStateException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (ParseException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (JOSEException e) {
            throw new InvalidJwtToken((Throwable)e);
        }
    }

    public JwtTimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    public void setTimeProvider(JwtTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }
}

