/*
 * Decompiled with CFR 0.152.
 */
package com.github.vindell.jwt.token;

import com.github.vindell.jwt.JwtPayload;
import com.github.vindell.jwt.exception.IncorrectJwtException;
import com.github.vindell.jwt.exception.InvalidJwtToken;
import com.github.vindell.jwt.exception.JwtException;
import com.github.vindell.jwt.time.JwtTimeProvider;
import com.github.vindell.jwt.token.JwtKeyPairRepository;
import com.github.vindell.jwt.utils.NimbusdsUtils;
import com.github.vindell.jwt.verifier.ExtendedRSASSAVerifier;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.DirectDecrypter;
import com.nimbusds.jose.crypto.DirectEncrypter;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;

public class SignedWithRsaAndEncryptedWithAESJWTRepository
implements JwtKeyPairRepository<RSAKey, SecretKey> {
    private JwtTimeProvider timeProvider = JwtTimeProvider.DEFAULT_TIME_PROVIDER;

    public String issueJwt(RSAKey signingKey, SecretKey secretKey, String jwtId, String subject, String issuer, String audience, String roles, String permissions, String algorithm, long period) throws JwtException {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("roles", roles);
        claims.put("perms", permissions);
        return this.issueJwt(signingKey, secretKey, jwtId, subject, issuer, audience, claims, algorithm, period);
    }

    public String issueJwt(RSAKey signingKey, SecretKey secretKey, String jwtId, String subject, String issuer, String audience, Map<String, Object> claims, String algorithm, long period) throws JwtException {
        try {
            JWTClaimsSet.Builder builder = NimbusdsUtils.claimsSet(jwtId, subject, issuer, audience, claims, period);
            long currentTimeMillis = this.getTimeProvider().now();
            Date now = new Date(currentTimeMillis);
            builder.issueTime(now);
            builder.notBeforeTime(now);
            if (period >= 0L) {
                Date expiration = new Date(currentTimeMillis + period);
                builder.expirationTime(expiration);
            }
            JWTClaimsSet claimsSet = builder.build();
            JWSHeader jwsHeader = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(signingKey.getKeyID()).build();
            SignedJWT signedJWT = new SignedJWT(jwsHeader, claimsSet);
            RSASSASigner signer = new RSASSASigner(signingKey);
            signedJWT.sign((JWSSigner)signer);
            JWEHeader jweHeader = new JWEHeader(JWEAlgorithm.DIR, EncryptionMethod.A128GCM);
            JWEObject jweObject = new JWEObject(jweHeader, new Payload(signedJWT));
            DirectEncrypter encrypter = new DirectEncrypter(secretKey);
            jweObject.encrypt((JWEEncrypter)encrypter);
            return jweObject.serialize();
        }
        catch (IllegalStateException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (KeyLengthException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (JOSEException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
    }

    public boolean verify(RSAKey signingKey, SecretKey secretKey, String token, boolean checkExpiry) throws JwtException {
        try {
            JWEObject jweObject = JWEObject.parse((String)token);
            jweObject.decrypt((JWEDecrypter)new DirectDecrypter(secretKey));
            SignedJWT signedJWT = jweObject.getPayload().toSignedJWT();
            ExtendedRSASSAVerifier verifier = checkExpiry ? new ExtendedRSASSAVerifier(signingKey, signedJWT.getJWTClaimsSet(), this.getTimeProvider()) : new RSASSAVerifier(signingKey);
            return signedJWT.verify((JWSVerifier)verifier);
        }
        catch (IllegalStateException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (ParseException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (JOSEException e) {
            throw new InvalidJwtToken((Throwable)e);
        }
    }

    public JwtPayload getPlayload(RSAKey signingKey, SecretKey secretKey, String token, boolean checkExpiry) throws JwtException {
        try {
            ExtendedRSASSAVerifier verifier;
            JWEObject jweObject = JWEObject.parse((String)token);
            jweObject.decrypt((JWEDecrypter)new DirectDecrypter(secretKey));
            SignedJWT signedJWT = jweObject.getPayload().toSignedJWT();
            ExtendedRSASSAVerifier extendedRSASSAVerifier = verifier = checkExpiry ? new ExtendedRSASSAVerifier(signingKey, signedJWT.getJWTClaimsSet(), this.getTimeProvider()) : new RSASSAVerifier(signingKey);
            if (!signedJWT.verify((JWSVerifier)verifier)) {
                throw new JwtException(String.format("Invalid JSON Web Token (JWT) : %s", token));
            }
            return NimbusdsUtils.payload(signedJWT.getJWTClaimsSet());
        }
        catch (IllegalStateException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (ParseException e) {
            throw new IncorrectJwtException((Throwable)e);
        }
        catch (JOSEException e) {
            throw new InvalidJwtToken((Throwable)e);
        }
    }

    public JwtTimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    public void setTimeProvider(JwtTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }
}

