/*
 * Decompiled with CFR 0.152.
 */
package com.github.vindell.jwt.utils;

import com.github.vindell.jwt.JwtPayload;
import com.github.vindell.jwt.utils.StringUtils;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NimbusdsUtils {
    public static JWTClaimsSet.Builder claimsSet(String jwtId, String subject, String issuer, String audience, Map<String, Object> claims, long period) {
        long currentTimeMillis = System.currentTimeMillis();
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{jwtId})) {
            builder.jwtID(jwtId);
        }
        builder.subject(subject);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{audience})) {
            builder.audience(Stream.of(StringUtils.tokenizeToStringArray((String)audience)).collect(Collectors.toList()));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{issuer})) {
            builder.issuer(issuer);
        }
        if (claims != null) {
            for (Map.Entry<String, Object> entry : claims.entrySet()) {
                builder.claim(entry.getKey(), entry.getValue());
            }
        }
        Date now = new Date(currentTimeMillis);
        builder.issueTime(now);
        builder.notBeforeTime(now);
        if (period >= 0L) {
            Date expiration = new Date(currentTimeMillis + period);
            builder.expirationTime(expiration);
        }
        return builder;
    }

    public static JWTClaimsSet.Builder claimsSet(String jwtId, String subject, String issuer, String audience, String roles, String permissions, long period) {
        long currentTimeMillis = System.currentTimeMillis();
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{jwtId})) {
            builder.jwtID(jwtId);
        }
        builder.subject(subject);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{audience})) {
            builder.audience(Stream.of(StringUtils.tokenizeToStringArray((String)audience)).collect(Collectors.toList()));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{issuer})) {
            builder.issuer(issuer);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{roles})) {
            builder.claim("roles", (Object)roles);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{permissions})) {
            builder.claim("perms", (Object)permissions);
        }
        Date now = new Date(currentTimeMillis);
        builder.issueTime(now);
        builder.notBeforeTime(now);
        if (period >= 0L) {
            Date expiration = new Date(currentTimeMillis + period);
            builder.expirationTime(expiration);
        }
        return builder;
    }

    public static JwtPayload payload(JWTClaimsSet jwtClaims) throws ParseException {
        JwtPayload payload = new JwtPayload();
        payload.setTokenId(jwtClaims.getJWTID());
        payload.setClientId(jwtClaims.getSubject());
        payload.setIssuer(jwtClaims.getIssuer());
        payload.setIssuedAt(jwtClaims.getIssueTime());
        payload.setExpiration(jwtClaims.getExpirationTime());
        payload.setNotBefore(jwtClaims.getNotBeforeTime());
        payload.setAudience(jwtClaims.getAudience());
        payload.setClaims(jwtClaims.getClaims());
        return payload;
    }
}

