/*
 * Decompiled with CFR 0.152.
 */
package com.github.vindell.jwt.verifier;

import com.github.vindell.jwt.exception.ExpiredJwtException;
import com.github.vindell.jwt.exception.NotObtainedJwtException;
import com.github.vindell.jwt.time.JwtTimeProvider;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedRSASSAVerifier
extends RSASSAVerifier {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final JWTClaimsSet claimsSet;
    private final JwtTimeProvider timeProvider;

    public ExtendedRSASSAVerifier(RSAKey rsaJWK, JWTClaimsSet claimsSet, JwtTimeProvider timeProvider) throws JOSEException {
        super(rsaJWK);
        this.claimsSet = claimsSet;
        this.timeProvider = timeProvider;
    }

    public ExtendedRSASSAVerifier(RSAPublicKey publicKey, JWTClaimsSet claimsSet, JwtTimeProvider timeProvider) {
        super(publicKey);
        this.claimsSet = claimsSet;
        this.timeProvider = timeProvider;
    }

    public ExtendedRSASSAVerifier(RSAPublicKey publicKey, Set<String> defCritHeaders, JWTClaimsSet claimsSet, JwtTimeProvider timeProvider) {
        super(publicKey, defCritHeaders);
        this.claimsSet = claimsSet;
        this.timeProvider = timeProvider;
    }

    public boolean verify(JWSHeader header, byte[] signingInput, Base64URL signature) throws JOSEException {
        boolean value = super.verify(header, signingInput, signature);
        if (value) {
            Date issuedAt = this.claimsSet.getIssueTime();
            Date notBefore = this.claimsSet.getNotBeforeTime();
            Date expiration = this.claimsSet.getExpirationTime();
            long currentTimeMillis = this.timeProvider.now();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("JWT IssuedAt:" + issuedAt);
                this.logger.debug("JWT NotBefore:" + notBefore);
                this.logger.debug("JWT Expiration:" + expiration);
                this.logger.debug("JWT Now:" + new Date(currentTimeMillis));
            }
            if (notBefore != null && currentTimeMillis <= notBefore.getTime()) {
                throw new NotObtainedJwtException(String.format("JWT was not obtained before this timestamp : [%s].", notBefore));
            }
            if (expiration != null && expiration.getTime() < currentTimeMillis) {
                throw new ExpiredJwtException("Expired JWT value. ");
            }
            return true;
        }
        return value;
    }
}

