/*
 * Copyright (c) 2018, vindell (https://github.com/vindell).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.cxf.spring.boot.jaxws.feature;

import org.apache.cxf.Bus;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;

public class EndpointPauseFeature extends AbstractFeature {
	
	private String cause = null;
	
	public EndpointPauseFeature(String cause) {
		this.cause = cause;
	}
	
	@Override
	protected void initializeProvider(InterceptorProvider provider, Bus bus) {
		EndpointPauseInterceptor myInt = new EndpointPauseInterceptor(cause);
		provider.getInInterceptors().add(myInt);
	}
	
}