/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot;

import org.apache.cxf.Bus;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.management.jmx.InstrumentationManagerImpl;
import org.apache.cxf.spring.boot.CxfJaxwsManagerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={InstrumentationManager.class})
@ConditionalOnProperty(prefix="cxf.manager", value={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={CxfJaxwsManagerProperties.class})
public class CxfJaxwsManagerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CxfJaxwsManagerConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={InstrumentationManagerImpl.class})
    public InstrumentationManager instrumentationManager(Bus bus, CxfJaxwsManagerProperties properties) {
        InstrumentationManagerImpl mgr = new InstrumentationManagerImpl();
        mgr.setBus(bus);
        mgr.setCreateMBServerConnectorFactory(properties.isCreateMBServerConnectorFactory());
        mgr.setDaemon(properties.isDaemon());
        mgr.setEnabled(properties.isEnabled());
        mgr.setJMXServiceURL(properties.getJmxServiceURL());
        mgr.setServerName(properties.getServerName());
        mgr.setThreaded(properties.isThreaded());
        mgr.setUsePlatformMBeanServer(Boolean.valueOf(properties.isUsePlatformMBeanServer()));
        return mgr;
    }

    @Bean
    @ConditionalOnMissingBean(value={InstrumentationManagerImpl.class})
    public CounterRepository counterRepository(Bus bus) {
        CounterRepository repository = new CounterRepository();
        repository.setBus(bus);
        return repository;
    }
}

