/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot.jaxws;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.MessageObserver;

public class MediatorInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public MediatorInInterceptor() {
        super("post-stream");
        this.addBefore(StaxInInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage message) {
        DepthXMLStreamReader xmlReader;
        String schemaNamespace = "";
        InterceptorChain chain = message.getInterceptorChain();
        try {
            InputStream is = (InputStream)message.getContent(InputStream.class);
            BufferedInputStream pis = new BufferedInputStream(is);
            pis.mark(pis.available());
            message.setContent(InputStream.class, (Object)pis);
            String encoding = (String)message.get((Object)Message.ENCODING);
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(pis, encoding);
            xmlReader = new DepthXMLStreamReader(reader);
            if (xmlReader.nextTag() == 1) {
                String ns = xmlReader.getNamespaceURI();
                SoapVersion soapVersion = SoapVersionFactory.getInstance().getSoapVersion(ns);
                StaxUtils.toNextTag((DepthXMLStreamReader)xmlReader, (QName)soapVersion.getBody());
                xmlReader.nextTag();
            }
            schemaNamespace = xmlReader.getName().getNamespaceURI();
            pis.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        Bus bus = CXFBusFactory.getDefaultBus();
        ServerRegistry serverRegistry = (ServerRegistry)bus.getExtension(ServerRegistry.class);
        List servers = serverRegistry.getServers();
        Server targetServer = null;
        xmlReader = servers.iterator();
        while (xmlReader.hasNext()) {
            Server server;
            targetServer = server = (Server)xmlReader.next();
            String address = server.getEndpoint().getEndpointInfo().getAddress();
            if (!(schemaNamespace.indexOf("2007/03/21") != -1 ? address.indexOf("version2") != -1 : address.indexOf("version1") != -1)) continue;
            break;
        }
        MessageObserver mo = targetServer.getDestination().getMessageObserver();
        mo.onMessage((Message)message);
        chain.abort();
    }
}

