/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot.jaxws.callback;

import java.util.Arrays;
import javax.xml.ws.Endpoint;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.spring.boot.jaxws.endpoint.EndpointCallback;
import org.apache.cxf.validation.BeanValidationFeature;

public class DefaultEndpointCallback
implements EndpointCallback {
    private LoggingFeature loggingFeature;
    private BeanValidationFeature validationFeature;

    public DefaultEndpointCallback(LoggingFeature loggingFeature, BeanValidationFeature validationFeature) {
        this.loggingFeature = loggingFeature;
        this.validationFeature = validationFeature;
    }

    @Override
    public Endpoint doCallback(Object implementor, EndpointImpl endpoint) {
        endpoint.getInInterceptors().add(new LoggingInInterceptor());
        endpoint.getOutInterceptors().add(new LoggingOutInterceptor());
        endpoint.getFeatures().addAll(Arrays.asList(this.loggingFeature, this.validationFeature));
        return endpoint;
    }
}

