/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot.jaxws.endpoint;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.spring.boot.jaxws.endpoint.EndpointCallback;
import org.apache.cxf.spring.boot.jaxws.feature.EndpointPauseFeature;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.UrlPathHelper;

public class EndpointApiTemplate {
    private ConcurrentMap<String, Endpoint> endpoints = new ConcurrentHashMap<String, Endpoint>();
    private Bus bus;
    private EndpointCallback callback;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();

    public EndpointApiTemplate(Bus bus, EndpointCallback callback) {
        this.bus = bus;
        this.callback = callback;
    }

    public Endpoint publish(String addr, Object implementor) {
        return this.publish(addr, implementor, this.callback);
    }

    public Endpoint publish(String addr, Object implementor, EndpointCallback callback) {
        EndpointImpl endpoint = new EndpointImpl(this.bus, implementor);
        callback.doCallback(implementor, endpoint);
        endpoint.publish(addr);
        this.endpoints.put(addr, (Endpoint)endpoint);
        return endpoint;
    }

    public List<Endpoint> pause(String pattern, String cause) {
        ArrayList<Endpoint> pauses = new ArrayList<Endpoint>();
        for (String addr : this.endpoints.keySet()) {
            EndpointImpl endpoint;
            if (!this.pathMatcher.match(pattern, addr) || null == (endpoint = (EndpointImpl)this.endpoints.get(addr))) continue;
            endpoint.getFeatures().removeIf(new Predicate<Feature>(){

                @Override
                public boolean test(Feature t) {
                    return EndpointPauseFeature.class.isAssignableFrom(t.getClass());
                }
            });
            endpoint.getFeatures().add(0, new EndpointPauseFeature(cause));
            pauses.add((Endpoint)endpoint);
        }
        return pauses;
    }

    public List<Endpoint> restore(String pattern) {
        ArrayList<Endpoint> pauses = new ArrayList<Endpoint>();
        for (String addr : this.endpoints.keySet()) {
            EndpointImpl endpoint;
            if (!this.pathMatcher.match(pattern, addr) || null == (endpoint = (EndpointImpl)this.endpoints.get(addr))) continue;
            endpoint.getFeatures().removeIf(new Predicate<Feature>(){

                @Override
                public boolean test(Feature t) {
                    return EndpointPauseFeature.class.isAssignableFrom(t.getClass());
                }
            });
            pauses.add((Endpoint)endpoint);
        }
        return pauses;
    }

    public void destroy(String pattern) {
        Iterator ite = this.endpoints.entrySet().iterator();
        while (ite.hasNext()) {
            EndpointImpl endpoint;
            Map.Entry entry = ite.next();
            if (!this.pathMatcher.match(pattern, (String)entry.getKey()) || (endpoint = (EndpointImpl)this.endpoints.get(entry.getKey())) == null) continue;
            ServerImpl server = endpoint.getServer((String)entry.getKey());
            server.destroy();
            ite.remove();
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public ConcurrentMap<String, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Map<String, Endpoint> endpoints) {
        this.endpoints.putAll(endpoints);
    }

    public EndpointCallback getCallback() {
        return this.callback;
    }

    public void setCallback(EndpointCallback callback) {
        this.callback = callback;
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }
}

