/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.spring.boot.jaxws.security;

import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public class UsernamePwdAuthInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(UsernamePwdAuthInterceptor.class);
    private SAAJInInterceptor saa = new SAAJInInterceptor();
    private static final String USER_NAME = "admin";
    private static final String USER_PASSWORD = "pass";

    public UsernamePwdAuthInterceptor() {
        super("pre-protocol");
        this.getAfter().add(SAAJInInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        SOAPMessage mess = (SOAPMessage)message.getContent(SOAPMessage.class);
        if (mess == null) {
            this.saa.handleMessage(message);
            mess = (SOAPMessage)message.getContent(SOAPMessage.class);
        }
        SOAPHeader head = null;
        try {
            head = mess.getSOAPHeader();
        }
        catch (Exception e) {
            LOG.error("getSOAPHeader error: {}", (Object)e.getMessage(), (Object)e);
        }
        if (head == null) {
            throw new Fault((Throwable)new IllegalArgumentException("\u627e\u4e0d\u5230Header\uff0c\u65e0\u6cd5\u9a8c\u8bc1\u7528\u6237\u4fe1\u606f"));
        }
        NodeList users = head.getElementsByTagName(USER_NAME);
        NodeList passwords = head.getElementsByTagName(USER_PASSWORD);
        if (users.getLength() < 1) {
            throw new Fault((Throwable)new IllegalArgumentException("\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f"));
        }
        if (passwords.getLength() < 1) {
            throw new Fault((Throwable)new IllegalArgumentException("\u627e\u4e0d\u5230\u5bc6\u7801\u4fe1\u606f"));
        }
        String userName = users.item(0).getTextContent().trim();
        String password = passwords.item(0).getTextContent().trim();
        if (!USER_NAME.equals(userName) || !USER_PASSWORD.equals(password)) {
            SOAPException soapExc = new SOAPException("\u8ba4\u8bc1\u9519\u8bef");
            LOG.debug("admin auth failed");
            throw new Fault((Throwable)soapExc);
        }
        LOG.debug("admin auth success");
    }
}

