/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.spring.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.spring.boot.FlywayMigrationProperties;
import org.flywaydb.spring.boot.ext.FlywayFluentConfiguration;
import org.flywaydb.spring.boot.ext.FlywayMigrationProvider;
import org.flywaydb.spring.boot.ext.FlywayModularizedMigrationInitializer;
import org.flywaydb.spring.boot.ext.FlywayModularizedProperties;
import org.flywaydb.spring.boot.ext.resolver.LocationModuleResolver;
import org.flywaydb.spring.boot.ext.resolver.LocationVendorResolver;
import org.flywaydb.spring.boot.ext.resolver.TableModuleResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcOperationsDependsOnPostProcessor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Flyway.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="spring.flyway", name={"enabled"}, havingValue="true")
@AutoConfigureBefore(name={"org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration", "org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration", "org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration", "com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration", "com.alibaba.druid.spring.boot.DruidAutoConfiguration", "com.zaxxer.hikari.spring.boot.HikaricpAutoConfiguration", "org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration"})
public class FlywayMigrationAutoConfiguration {
    @Bean
    @FlywayDataSource
    public DataSource flywayDatasource(DataSourceProperties properties) {
        return properties.initializeDataSourceBuilder().build();
    }

    @Bean
    public FlywayMigrationProvider flywayMigration() {
        return new FlywayMigrationProvider();
    }

    @Configuration
    @ConditionalOnClass(value={JdbcOperations.class})
    @ConditionalOnBean(value={JdbcOperations.class})
    protected static class FlywayJdbcOperationsDependencyConfiguration
    extends JdbcOperationsDependsOnPostProcessor {
        public FlywayJdbcOperationsDependencyConfiguration() {
            super(new String[]{"flyways"});
        }
    }

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    protected static class FlywayJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        public FlywayJpaDependencyConfiguration() {
            super(new String[]{"flyways"});
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={DataSourceProperties.class, FlywayMigrationProperties.class})
    public static class FlywayModuleConfiguration {
        private final FlywayMigrationProperties properties;
        private final DataSourceProperties dataSourceProperties;
        private final ResourceLoader resourceLoader;
        private final DataSource dataSource;
        private final DataSource flywayDataSource;
        private final FlywayMigrationStrategy migrationStrategy;
        private final List<FlywayConfigurationCustomizer> configurationCustomizers;
        private final List<Callback> callbacks;
        private final List<FlywayFluentConfiguration> configurations;

        public FlywayModuleConfiguration(FlywayMigrationProperties properties, DataSourceProperties dataSourceProperties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, @FlywayDataSource ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayMigrationStrategy> migrationStrategy, ObjectProvider<FlywayConfigurationCustomizer> fluentConfigurationCustomizers, ObjectProvider<Callback> callbacks, ObjectProvider<FlywayFluentConfiguration> configurations) {
            this.properties = properties;
            this.dataSourceProperties = dataSourceProperties;
            this.resourceLoader = resourceLoader;
            this.dataSource = (DataSource)dataSource.getIfUnique();
            this.flywayDataSource = (DataSource)flywayDataSource.getIfAvailable();
            this.migrationStrategy = (FlywayMigrationStrategy)migrationStrategy.getIfAvailable();
            this.configurationCustomizers = fluentConfigurationCustomizers.orderedStream().collect(Collectors.toList());
            this.callbacks = callbacks.orderedStream().collect(Collectors.toList());
            this.configurations = configurations.orderedStream().collect(Collectors.toList());
        }

        @Bean(value={"flyways"})
        public List<Flyway> flyways() {
            ArrayList<Flyway> flyways = new ArrayList<Flyway>();
            if (!CollectionUtils.isEmpty(this.properties.getModules())) {
                for (FlywayModularizedProperties properties : this.properties.getModules()) {
                    FluentConfiguration configuration = new FluentConfiguration();
                    DataSource dataSource = this.configureDataSource(properties, configuration);
                    this.checkLocationExists(properties, dataSource);
                    this.configureProperties(properties, configuration);
                    this.configureCallbacks(configuration);
                    this.configurationCustomizers.forEach(customizer -> customizer.customize(configuration));
                    flyways.add(configuration.load());
                }
            }
            if (!CollectionUtils.isEmpty(this.configurations)) {
                for (FlywayFluentConfiguration configuration : this.configurations) {
                    this.configureDataSource(configuration);
                    this.checkLocationExists(configuration);
                    this.configureConfiguration(configuration);
                    this.configureCallbacks(configuration);
                    this.configurationCustomizers.forEach(customizer -> customizer.customize((FluentConfiguration)configuration));
                    flyways.add(configuration.load());
                }
            }
            return flyways;
        }

        private DataSource configureDataSource(FlywayModularizedProperties properties, FluentConfiguration configuration) {
            if (properties.isCreateDataSource()) {
                String url = this.getProperty(properties::getUrl, () -> ((DataSourceProperties)this.dataSourceProperties).getUrl());
                String user = this.getProperty(properties::getUser, () -> ((DataSourceProperties)this.dataSourceProperties).getUsername());
                String password = this.getProperty(properties::getPassword, () -> ((DataSourceProperties)this.dataSourceProperties).getPassword());
                configuration.dataSource(url, user, password);
                if (!CollectionUtils.isEmpty(properties.getInitSqls())) {
                    String initSql = StringUtils.collectionToDelimitedString(properties.getInitSqls(), (String)"\n");
                    configuration.initSql(initSql);
                }
            } else if (this.flywayDataSource != null) {
                configuration.dataSource(this.flywayDataSource);
            } else {
                configuration.dataSource(this.dataSource);
            }
            return configuration.getDataSource();
        }

        private DataSource configureDataSource(FluentConfiguration configuration) {
            if (null == configuration.getDataSource()) {
                if (this.flywayDataSource != null) {
                    configuration.dataSource(this.flywayDataSource);
                } else {
                    configuration.dataSource(this.dataSource);
                }
            }
            return configuration.getDataSource();
        }

        private void checkLocationExists(FlywayModularizedProperties properties, DataSource dataSource) {
            if (properties.isCheckLocation()) {
                String[] locations = new LocationVendorResolver(dataSource).resolveLocations(properties.getLocations());
                Assert.state((locations.length != 0 ? 1 : 0) != 0, (String)"Migration script locations not configured");
                boolean exists = this.hasAtLeastOneLocation(locations);
                Assert.state((boolean)exists, () -> "Cannot find migrations location in: " + Arrays.asList(locations) + " (please add migrations or check your Flyway configuration)");
            }
        }

        private void checkLocationExists(FlywayFluentConfiguration configuration) {
            String[] locations = new LocationVendorResolver(configuration.getDataSource()).resolveLocations(configuration.getLocationAsStrings());
            Assert.state((locations.length != 0 ? 1 : 0) != 0, (String)"Migration script locations not configured");
            boolean exists = this.hasAtLeastOneLocation(locations);
            Assert.state((boolean)exists, () -> "Cannot find migrations location in: " + Arrays.asList(locations) + " (please add migrations or check your Flyway configuration)");
        }

        private void configureProperties(FlywayModularizedProperties properties, FluentConfiguration configuration) {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            String[] locations = new LocationVendorResolver(configuration.getDataSource()).resolveLocations(properties.getLocations());
            locations = new LocationModuleResolver(properties.getModule()).resolveLocations(locations);
            map.from((Object)locations).to(arg_0 -> ((FluentConfiguration)configuration).locations(arg_0));
            map.from((Object)properties.getEncoding()).to(arg_0 -> ((FluentConfiguration)configuration).encoding(arg_0));
            map.from((Object)properties.getConnectRetries()).to(arg_0 -> ((FluentConfiguration)configuration).connectRetries(arg_0));
            map.from(properties.getSchemas()).as(StringUtils::toStringArray).to(arg_0 -> ((FluentConfiguration)configuration).schemas(arg_0));
            String table = new TableModuleResolver(properties.getModule()).resolveTable(properties.getTable());
            map.from((Object)table).to(arg_0 -> ((FluentConfiguration)configuration).table(arg_0));
            map.from((Object)properties.getBaselineDescription()).to(arg_0 -> ((FluentConfiguration)configuration).baselineDescription(arg_0));
            map.from((Object)properties.getBaselineVersion()).to(arg_0 -> ((FluentConfiguration)configuration).baselineVersion(arg_0));
            map.from((Object)properties.getInstalledBy()).to(arg_0 -> ((FluentConfiguration)configuration).installedBy(arg_0));
            map.from(properties.getPlaceholders()).to(arg_0 -> ((FluentConfiguration)configuration).placeholders(arg_0));
            map.from((Object)properties.getPlaceholderPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderPrefix(arg_0));
            map.from((Object)properties.getPlaceholderSuffix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderSuffix(arg_0));
            map.from((Object)properties.isPlaceholderReplacement()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderReplacement(arg_0));
            map.from((Object)properties.getSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationPrefix(arg_0));
            map.from(properties.getSqlMigrationSuffixes()).as(StringUtils::toStringArray).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSuffixes(arg_0));
            map.from((Object)properties.getSqlMigrationSeparator()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSeparator(arg_0));
            map.from((Object)properties.getRepeatableSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).repeatableSqlMigrationPrefix(arg_0));
            map.from((Object)properties.getTarget()).to(arg_0 -> ((FluentConfiguration)configuration).target(arg_0));
            map.from((Object)properties.isBaselineOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).baselineOnMigrate(arg_0));
            map.from((Object)properties.isCleanDisabled()).to(arg_0 -> ((FluentConfiguration)configuration).cleanDisabled(arg_0));
            map.from((Object)properties.isCleanOnValidationError()).to(arg_0 -> ((FluentConfiguration)configuration).cleanOnValidationError(arg_0));
            map.from((Object)properties.isGroup()).to(arg_0 -> ((FluentConfiguration)configuration).group(arg_0));
            map.from((Object)properties.isIgnoreMissingMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreMissingMigrations(arg_0));
            map.from((Object)properties.isIgnoreIgnoredMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreIgnoredMigrations(arg_0));
            map.from((Object)properties.isIgnorePendingMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignorePendingMigrations(arg_0));
            map.from((Object)properties.isIgnoreFutureMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).ignoreFutureMigrations(arg_0));
            map.from((Object)properties.isMixed()).to(arg_0 -> ((FluentConfiguration)configuration).mixed(arg_0));
            map.from((Object)properties.isOutOfOrder()).to(arg_0 -> ((FluentConfiguration)configuration).outOfOrder(arg_0));
            map.from((Object)properties.isSkipDefaultCallbacks()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultCallbacks(arg_0));
            map.from((Object)properties.isSkipDefaultResolvers()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultResolvers(arg_0));
            map.from((Object)properties.isValidateOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).validateOnMigrate(arg_0));
        }

        private void configureConfiguration(FlywayFluentConfiguration configuration) {
            String[] locations = new LocationVendorResolver(configuration.getDataSource()).resolveLocations(configuration.getLocationAsStrings());
            configuration.locations(locations);
            String table = new TableModuleResolver(configuration.getModule()).resolveTable(configuration.getTable());
            configuration.table(table);
        }

        private void configureCallbacks(FluentConfiguration configuration) {
            if (!this.callbacks.isEmpty()) {
                configuration.callbacks(this.callbacks.toArray(new Callback[0]));
            }
        }

        private String getProperty(Supplier<String> property, Supplier<String> defaultValue) {
            String value = property.get();
            return value != null ? value : defaultValue.get();
        }

        private boolean hasAtLeastOneLocation(String ... locations) {
            for (String location : locations) {
                if (!this.resourceLoader.getResource(this.normalizePrefix(location)).exists()) continue;
                return true;
            }
            return false;
        }

        private String normalizePrefix(String location) {
            return location.replace("filesystem:", "file:");
        }

        @Bean
        public FlywayModularizedMigrationInitializer flywayModuleInitializer(@Qualifier(value="flyways") List<Flyway> flyways) {
            return new FlywayModularizedMigrationInitializer(flyways, this.migrationStrategy);
        }

        @Configuration
        @ConditionalOnClass(value={JdbcOperations.class})
        @ConditionalOnBean(value={JdbcOperations.class})
        protected static class FlywayInitializerJdbcOperationsDependencyConfiguration
        extends JdbcOperationsDependsOnPostProcessor {
            public FlywayInitializerJdbcOperationsDependencyConfiguration() {
                super(new String[]{"flywayModuleInitializer"});
            }
        }

        @Configuration
        @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
        @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
        protected static class FlywayInitializerJpaDependencyConfiguration
        extends EntityManagerFactoryDependsOnPostProcessor {
            public FlywayInitializerJpaDependencyConfiguration() {
                super(new String[]{"flywayModuleInitializer"});
            }
        }
    }
}

