/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.spring.boot.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.spring.boot.ext.resolver.LocationModuleResolver;

public class FlywayFluentConfiguration
extends FluentConfiguration {
    private static final String DEFAULT_FLYWAY_MODULE_PATH = "classpath:db/migration/{module}/{vendor}";
    private static final String DEFAULT_FLYWAY_MODULE_TABLE = "flyway_{module}_schema_history";
    private String module = "module";
    private List<String> locationAsStrings = new ArrayList<String>();

    public FlywayFluentConfiguration(String module, String baselineDescription, String baselineVersion) {
        this.module = module;
        this.init(baselineDescription, baselineVersion);
    }

    public FlywayFluentConfiguration(ClassLoader classLoader, String module, String baselineDescription, String baselineVersion) {
        super(classLoader);
        this.module = module;
        this.init(baselineDescription, baselineVersion);
    }

    public FluentConfiguration locations(String ... locations) {
        String[] moduleLocations = new LocationModuleResolver(this.getModule()).resolveLocations(locations);
        this.locationAsStrings = Arrays.asList(moduleLocations);
        return super.locations(moduleLocations);
    }

    protected void init(String baselineDescription, String baselineVersion) {
        this.locations(DEFAULT_FLYWAY_MODULE_PATH).table(DEFAULT_FLYWAY_MODULE_TABLE).baselineDescription(baselineDescription).baselineOnMigrate(true).baselineVersion(baselineVersion);
    }

    public String getTable() {
        return super.getTable();
    }

    public String getModule() {
        return this.module;
    }

    public List<String> getLocationAsStrings() {
        return this.locationAsStrings;
    }
}

