/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.spring.boot.ext;

import org.flywaydb.core.Flyway;
import org.flywaydb.spring.boot.ext.FlywayMigratedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class FlywayMigrationProvider
implements FlywayMigrationStrategy,
ApplicationEventPublisherAware {
    protected static Logger LOG = LoggerFactory.getLogger(FlywayMigrationProvider.class);
    private ApplicationEventPublisher applicationEventPublisher;

    public void migrate(Flyway flyway) {
        try {
            LOG.info("[Start] Flyway Migration run .. ");
            flyway.migrate();
            this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new FlywayMigratedEvent(this));
            LOG.info("[End] Flyway Migration run .. ");
        }
        catch (Exception e) {
            LOG.error("Flyway Migrated Error . ", (Throwable)e);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }
}

