/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.spring.boot.ext;

import java.util.List;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class FlywayModularizedMigrationInitializer
implements InitializingBean,
Ordered {
    private final List<Flyway> flyways;
    private final FlywayMigrationStrategy migrationStrategy;
    private int order = 0;

    public FlywayModularizedMigrationInitializer(List<Flyway> flyways) {
        this(flyways, null);
    }

    public FlywayModularizedMigrationInitializer(List<Flyway> flyways, FlywayMigrationStrategy migrationStrategy) {
        Assert.notNull(flyways, (String)"Flyways must not be null");
        this.flyways = flyways;
        this.migrationStrategy = migrationStrategy;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.migrationStrategy != null) {
            for (Flyway flyway : this.flyways) {
                this.migrationStrategy.migrate(flyway);
            }
        } else {
            for (Flyway flyway : this.flyways) {
                flyway.migrate();
            }
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

