/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.spring.boot.ext.resolver;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.util.StringUtils;

public class LocationModuleResolver {
    private static final String MODULE_PLACEHOLDER = "{module}";
    private final String module;

    public LocationModuleResolver(String module) {
        this.module = module;
    }

    public String[] resolveLocations(Collection<String> locations) {
        return this.resolveLocations(StringUtils.toStringArray(locations));
    }

    public String[] resolveLocations(String[] locations) {
        if (this.usesModuleLocation(locations)) {
            return (String[])Arrays.stream(locations).map(location -> location.replace(MODULE_PLACEHOLDER, this.module)).toArray(String[]::new);
        }
        return locations;
    }

    private boolean usesModuleLocation(String ... locations) {
        for (String location : locations) {
            if (!location.contains(MODULE_PLACEHOLDER)) continue;
            return true;
        }
        return false;
    }
}

