/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.spring.boot.ext.resolver;

import java.util.Arrays;
import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.StringUtils;

public class LocationVendorResolver {
    private static final String VENDOR_PLACEHOLDER = "{vendor}";
    private final DataSource dataSource;

    public LocationVendorResolver(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String[] resolveLocations(Collection<String> locations) {
        return this.resolveLocations(StringUtils.toStringArray(locations));
    }

    public String[] resolveLocations(String[] locations) {
        if (this.usesVendorLocation(locations)) {
            DatabaseDriver databaseDriver = this.getDatabaseDriver();
            return this.replaceVendorLocations(locations, databaseDriver);
        }
        return locations;
    }

    private String[] replaceVendorLocations(String[] locations, DatabaseDriver databaseDriver) {
        if (databaseDriver == DatabaseDriver.UNKNOWN) {
            return locations;
        }
        String vendor = databaseDriver.getId();
        return (String[])Arrays.stream(locations).map(location -> location.replace(VENDOR_PLACEHOLDER, vendor)).toArray(String[]::new);
    }

    private DatabaseDriver getDatabaseDriver() {
        try {
            String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getURL");
            return DatabaseDriver.fromJdbcUrl((String)url);
        }
        catch (MetaDataAccessException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private boolean usesVendorLocation(String ... locations) {
        for (String location : locations) {
            if (!location.contains(VENDOR_PLACEHOLDER)) continue;
            return true;
        }
        return false;
    }
}

