/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoAttributes;

public final class ConnectionAttributes
implements JCoAttributes {
    static final long serialVersionUID = 3001220141007L;
    String dest;
    String own_host;
    String partner_host;
    String systnr;
    String sysid;
    String client;
    String user;
    String language;
    String iso_language;
    String own_codepage;
    String partner_codepage;
    String own_charset;
    String partner_charset;
    String own_encoding;
    String partner_encoding;
    byte own_bytes_per_char;
    byte partner_bytes_per_char;
    String own_rel;
    String partner_rel;
    String kernel_rel;
    char partner_type;
    char trace;
    char rfc_role = (char)32;
    char own_type;
    String sso_ticket;
    int partner_rel_number = -1;
    int kernel_rel_number = -1;
    AttributesProvider attributesProvider = null;

    ConnectionAttributes(AttributesProvider attribProvider) {
        this.attributesProvider = attribProvider;
    }

    public final String getDestination() {
        return this.dest;
    }

    public final String getHost() {
        return this.own_host;
    }

    public final String getPartnerHost() {
        return this.attributesProvider.canUseCachedValues() ? this.partner_host : this.attributesProvider.getPartnerHost();
    }

    public final String getSystemID() {
        return this.sysid;
    }

    public final String getSystemNumber() {
        return this.systnr;
    }

    public final String getClient() {
        return this.client;
    }

    public final String getUser() {
        return this.user;
    }

    public final String getLanguage() {
        return this.language;
    }

    public final String getISOLanguage() {
        return this.iso_language;
    }

    public final String getOwnCodepage() {
        return this.own_codepage;
    }

    public final String getOwnCharset() {
        return this.own_charset;
    }

    public final String getOwnEncoding() {
        return this.own_encoding;
    }

    public final int getOwnBytesPerChar() {
        return this.own_bytes_per_char;
    }

    public final String getPartnerCodepage() {
        return this.partner_codepage;
    }

    public final String getPartnerCharset() {
        return this.partner_charset;
    }

    public final String getPartnerEncoding() {
        return this.partner_encoding;
    }

    public final int getPartnerBytesPerChar() {
        return this.partner_bytes_per_char;
    }

    public final String getRelease() {
        return this.own_rel;
    }

    public final String getPartnerRelease() {
        return this.partner_rel;
    }

    public final String getKernelRelease() {
        return this.kernel_rel;
    }

    public final char getPartnerType() {
        return this.partner_type;
    }

    public final boolean getTrace() {
        return this.trace == 'X' || this.trace == 'x';
    }

    public final char getRfcRole() {
        return this.rfc_role;
    }

    public final char getType() {
        return this.own_type;
    }

    public final String getCPICConversationID() {
        return this.attributesProvider.getConversationID();
    }

    public final String getSSOTicket() {
        return this.sso_ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPartnerReleaseNumber() {
        if (this.partner_rel_number < 0) {
            ConnectionAttributes connectionAttributes = this;
            synchronized (connectionAttributes) {
                if (this.partner_rel_number < 0) {
                    int relNumber = this.determineReleaseNumber(this.partner_rel);
                    if (relNumber > 0) {
                        this.partner_rel_number = relNumber;
                    } else {
                        return 0;
                    }
                }
            }
        }
        return this.partner_rel_number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getKernelReleaseNumber() {
        if (this.kernel_rel_number < 0) {
            ConnectionAttributes connectionAttributes = this;
            synchronized (connectionAttributes) {
                if (this.kernel_rel_number < 0) {
                    int relNumber = this.determineReleaseNumber(this.kernel_rel);
                    if (relNumber > 0) {
                        this.kernel_rel_number = relNumber;
                    } else {
                        return 0;
                    }
                }
            }
        }
        return this.kernel_rel_number;
    }

    private int determineReleaseNumber(String releaseString) {
        int releaseNumber = 0;
        if (releaseString != null && releaseString.length() > 0) {
            releaseNumber = (releaseString.charAt(0) - 48) * 100;
            releaseNumber += (releaseString.charAt(1) - 48) * 10;
            releaseNumber = Character.isDigit(releaseString.charAt(2)) ? (releaseNumber += releaseString.charAt(2) - 48) : (releaseNumber += releaseString.charAt(2) - 65);
        }
        return releaseNumber;
    }

    public final String toString() {
        StringBuilder s = new StringBuilder(800);
        s.append("DEST:                   ").append(this.dest);
        s.append("\nOWN_HOST:               ").append(this.own_host);
        s.append("\nPARTNER_HOST:           ").append(this.getPartnerHost());
        s.append("\nSYSTNR:                 ").append(this.systnr);
        s.append("\nSYSID:                  ").append(this.sysid);
        s.append("\nCLIENT:                 ").append(this.client);
        s.append("\nUSER:                   ").append(this.user);
        s.append("\nLANGUAGE:               ").append(this.language);
        s.append("\nISO_LANGUAGE:           ").append(this.iso_language);
        s.append("\nOWN_CODEPAGE:           ").append(this.own_codepage);
        s.append("\nOWN_CHARSET:            ").append(this.own_charset);
        s.append("\nOWN_ENCODING:           ").append(this.own_encoding);
        s.append("\nOWN_BYTES_PER_CHAR:     ").append(this.own_bytes_per_char);
        s.append("\nPARTNER_CODEPAGE:       ").append(this.partner_codepage);
        s.append("\nPARTNER_CHARSET:        ").append(this.partner_charset);
        s.append("\nPARTNER_ENCODING:       ").append(this.partner_encoding);
        s.append("\nPARTNER_BYTES_PER_CHAR: ").append(this.partner_bytes_per_char);
        s.append("\nOWN_REL:                ").append(this.own_rel);
        s.append("\nPARTNER_REL:            ").append(this.partner_rel);
        s.append("\nPARTNER_TYPE:           ").append(this.partner_type);
        s.append("\nKERNEL_REL:             ").append(this.kernel_rel);
        s.append("\nTRACE:                  ").append(this.trace);
        s.append("\nRFC_ROLE:               ").append(this.rfc_role);
        s.append("\nOWN_TYPE:               ").append(this.own_type);
        s.append("\nCPIC_CONVID:            ").append(this.getCPICConversationID());
        if (this.sso_ticket != null) {
            s.append("\nSSOTICKET:              ").append(this.sso_ticket.substring(0, 10)).append("...");
        }
        return s.toString();
    }

    protected void clear() {
        this.dest = null;
        this.own_host = null;
        this.partner_host = null;
        this.systnr = null;
        this.sysid = null;
        this.client = null;
        this.user = null;
        this.language = null;
        this.iso_language = null;
        this.own_codepage = null;
        this.partner_codepage = null;
        this.own_charset = null;
        this.partner_charset = null;
        this.own_encoding = null;
        this.partner_encoding = null;
        this.own_bytes_per_char = 0;
        this.partner_bytes_per_char = 0;
        this.own_rel = null;
        this.partner_rel = null;
        this.kernel_rel = null;
        this.partner_type = (char)32;
        this.trace = (char)32;
        this.rfc_role = (char)32;
        this.own_type = (char)32;
        this.sso_ticket = null;
        this.partner_rel_number = -1;
    }

    protected boolean isInitial() {
        return this.rfc_role == ' ';
    }

    static interface AttributesProvider {
        public boolean canUseCachedValues();

        public String getConversationID();

        public String getPartnerHost();
    }
}

