/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DynamicRecordMetaData;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.DefaultSharedStorage;
import com.sap.conn.jco.util.SharedStorage;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaDataStorage {
    protected static final String PREFIX = "/com/sap/conn/jco/repository/";
    protected static final String FUNCTIONS = "functions";
    protected static final String STRUCTURES = "structures";
    protected static final String CLASSES = "classes";
    protected String storageName;
    protected BasicRepository repository = null;
    private SharedStorage<String, AbapFunctionTemplate> functions;
    private SharedStorage<String, DefaultRecordMetaData> structures;
    private SharedStorage<String, DefaultClassMetaData> classes;
    private StoreKeeper storeKeeper;

    public MetaDataStorage(BasicRepository basicRepository, String name, boolean localCache) {
        this.storageName = name;
        this.repository = basicRepository;
        String functionStorageName = PREFIX + name + "/" + FUNCTIONS;
        String structureStorageName = PREFIX + name + "/" + STRUCTURES;
        String classStorageName = PREFIX + name + "/" + CLASSES;
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        if (localCache) {
            this.functions = new DefaultSharedStorage<String, AbapFunctionTemplate>(functionStorageName);
            this.structures = new DefaultSharedStorage<String, DefaultRecordMetaData>(structureStorageName);
            this.classes = new DefaultSharedStorage<String, DefaultClassMetaData>(classStorageName);
        } else {
            this.functions = rt.createSharedStorage(functionStorageName);
            this.structures = rt.createSharedStorage(structureStorageName);
            this.classes = rt.createSharedStorage(classStorageName);
        }
        this.storeKeeper = this.functions.supportsSharedLocking() ? new StoreKeeperLockingStorage() : new StoreKeeper();
    }

    private void updateParents(AbstractMetaData removed, Serializable meta) {
        for (String name : this.getCachedFunctionNames()) {
            AbapFunctionTemplate template = this.functions.getMutableValue(name);
            boolean updated = this.updateParents((AbstractMetaData)((Object)template.getImportParameterList()), removed, meta);
            updated = this.updateParents((AbstractMetaData)((Object)template.getExportParameterList()), removed, meta) || updated;
            updated = this.updateParents((AbstractMetaData)((Object)template.getChangingParameterList()), removed, meta) || updated;
            updated = this.updateParents((AbstractMetaData)((Object)template.getTableParameterList()), removed, meta) || updated;
            if (!updated) continue;
            this.saveFunctionTemplateInternal(template);
        }
        for (String name : this.getCachedRecordNames()) {
            DefaultRecordMetaData rMd = this.structures.getMutableValue(name);
            if (!this.updateParents(rMd, removed, meta)) continue;
            this.saveRecordMetaDataInternal(rMd);
        }
    }

    private boolean updateParents(AbstractMetaData parent, AbstractMetaData removed, Serializable meta) {
        boolean updated = false;
        if (parent != null && parent.numOdata > 0) {
            for (int i = 0; i < parent.numFields; ++i) {
                if (parent.tabMeta[i] != removed) continue;
                parent.tabMeta[i] = meta;
                if (meta instanceof String) {
                    parent.allTypesResolved = false;
                }
                updated = true;
            }
        }
        return updated;
    }

    private void storeNestedMetaData(AbstractMetaData meta) {
        if (meta == null) {
            return;
        }
        block4: for (int i = 0; i < meta.getFieldCount(); ++i) {
            switch (meta.getType(i)) {
                case 17: 
                case 99: {
                    AbstractMetaData savedMD;
                    AbstractMetaData md;
                    if (!(meta.tabMeta[i] instanceof DefaultRecordMetaData) || (md = (DefaultRecordMetaData)meta.tabMeta[i]) == (savedMD = this.structures.get(md.recName))) continue block4;
                    this.saveRecordMetaDataInternal((DefaultRecordMetaData)md);
                    continue block4;
                }
                case 16: {
                    DefaultClassMetaData saved;
                    if (!(meta.tabMeta[i] instanceof DefaultClassMetaData)) continue block4;
                    AbstractMetaData md = (DefaultClassMetaData)meta.tabMeta[i];
                    AbstractMetaData savedMD = this.classes.get(((DefaultClassMetaData)md).recName);
                    if (md != savedMD) {
                        this.saveClassMetaDataInternal((DefaultClassMetaData)md);
                    }
                    if (md == (saved = this.classes.get(((DefaultClassMetaData)md).recName))) continue block4;
                    this.saveClassMetaData((DefaultClassMetaData)md);
                    continue block4;
                }
            }
        }
    }

    private boolean compare(DefaultRecordMetaData meta1, DefaultRecordMetaData meta2) {
        if (meta1 != meta2) {
            if (meta1 == null || meta2 == null) {
                return false;
            }
            if (meta1.numFields != meta2.numFields) {
                return false;
            }
            for (int i = 0; i < meta1.numFields; ++i) {
                if (meta1.type[i] != meta2.type[i]) {
                    return false;
                }
                if (meta1.length[1][i] != meta2.length[1][i]) {
                    return false;
                }
                if (meta1.length[0][i] != meta2.length[0][i]) {
                    return false;
                }
                if (meta1.offset[1][i] != meta2.offset[1][i]) {
                    return false;
                }
                if (meta1.offset[0][i] != meta2.offset[0][i]) {
                    return false;
                }
                if (!meta1.name[i].equals(meta2.name[i])) {
                    return false;
                }
                if (meta1.decimals[i] != meta2.decimals[i]) {
                    return false;
                }
                if (meta1.tabMeta[i] == meta2.tabMeta[i] || meta1.tabMeta[i] instanceof String && meta1.tabMeta[i].equals(meta2.tabMeta[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean compare(DefaultClassMetaData meta1, DefaultClassMetaData meta2) {
        if (meta1 != meta2) {
            if (meta1 == null || meta2 == null) {
                return false;
            }
            if (meta1.numFields != meta2.numFields) {
                return false;
            }
            for (int i = 0; i < meta1.numFields; ++i) {
                if (meta1.type[i] != meta2.type[i]) {
                    return false;
                }
                if (meta1.length[1][i] != meta2.length[1][i]) {
                    return false;
                }
                if (meta1.length[0][i] != meta2.length[0][i]) {
                    return false;
                }
                if (!meta1.name[i].equals(meta2.name[i])) {
                    return false;
                }
                if (meta1.decimals[i] != meta2.decimals[i]) {
                    return false;
                }
                if (meta1.tabMeta[i] == meta2.tabMeta[i] || meta1.tabMeta[i] instanceof String && meta1.tabMeta[i].equals(meta2.tabMeta[i])) continue;
                return false;
            }
        }
        return true;
    }

    private <MD extends AbstractMetaData> MD resolveMetaData(MD meta) throws JCoException {
        if (meta == null) {
            return null;
        }
        block4: for (int i = 0; i < meta.getFieldCount(); ++i) {
            switch (meta.getType(i)) {
                case 17: 
                case 99: {
                    AbstractMetaData md;
                    Serializable tabMeta = meta.tabMeta[i];
                    if (tabMeta instanceof String) {
                        md = null;
                        md = this.loadRecordMetaDataFromCache((String)((Object)tabMeta));
                        if (md == null) {
                            md = this.repository.getRecordMetaData((String)((Object)tabMeta));
                            if (md == null) {
                                return null;
                            }
                            md = this.loadRecordMetaData((String)((Object)tabMeta));
                        }
                        meta.tabMeta[i] = md;
                        tabMeta = md;
                    }
                    if (tabMeta instanceof DynamicRecordMetaData) {
                        this.repository.resolveDynamicRecordMetaData((DynamicRecordMetaData)tabMeta);
                        continue block4;
                    }
                    if (!(tabMeta instanceof DefaultRecordMetaData) || ((DefaultRecordMetaData)meta.tabMeta[i]).allTypesResolved) continue block4;
                    this.resolveMetaData((DefaultRecordMetaData)tabMeta);
                    continue block4;
                }
                case 16: {
                    AbstractMetaData md;
                    Serializable tabMeta = meta.tabMeta[i];
                    if (tabMeta instanceof String) {
                        md = null;
                        md = this.loadClassMetaDataFromCache((String)((Object)tabMeta));
                        if (md == null) {
                            md = this.repository.getClassMetaData((String)((Object)tabMeta));
                            if (md == null) {
                                return null;
                            }
                            md = this.loadClassMetaData((String)((Object)tabMeta));
                        }
                        meta.tabMeta[i] = md;
                        tabMeta = md;
                    }
                    if (!(tabMeta instanceof DefaultClassMetaData) || ((DefaultClassMetaData)meta.tabMeta[i]).allTypesResolved) continue block4;
                    this.resolveMetaData((DefaultClassMetaData)tabMeta);
                    continue block4;
                }
            }
        }
        return meta;
    }

    AbapFunctionTemplate loadFunctionTemplateFromCache(String name) {
        return this.functions.get(name);
    }

    AbapFunctionTemplate loadFunctionTemplate(String name) throws JCoException {
        AbapFunctionTemplate template = this.loadFunctionTemplateFromCache(name);
        if (template != null) {
            AbstractMetaData imports = (AbstractMetaData)((Object)template.getImportParameterList());
            AbstractMetaData changings = (AbstractMetaData)((Object)template.getChangingParameterList());
            AbstractMetaData exports = (AbstractMetaData)((Object)template.getExportParameterList());
            AbstractMetaData tables = (AbstractMetaData)((Object)template.getTableParameterList());
            boolean resolved = imports == null || imports.allTypesResolved;
            resolved = resolved && (changings == null || changings.allTypesResolved);
            resolved = resolved && (exports == null || exports.allTypesResolved);
            boolean bl = resolved = resolved && (tables == null || tables.allTypesResolved);
            if (!resolved) {
                template = this.functions.getMutableValue(name);
                imports = (AbstractMetaData)((Object)template.getImportParameterList());
                changings = (AbstractMetaData)((Object)template.getChangingParameterList());
                exports = (AbstractMetaData)((Object)template.getExportParameterList());
                tables = (AbstractMetaData)((Object)template.getTableParameterList());
                try {
                    if (imports != null && !imports.allTypesResolved) {
                        if ((imports = this.resolveMetaData(imports)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for the function " + name);
                        }
                        imports.allTypesResolved = true;
                    }
                    if (changings != null && !changings.allTypesResolved) {
                        if ((changings = this.resolveMetaData(changings)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for the function " + name);
                        }
                        changings.allTypesResolved = true;
                    }
                    if (exports != null && !exports.allTypesResolved) {
                        if ((exports = this.resolveMetaData(exports)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for the function " + name);
                        }
                        exports.allTypesResolved = true;
                    }
                    if (tables != null && !tables.allTypesResolved) {
                        if ((tables = this.resolveMetaData(tables)) == null) {
                            throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for the function " + name);
                        }
                        tables.allTypesResolved = true;
                    }
                }
                catch (JCoException je) {
                    Trace.fireTraceCritical(je.getMessage(), je);
                    throw je;
                }
                catch (Throwable t) {
                    String msg = "loadFunctionTemplate(" + name + ") caused " + t.getMessage();
                    Trace.fireTraceCritical(msg, t);
                    if (t instanceof RuntimeException) {
                        throw new RuntimeException(msg, t);
                    }
                    throw new Error(msg, t);
                }
                this.saveFunctionTemplate(template);
            }
        }
        return template;
    }

    AbapFunctionTemplate saveFunctionTemplate(AbapFunctionTemplate template) {
        if (template == null) {
            return null;
        }
        if (template.getName() == null) {
            throw new IllegalArgumentException("Function name in template is null");
        }
        return this.storeKeeper.storeLocked(template);
    }

    private AbapFunctionTemplate saveFunctionTemplateInternal(AbapFunctionTemplate template) {
        AbapFunctionTemplate removed = null;
        if (template == null) {
            return null;
        }
        if (template.getName() == null) {
            throw new IllegalArgumentException("Function name in template is null");
        }
        try {
            this.storeNestedMetaData((DefaultListMetaData)template.getImportParameterList());
            this.storeNestedMetaData((DefaultListMetaData)template.getChangingParameterList());
            this.storeNestedMetaData((DefaultListMetaData)template.getExportParameterList());
            this.storeNestedMetaData((DefaultListMetaData)template.getTableParameterList());
            removed = this.functions.store(template.getName(), template);
        }
        catch (Throwable t) {
            String msg = "saveFunctionTemplate(" + template.getName() + ") caused " + t.getMessage();
            Trace.fireTraceCritical(msg, t);
            if (t instanceof RuntimeException) {
                throw new RuntimeException(msg, t);
            }
            throw new Error(msg, t);
        }
        return removed;
    }

    AbapFunctionTemplate removeFunctionTemplate(String name) {
        if (name == null) {
            return null;
        }
        return this.functions.remove(name);
    }

    DefaultRecordMetaData loadRecordMetaDataFromCache(String name) {
        return this.structures.get(name);
    }

    DefaultRecordMetaData loadRecordMetaData(String name) throws JCoException {
        DefaultRecordMetaData meta = this.loadRecordMetaDataFromCache(name);
        if (meta != null && !meta.allTypesResolved) {
            meta = this.structures.getMutableValue(name);
            if ((meta = this.resolveMetaData(meta)) == null) {
                throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the meta data description for " + name);
            }
            meta.allTypesResolved = true;
            this.saveRecordMetaData(meta);
            meta = this.structures.get(name);
        }
        return meta;
    }

    DefaultRecordMetaData saveRecordMetaData(DefaultRecordMetaData meta) {
        if (meta == null) {
            return null;
        }
        if (meta.recName == null) {
            throw new IllegalArgumentException("Record name is null");
        }
        return this.storeKeeper.storeLocked(meta);
    }

    private DefaultRecordMetaData saveRecordMetaDataInternal(DefaultRecordMetaData meta) {
        DefaultRecordMetaData removed = this.structures.get(meta.getName());
        if (removed == null || !this.compare(removed, meta)) {
            removed = this.structures.store(meta.getName(), meta);
            this.storeNestedMetaData(meta);
        }
        if (removed != null) {
            this.updateParents(removed, meta);
        }
        return removed;
    }

    DefaultRecordMetaData removeRecordMetaData(String name) {
        if (name == null) {
            return null;
        }
        DefaultRecordMetaData removed = this.structures.remove(name);
        if (removed != null) {
            this.updateParents(removed, (Serializable)((Object)removed.recName));
        }
        return removed;
    }

    DefaultClassMetaData loadClassMetaDataFromCache(String name) {
        return this.classes.get(name);
    }

    DefaultClassMetaData loadClassMetaData(String name) throws JCoException {
        DefaultClassMetaData meta = this.loadClassMetaDataFromCache(name);
        if (meta != null && !meta.allTypesResolved) {
            meta = this.classes.getMutableValue(name);
            if ((meta = this.resolveMetaData(meta)) == null) {
                throw new JCoException(101, "JCO_ERROR_PROGRAM", "Unable to resolve the metadata description for " + name);
            }
            meta.allTypesResolved = true;
            this.saveClassMetaData(meta);
            meta = this.classes.get(name);
        }
        return meta;
    }

    DefaultClassMetaData saveClassMetaData(DefaultClassMetaData meta) {
        if (meta == null) {
            return null;
        }
        if (meta.recName == null) {
            throw new IllegalArgumentException("Class name is null");
        }
        return this.storeKeeper.storeLocked(meta);
    }

    private DefaultClassMetaData saveClassMetaDataInternal(DefaultClassMetaData meta) {
        DefaultClassMetaData removed = null;
        removed = this.classes.get(meta.getName());
        if (removed == null || !this.compare(removed, meta)) {
            removed = this.classes.store(meta.getName(), meta);
            this.storeNestedMetaData(meta);
        }
        if (removed != null) {
            this.updateParents(removed, meta);
        }
        return removed;
    }

    DefaultClassMetaData removeClassMetaData(String name) {
        if (name == null) {
            return null;
        }
        DefaultClassMetaData removed = this.classes.remove(name);
        if (removed != null) {
            this.updateParents(removed, (Serializable)((Object)removed.recName));
        }
        return removed;
    }

    void clear() {
        this.functions.executeLocked(new Runnable(){

            public void run() {
                MetaDataStorage.this.functions.clear();
                MetaDataStorage.this.structures.clear();
                MetaDataStorage.this.classes.clear();
            }
        });
    }

    synchronized void destroy() {
        JCoRuntime rt = JCoRuntimeFactory.getRuntime();
        rt.removeSharedStorage(this.functions);
        rt.removeSharedStorage(this.structures);
    }

    Collection<String> getCachedFunctionNames() {
        Collection<String> names = this.functions.getAllKeys();
        return names;
    }

    Collection<String> getCachedRecordNames() {
        Collection<String> names = this.structures.getAllKeys();
        return names;
    }

    Collection<String> getCachedClassNames() {
        Collection<String> names = this.classes.getAllKeys();
        return names;
    }

    boolean containsRecord(String name) {
        return this.structures.get(name) != null;
    }

    int getFunctionMetaDataCount() {
        return this.functions.size();
    }

    int getRecordMetaDataCount() {
        return this.structures.size();
    }

    int getClassMetaDataCount() {
        return this.classes.size();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(1000);
        buffer.append("cached functions [");
        buffer.append(this.getCachedFunctionNames().size());
        buffer.append("] :");
        Iterator<String> it = this.getCachedFunctionNames().iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("\n");
        buffer.append("cached structures [");
        buffer.append(this.getCachedRecordNames().size());
        buffer.append("] :");
        it = this.getCachedRecordNames().iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("\n");
        buffer.append("cached classes [");
        buffer.append(this.getCachedClassNames().size());
        buffer.append("] :");
        it = this.getCachedClassNames().iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    class StoreKeeperLockingStorage
    extends StoreKeeper {
        StoreKeeperLockingStorage() {
        }

        AbapFunctionTemplate storeLocked(AbapFunctionTemplate template) {
            Helper<AbapFunctionTemplate> h = new Helper<AbapFunctionTemplate>(template);
            h.save(MetaDataStorage.this.functions);
            return (AbapFunctionTemplate)h.removed;
        }

        DefaultClassMetaData storeLocked(DefaultClassMetaData meta) {
            Helper<DefaultClassMetaData> h = new Helper<DefaultClassMetaData>(meta);
            h.save(MetaDataStorage.this.functions);
            return (DefaultClassMetaData)h.removed;
        }

        DefaultRecordMetaData storeLocked(DefaultRecordMetaData meta) {
            Helper<DefaultRecordMetaData> h = new Helper<DefaultRecordMetaData>(meta);
            h.save(MetaDataStorage.this.functions);
            return (DefaultRecordMetaData)h.removed;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Helper<T>
        implements Runnable {
            T meta;
            Throwable throwable;
            T removed;
            boolean finished = false;

            Helper(T meta) {
                this.meta = meta;
            }

            @Override
            public void run() {
                try {
                    if (this.meta instanceof AbapFunctionTemplate) {
                        this.removed = MetaDataStorage.this.saveFunctionTemplateInternal((AbapFunctionTemplate)this.meta);
                    } else if (this.meta instanceof DefaultRecordMetaData) {
                        this.removed = MetaDataStorage.this.saveRecordMetaDataInternal((DefaultRecordMetaData)this.meta);
                    } else if (this.meta instanceof DefaultClassMetaData) {
                        this.removed = MetaDataStorage.this.saveClassMetaDataInternal((DefaultClassMetaData)this.meta);
                    }
                }
                catch (Throwable th) {
                    this.throwable = th;
                }
                this.finished = true;
            }

            public T save(SharedStorage<?, ?> lockInstance) {
                lockInstance.executeLocked(this);
                if (!this.finished) {
                    throw new Error("Save operation has not been finished");
                }
                if (this.throwable != null) {
                    if (this.throwable instanceof RuntimeException) {
                        throw (RuntimeException)this.throwable;
                    }
                    if (this.throwable instanceof Error) {
                        throw (Error)this.throwable;
                    }
                    throw new Error(this.throwable);
                }
                return this.removed;
            }
        }
    }

    class StoreKeeper {
        StoreKeeper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbapFunctionTemplate storeLocked(AbapFunctionTemplate template) {
            SharedStorage sharedStorage = MetaDataStorage.this.functions;
            synchronized (sharedStorage) {
                return MetaDataStorage.this.saveFunctionTemplateInternal(template);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DefaultClassMetaData storeLocked(DefaultClassMetaData meta) {
            SharedStorage sharedStorage = MetaDataStorage.this.functions;
            synchronized (sharedStorage) {
                return MetaDataStorage.this.saveClassMetaDataInternal(meta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DefaultRecordMetaData storeLocked(DefaultRecordMetaData meta) {
            SharedStorage sharedStorage = MetaDataStorage.this.functions;
            synchronized (sharedStorage) {
                return MetaDataStorage.this.saveRecordMetaDataInternal(meta);
            }
        }
    }
}

