/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertBase;
import com.sap.i18n.cp.ConvertCCCDataErrInfo;
import com.sap.i18n.cp.ConvertCToX;
import com.sap.i18n.cp.ConvertSimpleBase;
import com.sap.i18n.cp.ConvertTImplBase;
import com.sap.i18n.cp.ConvertXToC;
import com.sap.i18n.cp.ConvertXToCFactory;
import com.sap.i18n.cp.ConverterException;
import com.sap.i18n.cp.ConverterJNITestDataCpXToC;
import com.sap.i18n.cp.ConverterJNITestDataSingleCToX;
import com.sap.i18n.cp.ConverterJNITestDataSingleXToC;
import com.sap.i18n.cp.ConverterJNITestDataSingleXToCOk;
import com.sap.i18n.cp.ConverterJNITestDataSingleXToCShortcut;
import com.sap.i18n.cp.StrUtil;
import com.sap.i18n.verify.intf.VerifyIntf;

public class ConvertXToCTImpl
extends ConvertTImplBase {
    public static ConverterJNITestDataCpXToC[] m_aTestDataXToCAll = new ConverterJNITestDataCpXToC[]{new ConverterJNITestDataCpXToC("1101", 0, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToCOk(new byte[]{65, 66, 67}, new char[]{'A', 'B', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{65, -60, 67}, new char[]{'A', '#', 'C'}), new ConverterJNITestDataSingleXToC(new byte[]{65, 66, 67, 68, 69}, new char[]{'A', 'B'}, 32)}), new ConverterJNITestDataCpXToC("1100", 0, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToCOk(new byte[]{65, 66, 67}, new char[]{'A', 'B', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{65, -60, 67}, new char[]{'A', '\u00c4', 'C'}), new ConverterJNITestDataSingleXToC(new byte[]{65, 66, 67, 68, 69}, new char[]{'A', 'B'}, 32), new ConverterJNITestDataSingleXToCOk(new byte[0], new char[0]), new ConverterJNITestDataSingleXToC(new byte[]{65, 66}, new char[0], 32)}), new ConverterJNITestDataCpXToC("1101", 0, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToCOk(new byte[]{65, 66, 67}, new char[]{'A', 'B', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{65, -60, 67}, new char[]{'A', '#', 'C'}), new ConverterJNITestDataSingleXToC(new byte[]{65, 66, 67, 68, 69}, new char[]{'A', 'B'}, 32)}), new ConverterJNITestDataCpXToC("1401", 0, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToCOk(new byte[]{65, 66, 67}, new char[]{'A', 'B', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{65, -60, -59, 67}, new char[]{'A', '\u00c4', '\u0139', 'C'})}), new ConverterJNITestDataCpXToC("8000", 0, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToCOk(new byte[]{65, 66, 67}, new char[]{'A', 'B', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{-115, -92}, new char[]{'\u58be'}), new ConverterJNITestDataSingleXToCOk(new byte[]{-127, -127}, new char[]{'\uff1d'}), new ConverterJNITestDataSingleXToCOk(new byte[]{-127, -127}, new char[]{'\uff1d'}), new ConverterJNITestDataSingleXToCOk(new byte[]{-127, 48}, new char[]{'\u0081', '0'}), new ConverterJNITestDataSingleXToCOk(new byte[]{-60, -127, 64}, new char[]{'\uff84', '\u3000'}), new ConverterJNITestDataSingleXToCOk(new byte[]{-121, -112}, new char[]{'\udbf8', '\udc3c'}), new ConverterJNITestDataSingleXToCOk(new byte[]{65, -127}, new char[]{'A', '\u0081'}), new ConverterJNITestDataSingleXToC(new byte[]{65, 66, 67}, new char[]{'A', 'B'}, 32), new ConverterJNITestDataSingleXToC(new byte[]{65, -127, -127}, new char[]{'A'}, 32), new ConverterJNITestDataSingleXToC(new byte[]{65, -121, -112}, new char[]{'A', '\u0000'}, 32), new ConverterJNITestDataSingleXToCOk(new byte[0], new char[0]), new ConverterJNITestDataSingleXToC(new byte[]{-127, -127}, new char[0], 32), new ConverterJNITestDataSingleXToCOk(new byte[]{-127}, new char[]{'\u0081'}), new ConverterJNITestDataSingleXToCOk(new byte[]{-116, -70}, new char[]{'\u7384'})}), new ConverterJNITestDataCpXToC("4102", 0, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToCOk(new byte[]{0, 65, 0, 66, 0, 67}, new char[]{'A', 'B', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{0, 65, 48, 0, 0, 67}, new char[]{'A', '\u3000', 'C'}), new ConverterJNITestDataSingleXToC(new byte[]{0, 65, 0, 66}, new char[]{'A'}, 32), new ConverterJNITestDataSingleXToCShortcut(new byte[]{0, 65, 0}, new char[]{'A'}, 512, 512), new ConverterJNITestDataSingleXToCOk(new byte[]{0, 65, 0, 66, 0, 67}, new char[]{'A', 'B', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[0], new char[0])}), new ConverterJNITestDataCpXToC("4103", 0, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToCOk(new byte[]{65, 0, 66, 0, 67, 0}, new char[]{'A', 'B', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{65, 0, 0, 48, 67, 0}, new char[]{'A', '\u3000', 'C'}), new ConverterJNITestDataSingleXToC(new byte[]{65, 0, 66, 0}, new char[]{'A'}, 32), new ConverterJNITestDataSingleXToCShortcut(new byte[]{65, 0, 66}, new char[]{'A'}, 512, 512), new ConverterJNITestDataSingleXToCOk(new byte[]{65, 0, 66, 0, 67, 0}, new char[]{'A', 'B', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[0], new char[0])}), new ConverterJNITestDataCpXToC("4110", 0, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToCOk(new byte[]{65, 66, 67}, new char[]{'A', 'B', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{65, -61, -124, 67}, new char[]{'A', '\u00c4', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{65, -29, -128, -128, 67}, new char[]{'A', '\u3000', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{65, -23, -128, -128, 67}, new char[]{'A', '\u9000', 'C'}), new ConverterJNITestDataSingleXToCOk(new byte[]{-12, -114, -128, -68}, new char[]{'\udbf8', '\udc3c'}), new ConverterJNITestDataSingleXToCOk(new byte[]{-9, -65, -65, -65}, new char[]{'#'}), new ConverterJNITestDataSingleXToCShortcut(new byte[]{-8, -128, -128, -128, -128}, new char[]{'#', '#', '#', '#', '#'}, 0, 2048), new ConverterJNITestDataSingleXToCShortcut(new byte[]{-8, -120, -128, -128, -128}, new char[]{'#', '#', '#', '#', '#'}, 0, 2048), new ConverterJNITestDataSingleXToC(new byte[]{-128}, new char[]{'#'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{-61, 65}, new char[]{'#', 'A'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{-61}, new char[]{'#'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{-29, -128, 65}, new char[]{'#', '#', 'A'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{-29}, new char[]{'#'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{-29, -128}, new char[]{'#'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{-29, 65}, new char[]{'#'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{-12}, new char[]{'#'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{-12, 65, 66}, new char[]{'#'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{-12, -128, -128, 65}, new char[]{'#', '#', '#', 'A'}, 0), new ConverterJNITestDataSingleXToC(new byte[]{65, 66, 67}, new char[]{'A'}, 32), new ConverterJNITestDataSingleXToC(new byte[]{65, -12, -114, -128, -68}, new char[]{'A', '\u0000'}, 32), new ConverterJNITestDataSingleXToCOk(new byte[0], new char[0])}), new ConverterJNITestDataCpXToC("", 16, new ConverterJNITestDataSingleXToC[]{new ConverterJNITestDataSingleXToC(new byte[]{65, 66, 67}, new char[0], 16)})};

    public ConvertXToCTImpl(VerifyIntf oVerify) {
        super(oVerify);
    }

    public void testMain() {
        this.printLogln("TEST ConvertXToCTImpl BEGIN");
        this.testConvertXToC();
        this.printLogln("testConvertXToC done");
        this.stressConvertXToC("1100");
        this.stressConvertXToC("8000");
        this.printLogln("stressConvertXToC done");
        this.printLogln("TEST ConvertXToCTImpl END");
        this.testConvertCCCDataErrInfo();
    }

    void testConvertCCCDataErrInfo() {
        char[] filterCP = new char[]{'0', '0', '0', '0'};
        ConvertCCCDataErrInfo dataErrInfo = new ConvertCCCDataErrInfo("testAction", filterCP, filterCP, 0, null, null, 0);
        this.verify(dataErrInfo.m_abOutDone == null && dataErrInfo.m_sOutDone == null, "dataErrInfo.m_abOutDone=" + dataErrInfo.m_abOutDone + ", expected: null - " + "dataErrInfo.m_sOutDone=" + dataErrInfo.m_sOutDone + ", expected: null - ", "test ConvertCCCDataErrInfo test with inData=null");
        dataErrInfo = new ConvertCCCDataErrInfo("testAction", filterCP, filterCP, 0, new Object(), new Object(), 0);
        this.verify(dataErrInfo.m_abOutDone == null && dataErrInfo.m_sOutDone == null, "dataErrInfo.m_abOutDone=" + dataErrInfo.m_abOutDone + ", expected: null - " + "dataErrInfo.m_sOutDone=" + dataErrInfo.m_sOutDone + ", expected: null - ", "test ConvertCCCDataErrInfo test with inData instanceOf Object");
    }

    public void testConvertXToC() {
        this.testConvertXToCInner(true);
        this.testConvertXToCInner(false);
        this.testConvertXToCRound("1100".toCharArray());
        this.testConvertXToCRound("1401".toCharArray());
        this.testConvertXToCRound("1610".toCharArray());
        this.testConvertXToCRound("8000".toCharArray());
    }

    public void testConvertXToCInner(boolean bUseShortcut) {
        for (int i = 0; i < m_aTestDataXToCAll.length; ++i) {
            ConverterJNITestDataCpXToC oDataCp = m_aTestDataXToCAll[i];
            ConvertXToC oCnvObj = bUseShortcut ? ConvertXToCFactory.createConvertXToC(oDataCp.m_acCpIn, true) : new ConvertXToC(oDataCp.m_acCpIn, true);
            this.verifyConvertInit("ConvertXToC", oCnvObj, oDataCp.m_nReturn);
            if (oDataCp.m_nReturn != 0) {
                return;
            }
            boolean bReallyUseShortcut = oCnvObj.isShortcut();
            ConvertXToC oCnvObjBreakOnErr = bUseShortcut ? ConvertXToCFactory.createConvertXToC(oDataCp.m_acCpIn, false) : new ConvertXToC(oDataCp.m_acCpIn, false);
            for (int j = 0; j < oDataCp.m_aData.length; ++j) {
                ConverterJNITestDataSingleXToC oData = oDataCp.m_aData[j];
                if (!bReallyUseShortcut && !oData.m_bNative) continue;
                this.testConvertXToCSingle(oCnvObj, oData, bUseShortcut);
                if (oData.m_nReturn == 0 && oDataCp.m_acCpIn[0] != '4') {
                    byte[] abInAdd = this.appendByteArr(oData.m_abDataIn, (byte)48);
                    char[] acOutAdd = this.appendCharArr(oData.m_acDataOut, '0');
                    ConverterJNITestDataSingleXToC oDataAdd = new ConverterJNITestDataSingleXToC(abInAdd, acOutAdd, 0);
                    this.testConvertXToCSingle(oCnvObj, oDataAdd, bUseShortcut);
                    abInAdd = this.appendByteArr(abInAdd, (byte)48);
                    acOutAdd = this.appendCharArr(acOutAdd, '0');
                    oDataAdd = new ConverterJNITestDataSingleXToC(abInAdd, acOutAdd, 0);
                    this.testConvertXToCSingle(oCnvObj, oDataAdd, bUseShortcut);
                }
                this.testConvertXToCSingleBreakOnErr(oCnvObjBreakOnErr, oData, bUseShortcut);
            }
        }
    }

    public void testConvertXToCSingle(ConvertXToC oCnvObj, ConverterJNITestDataSingleXToC oData, boolean bUseShortcut) {
        char[] acOut;
        String sOut;
        boolean bConvertArrOk;
        boolean bTooLong = oData.m_nReturn == 32;
        boolean bReallyUseShortcut = bUseShortcut && ConvertBase.m_bCnvShortcutsAvailable;
        boolean bl = bConvertArrOk = bReallyUseShortcut || ConvertBase.m_bCnvArrAvailable;
        if (!bTooLong) {
            sOut = oCnvObj.Convert(oData.m_abDataIn);
            this.verifyConvertXToC("ConverterJNI.ConvertXToC", oCnvObj, oData, sOut);
        }
        if (bConvertArrOk) {
            acOut = new char[oData.m_acDataOut.length];
            oCnvObj.ConvertArr(oData.m_abDataIn, 0, oData.m_abDataIn.length, acOut, 0, acOut.length);
            sOut = new String(acOut);
            this.verifyConvertXToC("ConverterJNI.ConvertXToCArr", oCnvObj, oData, sOut);
        }
        if (bConvertArrOk) {
            acOut = new char[oData.m_acDataOut.length];
            try {
                oCnvObj.ConvertArrExc(oData.m_abDataIn, 0, oData.m_abDataIn.length, acOut, 0, acOut.length);
            }
            catch (ConverterException e) {
                this.verify(false, "Unexpected Exception: " + e.getMessage(), "ConverterJNI.ConvertXToCArr");
            }
            sOut = new String(acOut);
            this.verifyConvertXToC("ConverterJNI.ConvertXToCArr", oCnvObj, oData, sOut);
        }
        if (bConvertArrOk) {
            byte[] abIn = this.moveByteArrBegin(oData.m_abDataIn, 1);
            char[] acOut2 = new char[oData.m_acDataOut.length + 2];
            oCnvObj.ConvertArr(abIn, 1, abIn.length, acOut2, 2, acOut2.length);
            sOut = new String(acOut2, 2, acOut2.length - 2);
            this.verifyConvertXToC("ConverterJNI.ConvertXToCArrMoved", oCnvObj, oData, sOut);
        }
        if (!bTooLong) {
            int nOutLen = oCnvObj.outLength(oData.m_abDataIn, 0, oData.m_abDataIn.length);
            this.verifyConvertXToCLen("ConverterJNI.outLength", oCnvObj, oData, nOutLen);
        }
    }

    public void testConvertXToCSingleBreakOnErr(ConvertXToC oCnvObj, ConverterJNITestDataSingleXToC oData, boolean bUseShortcut) {
        char[] acOut;
        String sOut;
        boolean bConvertArrOk;
        boolean bTooLong = oData.m_nReturn == 32;
        boolean bReallyUseShortcut = bUseShortcut && ConvertBase.m_bCnvShortcutsAvailable;
        boolean bl = bConvertArrOk = bReallyUseShortcut || ConvertBase.m_bCnvArrAvailable;
        if (!bTooLong) {
            sOut = oCnvObj.Convert(oData.m_abDataIn);
            this.verifyConvertXToCBreakOnErr("ConverterJNI.ConvertXToC", oCnvObj, oData, sOut);
        }
        if (bConvertArrOk) {
            acOut = new char[oData.m_acDataOut.length];
            oCnvObj.ConvertArr(oData.m_abDataIn, 0, oData.m_abDataIn.length, acOut, 0, acOut.length);
            sOut = oCnvObj.GetLastRet() == 0 ? new String(acOut) : null;
            this.verifyConvertXToCBreakOnErr("ConverterJNI.ConvertXToCArr", oCnvObj, oData, sOut);
        }
        if (bReallyUseShortcut) {
            acOut = new char[oData.m_acDataOut.length];
            int nErrPos = -1;
            for (int i = 0; i < oData.m_acDataOut.length; ++i) {
                if (oData.m_acDataOut[i] != '#') continue;
                nErrPos = i;
                break;
            }
            try {
                oCnvObj.ConvertArrExc(oData.m_abDataIn, 0, oData.m_abDataIn.length, acOut, 0, acOut.length);
                this.verify(oData.m_nReturn == 0 && nErrPos == -1, "Expected exception did not occur. At test " + this.describeTestXToC(oCnvObj, oData, new String(acOut)), "ConverterJNI.ConvertXToCArrExc");
            }
            catch (ConverterException e) {
                this.verify(oData.m_nReturn != 0 || nErrPos != -1, "Unexpected Exception: " + e.getMessage() + " at test " + this.describeTestXToC(oCnvObj, oData, null), "ConverterJNI.ConvertCToXArrExc");
            }
        }
    }

    public void testConvertXToCRound(char[] sCp) {
        this.printLogln("testConvertXToCRound Cp: " + new String(sCp));
        byte[] abIn = new byte[2];
        char[] acCnv = new char[2];
        byte[] abEnd = new byte[2];
        ConvertXToC oCnvObj = ConvertXToCFactory.createConvertXToC(sCp, true);
        ConvertCToX oCnvObjBack = new ConvertCToX(sCp, true);
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                abIn[0] = (byte)i;
                abIn[1] = (byte)j;
                int nDone = oCnvObj.ConvertArr(abIn, 0, 2, acCnv, 0, 2);
                oCnvObjBack.ConvertArr(acCnv, 0, nDone, abEnd, 0, 2);
                ConverterJNITestDataSingleCToX oTestData = new ConverterJNITestDataSingleCToX(acCnv, abIn, 0);
                this.verifyConvertCToX("testConvertXToCRound", oCnvObjBack, oTestData, abEnd);
            }
        }
    }

    protected void verifyConvertXToCBreakOnErr(String sName, ConvertSimpleBase oCnvObj, ConverterJNITestDataSingleXToC oTestData, String sOut) {
        if (sOut != null) {
            this.verifyConvertXToC("ConverterJNI.ConvertXToC", oCnvObj, oTestData, sOut);
            return;
        }
        int nReturn = oCnvObj.GetLastRet();
        String sOutExpected = new String(oTestData.m_acDataOut);
        int nErrPos = sOutExpected.indexOf(35);
        int nReturnExpected = nErrPos != -1 ? 2048 : oTestData.m_nReturn;
        String sInBytes = StrUtil.buildByteString(oTestData.m_abDataIn);
        this.verify(nReturn == nReturnExpected, oCnvObj.getCnvDisplayText() + " Input: " + sInBytes + " returned: " + nReturn + " (" + nReturnExpected + ")", sName);
        sOut = "";
        String sOutBytes = StrUtil.buildByteString(sOut);
        String sOutExpectedBytes = nReturnExpected == 0 ? StrUtil.buildByteString(new String(oTestData.m_acDataOut)) : "";
        this.verify(sOutBytes.equals(sOutExpectedBytes), oCnvObj.getCnvDisplayText() + ": " + sInBytes + "->" + sOutBytes + " (" + sOutExpectedBytes + ")", sName);
        if (nReturnExpected != 0) {
            this.printLogln("Expected error occured:\n" + oCnvObj.GetLastError().GetText());
        }
    }

    void verifyConvertXToCLen(String sName, ConvertSimpleBase oCnvObj, ConverterJNITestDataSingleXToC oTestData, int nOutLen) {
        String sInBytes = StrUtil.buildByteString(oTestData.m_abDataIn);
        int nExpectedLen = oTestData.m_acDataOut.length;
        this.verify(nOutLen == nExpectedLen, oCnvObj.getCnvDisplayText() + ": " + sInBytes + " CnvLen: " + nOutLen + "(" + nExpectedLen + ")", sName);
    }

    private void stressConvertXToCInner(String sCheckName, ConvertXToC oCnvObj, byte[] abIn, int nCnt) {
        int nLen = abIn.length;
        for (int i = 0; i < nLen; ++i) {
            abIn[i] = (byte)(64 + i % 10);
        }
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while ((long)i < (long)nCnt * 1L) {
            oCnvObj.Convert(abIn);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Stress test \"" + sCheckName + "\"", startLoop, endLoop, (long)nCnt * 1L, nLen);
    }

    private void stressConvertXToCArrInner(String sCheckName, ConvertXToC oCnvObj, byte[] abIn, int nCnt) {
        int nLen = abIn.length;
        char[] acOut = new char[nLen];
        for (int i = 0; i < nLen; ++i) {
            abIn[i] = -127;
        }
        long startLoop = System.currentTimeMillis();
        int i = 0;
        while ((long)i < (long)nCnt * 1L) {
            oCnvObj.ConvertArr(abIn, 0, nLen, acOut, 0, nLen);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.verify((abIn[nLen - 1] & 0xFF) > 128 || acOut[nLen - 1] == abIn[nLen - 1], "Stress test failed with size: " + nLen, sCheckName);
        this.timecheckPrintResult("Stress test \"" + sCheckName + "\"", startLoop, endLoop, (long)nCnt * 1L, nLen);
    }

    private void stressConvertXToCCreate(String sInCp, int nCnt) {
        long startLoop = System.currentTimeMillis();
        ConvertXToC[] aCnvObj = new ConvertXToC[nCnt];
        int i = 0;
        while ((long)i < (long)nCnt * 1L) {
            aCnvObj[i % nCnt] = ConvertXToCFactory.createConvertXToC(sInCp.toCharArray(), true);
            ++i;
        }
        long endLoop = System.currentTimeMillis();
        this.timecheckPrintResult("Stress test \"XToCCreate\"", startLoop, endLoop, (long)nCnt * 1L, 1L);
    }

    public void stressConvertXToC(String sCp) {
        ConvertXToC oCnvObj = ConvertXToCFactory.createConvertXToC(sCp.toCharArray(), true);
        this.printLogln("Stress test begin: " + oCnvObj.getCnvDisplayText());
        byte[] abInFrequent = new byte[1];
        this.stressConvertXToCInner("Frequent string", oCnvObj, abInFrequent, 1000000);
        this.stressConvertXToCArrInner("Frequent array", oCnvObj, abInFrequent, 1000000);
        byte[] abInStandard = new byte[10];
        this.stressConvertXToCInner("Standard string", oCnvObj, abInStandard, 100000);
        this.stressConvertXToCArrInner("Standard array", oCnvObj, abInStandard, 100000);
        byte[] abInMedium = new byte[1000];
        this.stressConvertXToCInner("Medium string", oCnvObj, abInMedium, 1000);
        this.stressConvertXToCArrInner("Medium array", oCnvObj, abInMedium, 1000);
        byte[] abInMedium2 = new byte[10250];
        this.stressConvertXToCInner("Medium2 string", oCnvObj, abInMedium2, 100);
        this.stressConvertXToCArrInner("Medium2 array", oCnvObj, abInMedium2, 100);
        byte[] abInLarge = new byte[1000000];
        this.stressConvertXToCInner("Large string", oCnvObj, abInLarge, 1);
        this.stressConvertXToCArrInner("Large array", oCnvObj, abInLarge, 1);
        this.stressConvertXToCCreate(sCp, 100000);
    }
}

