/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AboutDialog {
    private static final long[] father_son_gif = new long[]{-10977661529601466L, 5279907617450295368L, 20266202615709763L, 3669113436768269L, 795460439177498387L, 2311774952058201884L, 2168237128233857070L, 2967076328039923251L, 3910873989295134529L, 5065509796377145918L, 6512585837413814610L, 5764566842228149774L, 1014173115029460262L, 5707517809749086031L, 0x4F4F4F4F4F4F4F4FL, 0x4F4F4F4F4F4F4F4FL, 0x4F4F4F4F4F4F4F4FL, 0x4F4F4F4F4F4F4F4FL, 0x4F4F4F4F4F4F4F4FL, 5714873654208102336L, 4793872039310083L, 81627752121303825L, 144049217831174146L, 0x301010100000000L, 1029L, 851030607134660L, 17469040775725827L, 73749759714198784L, 4328718340L, 1226406407294030626L, 4706649824952394625L, -6795627116977089855L, 2680559060144910963L, -5592762914472591420L, 0x14010100000000L, 0L, 4291035156L, 0x1101000000000000L, 0L, 281311768740609L, 581654821224192L, 8318421972520670306L, -4795741691741893506L, -385719595301663080L, 1778597466227311296L, 8211646243047117753L, -71928129851889326L, -6880865885663371845L, -7518508518426967446L, -5251052040927043852L, -339256136647095166L, -5108262826052614522L, 3915959460572581718L, 4108372702538306251L, 7613262479008438681L, 2481663230124748960L, 2870073266902710399L, 756736948367440689L, 8956969010367853926L, 6219572124546448692L, -3360549975304816926L, 1862136721270690319L, -1553743421942759002L, 8355996787569605241L, -1267939299719372801L, 19869664447136819L, -4362125618400076773L, -205899795687760875L, -71856177311863445L, -8378012528982111611L, -3281034093852724482L, 6652198073182640626L, -5292820426939001217L, 6464353217465129991L, 1895375523064446720L, -8023942964189894641L, -545695945107535179L, -4531501994139709963L, -8963555828066607130L, 7726326311511188419L, -1732288134369525525L, -4729297483000355091L, -7741820542361583731L, 95474276647318826L, -5072047520226743728L, 4436420720418359862L, -8355697456716522271L, -5488813903597192865L, 1081931180263848344L, 5050137775515481373L, 1900936015205491100L, -7138498247955617292L, -194204980543831411L, -7598644349884844610L, -8589390929799936287L, -1203855129867846102L, 1025496539743873416L, 3237001277246015351L, 8612571869202835934L, 5420333695138271029L, 7400594466463522898L, 8850218899232998500L, 7334431958439020752L, 4589372056008700362L, -9169189798883505992L, -3175689644290920179L, -5119759734519053212L, 7592311210915579433L, -8174965252756276620L, -3605499079752590442L, 4502752076045503860L, -8904652375898525958L, 8750052310077023008L, -2614369116174748823L, -5662766131304370166L, 7145152165888775824L, -3552252908807252125L, -1815634099122824348L, -7982470846879220610L, 6116820029348055858L, 1552124636117890510L, 7723424410805576479L, -6798546088133321812L, 2755999153588426513L, 9117181744110680283L, -7918422631747408417L, -1341702945872021296L, -5223810924106671924L, 7801548228645432235L, 8896581274898816019L, -7349127400261273139L, 5342970586013039678L, 8207364264154852070L, -4032583144968207671L, -5770492744604660562L, 5734856054315205751L, 6199389457254779567L, -5128011646086593913L, -3229503732457742261L, -1894586220674442826L, -7706270365327601599L, -1834172631885541176L, -1854857222557537815L, 6480352651078419593L, -3587385173671409805L, 3737400903961505187L, -2878245828497926033L, -7813101272454671627L, 5023564601543962245L, 6192951108243710486L, -8838311242671000542L, -9164521511065676700L, 767125264806105830L, 2591350497166729715L, -5845232208015066799L, 4669518597645304340L, 8140291936525328202L, 422676977084062002L, -3587629112186779837L, 6334623271818455079L, 4844788373718400563L, 5647773574679094196L, -2890920529509081360L, -9086136310657502726L, 198435490228133401L, -3945680498031315991L, -2776934427373836462L, 1123656029056231407L, -3543472319181725156L, 9094303629659827955L, 5551955584500251777L, -887642895021105457L, -8562416218109372637L, -4406503972124009047L, -5206805664420340692L, -3305071551881491041L, 2540245099944628261L, 2598385235736186034L, -604064101717324580L, -6935956246479681964L, -5519213556161418662L, -8732024871226502645L, -4790949299002802432L, 7660737757076301951L, -4877893198949419346L, 471934123486412379L, 5825283425662185189L, -5439047274555886057L, -8485729965659274511L, 4654873140193228765L, 3509855780506636631L, -676099090210834919L, 7993075904675292443L, 8262105585179196679L, 6497646546917985172L, 4972252186664545376L, -537114865128556371L, 6239473470069245828L, -7682604896802532444L, 6524955403743992960L, -1772127518439652771L, -2719203075480107236L, -7953442081333666176L, -373781732443782069L, -874630711500963272L, -3159189135756581711L, -6019242826912120242L, -5737388390139584492L, -2243900410320529248L, -7044918612920176137L, 3425447734835839873L, 5761437943620387705L, 3876579217382094929L, -7563922558184701101L, -6966616849451901997L, 7933151747312961311L, 9031642598862684253L, 5307026869135450004L, 8494866763285865585L, 2839359435892591589L, -1200186998302612123L, 1813702141716311005L, 7652226301432735266L, 8737788475208234678L, -3011757205013616880L, 5605267038731866447L, -6070788837573893247L, 6054540164900508918L, 7992449371231865544L, 2459010964302135960L, -735242048305734513L, -410589690266205758L, -78087309255408500L, 8815519501662878674L, -3225482995593872004L, -6194239351345168711L, -6902868726563770871L, -4250143441412603378L, 8790159889397482465L, 2663006806726134555L, -5545775813959227562L, 2060207642014219892L, -4918694524982132449L, 5400626078779293972L, 2453854226966299694L, 5745755862312291111L, 918742555310364023L, 902435872565649968L, 6192887336619659028L, 5009301481620677316L, -4654806729656396396L, -2072121885741833396L, 7402492305896505625L, -3487579260107282018L, 5047888257874408526L, -8717971238652462003L, -8336139288096161026L, 1479118144746379891L, 1865775249291370366L, -4105782231205439236L, -6018509301891160319L, 7959848463472981150L, 6701901640225947049L, -8750594276026739637L, -8597157023982703541L, -6533104423547874665L, -282064736850676141L, 5945877240532172800L};
    private static final long[] slogan_gif = new long[]{5136714057254008577L, 1801657554267275263L, 7378698125341985932L, -8308381882781629726L, -2097889296425322119L, -1374463452084046347L, -749398977724962372L, -4846726454570460184L, -7013576343934698101L, -5513945588971885386L, -4767626467090866282L, 151553436338491689L, 8430758745680875472L, -2962032897904381021L, 2176219565846176055L, 9090582377262775115L, 6597031758897949815L, 3333655630736005681L, 8986290653392657797L, -7874611255531024675L, -5061248162421516183L, -7093278551561171837L, -8091115158588581701L, 5864701904974496457L, -2528793250191904948L, 6816162739659453131L, 8902123223003428861L, -619113386874189071L, -795536550880350225L, -2602824743287853072L, -862968814028013577L, -576649440622953027L, -3109201817940483668L, -4092283831799928496L, 6814160377944139494L, 4346411500727430121L, -1928294285044306228L, -3323600142753479210L, -3615299039266380186L, -7419926178176534158L, 8907395998485610655L, -580982099359039489L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -13893632L, 130846598103047L, -108085830504643194L, -8680537053616894578L, -8101815670912281194L, -7523097084231377506L, -6944372918555728474L, -6365651522798441216L, 1157726455039571382L, -5208208790266767849L, -5854466473329375802L, -8208346774744982578L, -3688217391389158628L, 2098334219206712798L, -2341274633423936989L, -1791053954643333650L, -1502753085932374538L, -578438184788614879L, 2892527743268897285L, -8537939749554851472L, -6862774422063137608L, -4466292003571471908L, -3985224788269641032L, 8647231820311110216L, -8356339491831866847L, 6112704593685597468L, 3347010818905621769L, 2096200751117939880L, -3367250621012369068L, 1193183572637575217L, -1709528305679597384L, -4542510780712432563L, -8351937977891198921L, -4111661376113532930L, 2687035036005500170L, 888591285898846757L, 698694124175183032L, 3472568975522431233L, -9058831182559222757L, 4817101230534341634L, 4045042833669816466L, -840957821921606744L, 6028981129707983534L, 3645783230956841487L, 41703616134797648L, -8857988267402732959L, -4212511275580694834L, -4865819391333336315L, -7880236635195401476L, -8493151936053961420L, 5463359909652205083L, 5486536551590362086L, 1617386075588313234L, 2964329682880987466L, -4177298314806882219L, 5503685065412206789L, 1538173438991139336L, -8016271495090085590L, 1173865313579776706L, -2218269508352341985L, 2373678854457290883L, 1250705135664792252L, -9205053382436158698L, 751152358658012392L, 7173955996539158531L, -564981235620053438L, 41096533097091404L, 1038432181659779108L, -7853929853344150452L, -5177855058578447209L, 4410713712227456530L, 2779382988879007491L, 2017824402047400230L, -7925442059030210566L, 2893445455347786496L, 5990466064700540528L, 2924615333239595364L, -407435014561189660L, -7235606022074727912L, 5938160499509224480L, -8549280247791440560L, -9006020114385983583L, -1891294707112423419L, 916611672780706108L, 8180101143416389786L, -7558719126243767765L, 2860357822605141868L, 2171558075247814883L, -7476218715363965780L, -476366137544005219L, -4037977738818160952L, -4566997507935133823L, 7064248629075570924L, -4834325714532992798L, 6624722003240380818L, -7425631339944338878L, 8039769980992268770L, 477565324921548980L, 77452607691124252L, -1745519688747769725L, 886616421189763820L, -7491455387711016446L, 296088736115725296L, -1720140165170151628L, -5499880299534599744L, 2859008341511184L, 8100323480867382203L, -2959396115123267006L, 7840005571320529760L, 476577641424527552L, -3399049363408650054L, 6571597659668018895L, 4737731230268701501L, -806845458868545562L, -5000216430895542936L, -2560481541132148194L, 8973428022664250382L, 2509631746087328194L, -3094053202983382246L, 7250941714597761712L, -4502941731787636148L, 5496869884523117058L, 7893607211971716050L, -5435328451219959171L, -6059273325037256151L, -2877534023287541334L, 6822314652093720298L, 703862152129371979L, 4449458880400570327L, 508032504385327642L, -877349844342825084L, 5246542622882147080L, -6420978501913072398L, 19730686048879876L, -231037381831563070L, 741581032673012757L, -6695912731859009830L, 2416575374525977446L, -673035421734074136L, 6119972939485501133L, 8596265711268667431L, 8224990723714978516L, -368112068214175409L, -7322695693340501754L, -9185635231887167080L, 3181421000902648415L, -5038727889627058096L, 7512744831035586236L, 703137000116003114L, 6961698009608164048L, -9220622570107102837L, -9137131211492649534L, 5587015504619405325L, -7973417181525212336L, -3198195956575867379L, -4441738825438901755L, 4689362451897031649L, 721021991930637197L, 7729482192757573198L, 2419156333657984967L, -5242155720630967428L, 2641546990399012657L, -1204807304708478384L, 85336125522501825L, 820464927473713221L, -1785669484218908326L, 8845180016953272594L, 6354299028669237928L, -3025701624434512768L, 5506128420164318384L, 4067542508009362427L, 8522508407126459729L, -3813967425187486463L, 3067191161595727401L, 5563109319635312743L, -1217035486157426833L, 424416720039977316L, 1068299122036153288L, -4143049917005751384L, 4687770505116951584L, 375426055230984848L, 3230453815515317097L, 2054778728867601971L, -6603667355749113395L, -8327580067734540920L, -5040815428144186304L, 5383866155734550856L, 6351012574572061730L, 1360260816342896373L, -8522104099079532166L, -3181156679330955922L, 7943826281843595587L, -632284054656253935L, -1586957762784785531L, 5224925679345274495L, 8716060813693569788L, 4685482628828567037L, 2460500215231748367L, 5636366364699833538L, 819325589826905419L, 281846870728461570L, -349979188809062146L, 6096733925853553210L, -4538730301302736148L, 6671847857811027324L, -5396574163384107002L, -248260846699210987L, -7994972611380205491L, 3272651625879535758L, -6725650607506777691L, -8215048786560134622L, -894288684578411501L, 3656988941954558561L, -5354964664843947704L, 2969062281563768299L, 2339363123213486848L, -4916472683607794352L, 3257639921320368390L, -7984854038670000462L, -3301180903146052894L, 524397236485245919L, -370817175272799399L, 2897166998248297497L, 749065535762809432L, 2915424112182498812L, 584630517798993805L, -8898176556414445320L, -4460588448218363681L, 1043701258391127040L, 0x3B00000000000000L};
    static final Color m_white = Color.white;
    static final Color m_orange = new Color(16755742);
    static final Color m_grey = new Color(0x4C4C4C);
    static final Color m_lightgrey = Color.lightGray;
    static final String HR = "--------------------------------------------------------------------------------------";
    private ArrayList<Section> m_sections = new ArrayList();
    private String m_product_name = "SAP Java Connector";
    private String m_copyright = "Copyright (c) 2000-2016 SAP SE. All rights reserved.";

    public AboutDialog(String product_name) {
        this.m_product_name = product_name;
        this.addSection(this.getJavaVersion());
    }

    public void addSection(Section section) {
        this.m_sections.add(section);
    }

    protected static String getFilePathToClass(Class<?> cls) {
        String filepath = null;
        try {
            String ptc;
            String rsc = cls.getName().replace('.', '/') + ".class";
            URL url = cls.getClassLoader().getResource(rsc);
            String string = ptc = url != null ? url.getProtocol() : null;
            if ("bundleresource".equals(ptc)) {
                Class<?> classURLResolver;
                try {
                    classURLResolver = cls.getClassLoader().loadClass("org.eclipse.core.runtime.FileLocator");
                }
                catch (Throwable t) {
                    classURLResolver = cls.getClassLoader().loadClass("org.eclipse.core.runtime.Platform");
                }
                Method methodResolve = classURLResolver.getDeclaredMethod("resolve", URL.class);
                url = (URL)methodResolve.invoke(classURLResolver, url);
                ptc = url.getProtocol();
            }
            if ("jar".equals(ptc) || "file".equals(ptc)) {
                filepath = URLDecoder.decode(url.getFile(), "UTF-8");
                if ((filepath = filepath.substring(0, filepath.length() - rsc.length() - ("jar".equals(ptc) ? 2 : 1))).startsWith("jar:")) {
                    filepath = filepath.substring(4);
                }
                if (filepath.startsWith("file:")) {
                    filepath = filepath.substring(5);
                }
                filepath = new File(filepath).getCanonicalPath();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return filepath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Section getManifest(boolean withDigests) {
        Section section;
        block23: {
            String line;
            ZipInputStream is;
            block21: {
                String path;
                block19: {
                    is = null;
                    section = new Section("Manifest");
                    path = this.getOwnFilePath();
                    if (path != null) break block19;
                    Section section2 = section;
                    Object var12_8 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return section2;
                }
                is = new ZipInputStream(new BufferedInputStream(new FileInputStream(path)));
                ZipEntry entry = null;
                while ((entry = is.getNextEntry()) != null && !entry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                    is.closeEntry();
                }
                if (entry != null) break block21;
                Section section3 = section;
                Object var12_9 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return section3;
            }
            LineNumberReader in = new LineNumberReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                int index_of_separator = line.indexOf(":");
                if (index_of_separator <= 0) continue;
                String name = line.substring(0, index_of_separator).trim();
                if (!withDigests && (name.equals("Name") || name.equals("SHA1-Digest"))) continue;
                String value = index_of_separator < line.length() ? line.substring(index_of_separator + 1).trim() : "";
                section.addEntry(name, value);
            }
            Object var12_10 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block23;
            }
            catch (IOException ioe) {}
            break block23;
            {
                catch (Throwable ex) {
                    Object var12_11 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block23;
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return section;
    }

    protected String getOwnFilePath() {
        return AboutDialog.getFilePathToClass(this.getClass());
    }

    private Section getJavaVersion() {
        Section section = new Section("Java Runtime");
        String os_version = System.getProperty("os.name") + " " + System.getProperty("os.version") + " for " + System.getProperty("os.arch");
        String java_version = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String default_charset = Charset.defaultCharset().name();
        section.addEntry("Operating System", os_version);
        section.addEntry("Java VM", java_version);
        section.addEntry("Default charset", default_charset);
        return section;
    }

    public void show(String[] args) {
        Section manifest;
        boolean stdout = false;
        boolean noManifest = false;
        boolean noDigests = false;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (!stdout && "-stdout".equalsIgnoreCase(arg)) {
                    stdout = true;
                    continue;
                }
                if (!noManifest && "-noManifest".equalsIgnoreCase(arg)) {
                    noManifest = true;
                    continue;
                }
                if (noDigests || !"-noDigests".equalsIgnoreCase(arg)) continue;
                noDigests = true;
            }
        }
        Section section = noManifest ? null : (manifest = this.getManifest(!noDigests));
        if (!stdout) {
            try {
                this.printToWindow(manifest);
                return;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.printTo(new PrintWriter(new BufferedOutputStream(System.out)), manifest);
    }

    private String center(String str) {
        int i;
        int l1 = (HR.length() - 2 - str.length()) / 2;
        int l2 = l1 + str.length();
        int l3 = HR.length() - 2;
        StringBuilder sb = new StringBuilder(HR.length());
        sb.append('|');
        for (i = 0; i < l1; ++i) {
            sb.append(' ');
        }
        sb.append(str);
        for (i = l2; i < l3; ++i) {
            sb.append(' ');
        }
        sb.append('|');
        return sb.toString();
    }

    public void printTo(PrintWriter out) {
        this.printTo(out, this.getManifest(true));
    }

    private void printTo(PrintWriter out, Section manifest) {
        int i;
        out.println(HR);
        out.println(this.center(this.m_product_name));
        out.println(this.center(this.m_copyright));
        out.println(this.center("Version Information"));
        out.println(HR);
        out.flush();
        Iterator<Section> it = this.m_sections.iterator();
        int maxlen = 0;
        while (it.hasNext()) {
            Section section = it.next();
            for (i = 0; i < section.getNumEntries(); ++i) {
                maxlen = Math.max(maxlen, section.getEntryName(i).length());
            }
        }
        maxlen += 4;
        for (Section section : this.m_sections) {
            out.println(section.getTitle() + ":");
            for (i = 0; i < section.getNumEntries(); ++i) {
                String name = section.getEntryName(i);
                int padding = maxlen - name.length();
                out.print(" " + name + ":");
                for (int j = 0; j < padding; ++j) {
                    out.print(" ");
                }
                out.println(section.getEntryValue(i));
            }
            out.flush();
        }
        out.println(HR);
        out.flush();
        if (manifest == null || manifest.getNumEntries() == 0) {
            return;
        }
        out.println(this.center(manifest.getTitle()));
        out.println(HR);
        out.flush();
        for (i = 0; i < manifest.getNumEntries(); ++i) {
            out.println(manifest.getEntryName(i) + ": " + manifest.getEntryValue(i));
        }
        out.println(HR);
        out.flush();
    }

    private void printToWindow(Section manifest) throws Exception {
        TextArea text;
        Font title_font = new Font("Helvetica", 1, 16);
        Font header_font = new Font("Helvetica", 1, 14);
        Font normal_font = new Font("Helvetica", 0, 12);
        Frame frame = new Frame(this.m_product_name);
        class WindowHandler
        extends WindowAdapter {
            WindowHandler() {
            }

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        }
        frame.addWindowListener(new WindowHandler());
        frame.setBackground(m_white);
        frame.setFont(title_font);
        GridBagConstraints c0 = new GridBagConstraints();
        c0.fill = 1;
        c0.weightx = 0.0;
        c0.gridwidth = 0;
        c0.gridheight = 1;
        c0.insets = new Insets(0, 0, 0, 0);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 1;
        c1.weightx = 1.0;
        c1.anchor = 17;
        c1.gridheight = 1;
        c1.insets = new Insets(0, 0, 0, 0);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        c2.weightx = 1.0;
        c2.gridwidth = 0;
        c2.anchor = 17;
        c2.gridheight = 1;
        c2.insets = new Insets(0, 0, 0, 0);
        GridBagLayout layout = new GridBagLayout();
        Panel panel = new Panel(layout);
        frame.add((Component)panel, "Center");
        Picture picture = new Picture(father_son_gif, 1);
        panel.add(picture);
        picture.setBackground(m_grey);
        layout.setConstraints(picture, c1);
        c2.anchor = 11;
        picture = new Picture(slogan_gif, 1);
        panel.add(picture);
        layout.setConstraints(picture, c2);
        c2.anchor = 17;
        Label label = new Label("   ", 1);
        panel.add(label);
        label.setFont(header_font);
        label.setBackground(m_orange);
        layout.setConstraints(label, c1);
        label = new Label(this.m_product_name, 1);
        panel.add(label);
        label.setFont(title_font);
        label.setForeground(m_grey);
        label.setBackground(m_orange);
        layout.setConstraints(label, c2);
        label = new Label("   ", 0);
        panel.add(label);
        label.setBackground(m_grey);
        layout.setConstraints(label, c1);
        label = new Label(this.m_copyright, 1);
        panel.add(label);
        label.setFont(normal_font);
        label.setForeground(m_grey);
        layout.setConstraints(label, c2);
        for (Section section : this.m_sections) {
            label = new Label(" " + section.getTitle(), 0);
            panel.add(label);
            label.setFont(header_font);
            label.setBackground(m_grey);
            label.setForeground(m_white);
            layout.setConstraints(label, c1);
            label = new Label(" ", 0);
            panel.add(label);
            layout.setConstraints(label, c2);
            label.setBackground(m_white);
            label.setForeground(m_grey);
            for (int i = 0; i < section.getNumEntries(); ++i) {
                String name = section.getEntryName(i);
                String value = section.getEntryValue(i);
                label = new Label("   " + name + ":", 0);
                panel.add(label);
                label.setFont(normal_font);
                label.setBackground(m_grey);
                label.setForeground(m_white);
                layout.setConstraints(label, c1);
                if (value.length() <= 100) {
                    label = new Label(value, 0);
                    panel.add(label);
                    label.setFont(normal_font);
                    label.setBackground(m_white);
                    label.setForeground(m_grey);
                    layout.setConstraints(label, c2);
                    continue;
                }
                text = new TextArea(value, 4, 1, 1);
                panel.add(text);
                layout.setConstraints(text, c2);
                text.setFont(normal_font);
                text.setBackground(m_white);
                text.setForeground(m_grey);
                text.setEditable(false);
            }
        }
        if (manifest != null && manifest.getNumEntries() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < manifest.getNumEntries(); ++i) {
                sb.append(manifest.getEntryName(i));
                sb.append(": ");
                sb.append(manifest.getEntryValue(i));
                sb.append('\n');
            }
            label = new Label(" " + manifest.getTitle(), 0);
            panel.add(label);
            label.setFont(header_font);
            label.setBackground(m_grey);
            label.setForeground(m_white);
            layout.setConstraints(label, c1);
            label = new Label(" ", 0);
            panel.add(label);
            label.setBackground(m_white);
            label.setForeground(m_grey);
            layout.setConstraints(label, c2);
            label = new Label("   ", 0);
            panel.add(label);
            label.setFont(header_font);
            label.setBackground(m_grey);
            label.setForeground(m_white);
            layout.setConstraints(label, c1);
            text = new TextArea(sb.toString());
            panel.add(text);
            layout.setConstraints(text, c2);
            text.setFont(normal_font);
            text.setBackground(m_white);
            text.setForeground(m_grey);
            text.setEditable(false);
        }
        panel = new Panel(new FlowLayout());
        panel.setBackground(m_orange);
        frame.add((Component)panel, "South");
        Button button = new Button(" Close ");
        button.setBackground(m_grey);
        button.setForeground(m_white);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        frame.setResizable(false);
        frame.pack();
        frame.setSize(frame.getPreferredSize());
        frame.setVisible(true);
    }

    private static class Picture
    extends Component {
        private static final long serialVersionUID = 1000L;
        public static final byte CENTER = 1;
        public static final byte RIGHT = 2;
        Image m_image;
        byte m_alignment;

        private Image createImage(Component comp, long[] ldata) {
            if (ldata == null) {
                return null;
            }
            byte[] data = new byte[ldata.length * 8];
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(ldata[i / 8] >> (7 - i % 8) * 8 & 0xFFL);
            }
            MediaTracker tracker = new MediaTracker(comp);
            Image image = Toolkit.getDefaultToolkit().createImage(data);
            tracker.addImage(image, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException e) {
                return null;
            }
            tracker.removeImage(image, 0);
            return image;
        }

        public Picture(long[] data, byte alignment) {
            this.m_image = this.createImage(this, data);
            this.m_alignment = alignment;
            this.setSize(this.m_image.getWidth(null), this.m_image.getHeight(null));
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.m_image.getWidth(null), this.m_image.getHeight(null));
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            int x = 0;
            int y = 0;
            if (this.m_alignment == 1) {
                x = (this.getSize().width - this.m_image.getWidth(null)) / 2;
            } else if (this.m_alignment == 2) {
                x = this.getSize().width - this.m_image.getWidth(null);
            }
            g.drawImage(this.m_image, x, y, this);
        }
    }

    public static class Section {
        String m_title;
        ArrayList<NamedValuePair> m_entries = new ArrayList();

        public Section(String title) {
            this.m_title = title;
        }

        public void addEntry(String name, String value) {
            this.m_entries.add(new NamedValuePair(name, value));
        }

        public String getTitle() {
            return this.m_title != null ? this.m_title : "";
        }

        public int getNumEntries() {
            return this.m_entries.size();
        }

        public String getEntryName(int index) {
            return this.m_entries.get(index).getName();
        }

        public String getEntryValue(int index) {
            return this.m_entries.get(index).getValue();
        }
    }

    protected static class NamedValuePair {
        String m_name;
        String m_value;

        public NamedValuePair(String name, String value) {
            this.m_name = name != null ? name : "";
            this.m_value = value != null ? value : "";
        }

        public String getName() {
            return this.m_name;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

