/*
 * Decompiled with CFR 0.152.
 */
package cn.gitlab.virtualcry.sapjco.spring.boot.autoconfigure;

import cn.gitlab.virtualcry.sapjco.beans.factory.JCoConnectionFactory;
import cn.gitlab.virtualcry.sapjco.config.JCoSettings;
import cn.gitlab.virtualcry.sapjco.server.JCoServer;
import cn.gitlab.virtualcry.sapjco.spring.boot.autoconfigure.JCoConnectionProperties;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={JCoConnectionProperties.class})
public class JCoConnectionAutoConfiguration
implements InitializingBean {
    private final JCoConnectionProperties properties;
    private final JCoConnectionFactory connectionFactory;
    private final BiConsumer<JCoConnectionFactory, Map<String, JCoSettings>> createServerConnections = (connectionFactory, connectionProperties) -> connectionProperties.entrySet().stream().map(entry -> connectionFactory.createServer((String)entry.getKey(), (JCoSettings)entry.getValue())).collect(Collectors.toList()).forEach(JCoServer::start);
    private final BiConsumer<JCoConnectionFactory, Map<String, JCoSettings>> createClientConnections = (connectionFactory, connectionProperties) -> connectionProperties.forEach((arg_0, arg_1) -> ((JCoConnectionFactory)connectionFactory).createClient(arg_0, arg_1));

    public JCoConnectionAutoConfiguration(JCoConnectionProperties properties, JCoConnectionFactory connectionFactory2) {
        this.properties = properties;
        this.connectionFactory = connectionFactory2;
    }

    public void afterPropertiesSet() {
        this.createServerConnections.accept(this.connectionFactory, this.properties.getServers());
        this.createClientConnections.accept(this.connectionFactory, this.properties.getClients());
    }
}

