/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlachenal.sql;

import com.github.vlachenal.sql.ClauseMaker;
import com.github.vlachenal.sql.ClausesProvider;
import com.github.vlachenal.sql.SQL;
import com.github.vlachenal.sql.SQLQuery;
import com.github.vlachenal.sql.SelectBuilder;
import com.github.vlachenal.sql.ValueChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class ClausesBuilder {
    final StringBuilder buffer;
    final List<Object> values;
    boolean firstClause = true;

    public ClausesBuilder() {
        this.buffer = new StringBuilder();
        this.values = new ArrayList<Object>();
    }

    public ClausesBuilder(ClausesBuilder other) {
        this.buffer = new StringBuilder(other.buffer);
        this.values = new ArrayList<Object>(other.values);
        this.firstClause = other.firstClause;
    }

    public <T> ClausesBuilder(ClauseMaker clause, T value) {
        this();
        this.checkAndAddClause(null, null, clause, value, SQL::isValidValue);
    }

    public <T> ClausesBuilder(ClauseMaker clause, T value, ValueChecker<T> checker) {
        this();
        this.checkAndAddClause(null, null, clause, value, checker);
    }

    public <T> ClausesBuilder(String column, ClauseMaker clause, T value) {
        this();
        this.checkAndAddClause(null, column, clause, value, SQL::isValidValue);
    }

    public <T> ClausesBuilder(String column, ClauseMaker clause, T value, ValueChecker<T> checker) {
        this();
        this.checkAndAddClause(null, column, clause, value, checker);
    }

    public <T> ClausesBuilder(String column, ClauseMaker clause, T value1, T value2) {
        this();
        this.checkAndAddClause(null, column, clause, value1, value2, SQL::isValidValue);
    }

    public <T> ClausesBuilder(String column, ClauseMaker clause, T value1, T value2, ValueChecker<T> checker) {
        this();
        this.checkAndAddClause(null, column, clause, value1, value2, checker);
    }

    public ClausesBuilder field(String column) {
        this.buffer.append(column);
        this.firstClause = false;
        return this;
    }

    public ClausesBuilder not(ClausesBuilder clauses) {
        this.buffer.append("NOT (").append((CharSequence)clauses.buffer).append(')');
        this.values.addAll(clauses.values);
        return this;
    }

    public ClausesBuilder isNull() {
        this.buffer.append(" IS NULL");
        return this;
    }

    public ClausesBuilder isNotNull() {
        this.buffer.append(" IS NOT NULL");
        return this;
    }

    public ClausesBuilder notEquals() {
        this.buffer.append(" <> ");
        return this;
    }

    public ClausesBuilder equals() {
        this.buffer.append(" = ");
        return this;
    }

    public ClausesBuilder notExists(SelectBuilder query) {
        this.buffer.append("NOT EXISTS(").append(query).append(')');
        this.values.addAll(query.values);
        return this;
    }

    public ClausesBuilder exists(SelectBuilder query) {
        this.buffer.append("EXISTS(").append(query).append(')');
        this.values.addAll(query.values);
        return this;
    }

    public <T> ClausesBuilder in(Collection<T> values) {
        this.buffer.append(" IN ").append(SQL.toSQLList(values));
        return this;
    }

    public <T> ClausesBuilder notIn(Collection<T> values) {
        this.buffer.append(" NOT IN ").append(SQL.toSQLList(values));
        return this;
    }

    public ClausesBuilder in(SQLQuery query) {
        this.buffer.append(" IN (").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder notIn(SQLQuery query) {
        this.buffer.append(" NOT IN (").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder in(SelectBuilder query) {
        this.buffer.append(" IN (").append(query).append(')');
        return this;
    }

    public ClausesBuilder notIn(SelectBuilder query) {
        this.buffer.append(" NOT IN (").append(query).append(')');
        return this;
    }

    public ClausesBuilder greater() {
        this.buffer.append(" > ");
        return this;
    }

    public ClausesBuilder greaterEquals() {
        this.buffer.append(" >= ");
        return this;
    }

    public ClausesBuilder lesser() {
        this.buffer.append(" < ");
        return this;
    }

    public ClausesBuilder lesserEquals() {
        this.buffer.append(" <= ");
        return this;
    }

    public ClausesBuilder like() {
        this.buffer.append(" LIKE ");
        return this;
    }

    public ClausesBuilder notLike() {
        this.buffer.append(" NOT LIKE ");
        return this;
    }

    public ClausesBuilder between() {
        this.buffer.append(" BETWEEN ");
        return this;
    }

    public ClausesBuilder notBetween() {
        this.buffer.append(" NOT BETWEEN ");
        return this;
    }

    public ClausesBuilder and() {
        this.buffer.append(" AND ");
        return this;
    }

    public ClausesBuilder or() {
        this.buffer.append(" OR ");
        return this;
    }

    public ClausesBuilder equalsAny(SQLQuery query) {
        this.buffer.append(" = any(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder notEqualsAny(SQLQuery query) {
        this.buffer.append(" <> any(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder lesserAny(SQLQuery query) {
        this.buffer.append(" < any(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder lesserEqualsAny(SQLQuery query) {
        this.buffer.append(" <= any(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder greaterAny(SQLQuery query) {
        this.buffer.append(" > any(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder greaterEqualsAny(SQLQuery query) {
        this.buffer.append(" >= any(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder equalsAny(SelectBuilder query) {
        this.buffer.append(" = any(").append(query).append(')');
        return this;
    }

    public ClausesBuilder notEqualsAny(SelectBuilder query) {
        this.buffer.append(" <> any(").append(query).append(')');
        return this;
    }

    public ClausesBuilder lesserAny(SelectBuilder query) {
        this.buffer.append(" < any(").append(query).append(')');
        return this;
    }

    public ClausesBuilder lesserEqualsAny(SelectBuilder query) {
        this.buffer.append(" <= any(").append(query).append(')');
        return this;
    }

    public ClausesBuilder greaterAny(SelectBuilder query) {
        this.buffer.append(" > any(").append(query).append(')');
        return this;
    }

    public ClausesBuilder greaterEqualsAny(SelectBuilder query) {
        this.buffer.append(" >= any(").append(query).append(')');
        return this;
    }

    public ClausesBuilder equalsAll(SQLQuery query) {
        this.buffer.append(" = all(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder notEqualsAll(SQLQuery query) {
        this.buffer.append(" <> all(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder lesserAll(SQLQuery query) {
        this.buffer.append(" < all(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder lesserEqualsAll(SQLQuery query) {
        this.buffer.append(" <= all(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder greaterAll(SQLQuery query) {
        this.buffer.append(" > all(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder greaterEqualsAll(SQLQuery query) {
        this.buffer.append(" >= all(").append(query.getQuery()).append(')');
        return this;
    }

    public ClausesBuilder equalsAll(SelectBuilder query) {
        this.buffer.append(" = all(").append(query).append(')');
        return this;
    }

    public ClausesBuilder notEqualsAll(SelectBuilder query) {
        this.buffer.append(" <> all(").append(query).append(')');
        return this;
    }

    public ClausesBuilder lesserAll(SelectBuilder query) {
        this.buffer.append(" < all(").append(query).append(')');
        return this;
    }

    public ClausesBuilder lesserEqualsAll(SelectBuilder query) {
        this.buffer.append(" <= all(").append(query).append(')');
        return this;
    }

    public ClausesBuilder greaterAll(SelectBuilder query) {
        this.buffer.append(" > all(").append(query).append(')');
        return this;
    }

    public ClausesBuilder greaterEqualsAll(SelectBuilder query) {
        this.buffer.append(" >= all(").append(query).append(')');
        return this;
    }

    public ClausesBuilder and(ClausesProvider clauses) {
        return this.checkAndAddClauses("AND", clauses);
    }

    public <T> ClausesBuilder and(ClauseMaker clause, T value) {
        return this.checkAndAddClause("AND", null, clause, value, SQL::isValidValue);
    }

    public <T> ClausesBuilder and(ClauseMaker clause, T value, ValueChecker<T> checker) {
        return this.checkAndAddClause("AND", null, clause, value, checker);
    }

    public <T> ClausesBuilder and(String column, ClauseMaker clause, T value) {
        return this.checkAndAddClause("AND", column, clause, value, SQL::isValidValue);
    }

    public <T> ClausesBuilder and(String column, ClauseMaker clause, T value, ValueChecker<T> checker) {
        return this.checkAndAddClause("AND", column, clause, value, checker);
    }

    public <T> ClausesBuilder and(String column, ClauseMaker clause, T value1, T value2) {
        return this.checkAndAddClause("AND", column, clause, value1, value2, SQL::isValidValue);
    }

    public <T> ClausesBuilder and(String column, ClauseMaker clause, T value1, T value2, ValueChecker<T> checker) {
        return this.checkAndAddClause("AND", column, clause, value1, value2, checker);
    }

    public <T> ClausesBuilder or(ClauseMaker clause, T value) {
        return this.checkAndAddClause("OR", null, clause, value, SQL::isValidValue);
    }

    public <T> ClausesBuilder or(ClauseMaker clause, T value, ValueChecker<T> checker) {
        return this.checkAndAddClause("OR", null, clause, value, checker);
    }

    public <T> ClausesBuilder or(String column, ClauseMaker clause, T value) {
        return this.checkAndAddClause("OR", column, clause, value, SQL::isValidValue);
    }

    public <T> ClausesBuilder or(String column, ClauseMaker clause, T value, ValueChecker<T> checker) {
        return this.checkAndAddClause("OR", column, clause, value, checker);
    }

    public <T> ClausesBuilder or(String column, ClauseMaker clause, T value1, T value2) {
        return this.checkAndAddClause("OR", column, clause, value1, value2, SQL::isValidValue);
    }

    public <T> ClausesBuilder or(String column, ClauseMaker clause, T value1, T value2, ValueChecker<T> checker) {
        return this.checkAndAddClause("OR", column, clause, value1, value2, checker);
    }

    public ClausesBuilder or(ClausesProvider clauses) {
        return this.checkAndAddClauses("OR", clauses);
    }

    private void addBooleanAggregator(String boolAgg) {
        if (!this.firstClause) {
            this.buffer.append(' ').append(boolAgg).append(' ');
        }
    }

    private ClausesBuilder checkAndAddClauses(String boolAgg, ClausesProvider clauses) {
        ClausesBuilder builder = clauses.getClauses();
        if (builder != null && builder.buffer.length() != 0) {
            this.addBooleanAggregator(boolAgg);
            this.buffer.append((CharSequence)builder.buffer);
            this.values.addAll(builder.values);
            this.firstClause = false;
        }
        return this;
    }

    private final <T> ClausesBuilder checkAndAddClause(String boolAgg, String column, ClauseMaker clause, T value, ValueChecker<T> checker) {
        if (checker.isValid(value)) {
            this.addBooleanAggregator(boolAgg);
            this.buffer.append(clause.makeClause(column));
            if (value instanceof Optional) {
                this.values.add(((Optional)value).get());
            } else if (value instanceof Collection) {
                this.buffer.append(SQL.toSQLList((Collection)value));
            } else if (value instanceof SelectBuilder) {
                this.buffer.append('(').append(value).append(')');
                this.values.addAll(((SelectBuilder)value).values);
            } else if (value instanceof SQLQuery) {
                SQLQuery query = (SQLQuery)value;
                this.buffer.append('(').append(query.getQuery()).append(')');
                this.values.addAll(query.getValues());
            } else {
                this.values.add(value);
            }
            this.firstClause = false;
        }
        return this;
    }

    private final <T> ClausesBuilder checkAndAddClause(String boolAgg, String column, ClauseMaker clause, T value1, T value2, ValueChecker<T> checker) {
        if (checker.isValid(value1) && checker.isValid(value2)) {
            this.addBooleanAggregator(boolAgg);
            this.buffer.append(clause.makeClause(column));
            if (value1 instanceof Optional) {
                this.values.add(((Optional)value1).get());
            } else {
                this.values.add(value1);
            }
            if (value2 instanceof Optional) {
                this.values.add(((Optional)value2).get());
            } else {
                this.values.add(value2);
            }
            this.firstClause = false;
        }
        return this;
    }

    private ClausesBuilder checkAndAddClauses(String boolAgg, ClausesBuilder other) {
        if (!other.firstClause) {
            this.addBooleanAggregator(boolAgg);
            this.buffer.append('(').append((CharSequence)other.buffer).append(')');
            this.values.addAll(other.values);
            this.firstClause = false;
        }
        return this;
    }

    public ClausesBuilder and(ClausesBuilder other) {
        return this.checkAndAddClauses("AND", other);
    }

    public ClausesBuilder or(ClausesBuilder other) {
        return this.checkAndAddClauses("OR", other);
    }
}

