/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlachenal.sql;

import com.github.vlachenal.sql.AbstractPartBuilder;
import com.github.vlachenal.sql.ClausesBuilder;
import com.github.vlachenal.sql.SQLQuery;
import com.github.vlachenal.sql.SelectBuilder;

public class FromBuilder
extends AbstractPartBuilder {
    public FromBuilder(SelectBuilder select, String table) {
        super(select);
        select.buffer.append(" FROM ").append(table);
    }

    public FromBuilder(SelectBuilder select, SelectBuilder subquery) {
        super(select);
        select.buffer.append(" FROM (").append(subquery).append(')');
        select.values.addAll(subquery.values);
    }

    public FromBuilder(SelectBuilder select, SQLQuery subquery) {
        super(select);
        select.buffer.append(" FROM (").append(subquery.getQuery()).append(')');
        select.values.addAll(subquery.getValues());
    }

    public FromBuilder(SelectBuilder select, SelectBuilder subquery, String alias) {
        this(select, subquery);
        select.buffer.append(' ').append(alias);
    }

    public FromBuilder(SelectBuilder select, SQLQuery subquery, String alias) {
        this(select, subquery);
        select.buffer.append(' ').append(alias);
    }

    public FromBuilder selfJoin(String table) {
        this.select.buffer.append(',').append(table);
        return this;
    }

    public FromBuilder selfJoin(SQLQuery subquery, String alias) {
        this.addJoin(",", subquery, alias);
        return this;
    }

    public FromBuilder selfJoin(SelectBuilder subquery, String alias) {
        this.addJoin(",", subquery, alias);
        return this;
    }

    public FromBuilder join(String table, ClausesBuilder clauses) {
        return this.innerJoin(table, clauses);
    }

    public FromBuilder join(SQLQuery subquery, String alias, ClausesBuilder clauses) {
        return this.innerJoin(subquery, alias, clauses);
    }

    public FromBuilder join(SelectBuilder subquery, String alias, ClausesBuilder clauses) {
        return this.innerJoin(subquery, alias, clauses);
    }

    public FromBuilder innerJoin(String table, ClausesBuilder clauses) {
        this.addJoin(" INNER JOIN ", table, clauses);
        return this;
    }

    public FromBuilder innerJoin(SQLQuery subquery, String alias, ClausesBuilder clauses) {
        this.addJoin(" INNER JOIN ", subquery, alias, clauses);
        return this;
    }

    public FromBuilder innerJoin(SelectBuilder subquery, String alias, ClausesBuilder clauses) {
        this.addJoin(" INNER JOIN ", subquery, alias, clauses);
        return this;
    }

    public FromBuilder leftJoin(String table, ClausesBuilder clauses) {
        return this.leftOuterJoin(table, clauses);
    }

    public FromBuilder leftJoin(SQLQuery subquery, String alias, ClausesBuilder clauses) {
        return this.leftOuterJoin(subquery, alias, clauses);
    }

    public FromBuilder leftJoin(SelectBuilder subquery, String alias, ClausesBuilder clauses) {
        return this.leftOuterJoin(subquery, alias, clauses);
    }

    public FromBuilder leftOuterJoin(String table, ClausesBuilder clauses) {
        this.addJoin(" LEFT OUTER JOIN ", table, clauses);
        return this;
    }

    public FromBuilder leftOuterJoin(SQLQuery subquery, String alias, ClausesBuilder clauses) {
        this.addJoin(" LEFT OUTER JOIN ", subquery, alias, clauses);
        return this;
    }

    public FromBuilder leftOuterJoin(SelectBuilder subquery, String alias, ClausesBuilder clauses) {
        this.addJoin(" LEFT OUTER JOIN ", subquery, alias, clauses);
        return this;
    }

    public FromBuilder rightJoin(String table, ClausesBuilder clauses) {
        return this.rightOuterJoin(table, clauses);
    }

    public FromBuilder rightJoin(SQLQuery subquery, String alias, ClausesBuilder clauses) {
        return this.rightOuterJoin(subquery, alias, clauses);
    }

    public FromBuilder rightJoin(SelectBuilder subquery, String alias, ClausesBuilder clauses) {
        return this.rightOuterJoin(subquery, alias, clauses);
    }

    public FromBuilder rightOuterJoin(String table, ClausesBuilder clauses) {
        this.addJoin(" RIGHT OUTER JOIN ", table, clauses);
        return this;
    }

    public FromBuilder rightOuterJoin(SQLQuery subquery, String alias, ClausesBuilder clauses) {
        this.addJoin(" RIGHT OUTER JOIN ", subquery, alias, clauses);
        return this;
    }

    public FromBuilder rightOuterJoin(SelectBuilder subquery, String alias, ClausesBuilder clauses) {
        this.addJoin(" RIGHT OUTER JOIN ", subquery, alias, clauses);
        return this;
    }

    public FromBuilder fullJoin(String table, ClausesBuilder clauses) {
        return this.fullOuterJoin(table, clauses);
    }

    public FromBuilder fullJoin(SQLQuery subquery, String alias, ClausesBuilder clauses) {
        return this.fullOuterJoin(subquery, alias, clauses);
    }

    public FromBuilder fullJoin(SelectBuilder subquery, String alias, ClausesBuilder clauses) {
        return this.fullOuterJoin(subquery, alias, clauses);
    }

    public FromBuilder fullOuterJoin(String table, ClausesBuilder clauses) {
        this.addJoin(" FULL OUTER JOIN ", table, clauses);
        return this;
    }

    public FromBuilder fullOuterJoin(SQLQuery subquery, String alias, ClausesBuilder clauses) {
        this.addJoin(" FULL OUTER JOIN ", subquery, alias, clauses);
        return this;
    }

    public FromBuilder fullOuterJoin(SelectBuilder subquery, String alias, ClausesBuilder clauses) {
        this.addJoin(" FULL OUTER JOIN ", subquery, alias, clauses);
        return this;
    }

    public FromBuilder naturalJoin(String table) {
        this.select.buffer.append(" NATURAL JOIN ").append(table);
        return this;
    }

    public FromBuilder naturalJoin(SelectBuilder subquery, String alias) {
        this.addJoin(" NATURAL JOIN ", subquery, alias);
        return this;
    }

    public FromBuilder naturalJoin(SQLQuery subquery, String alias) {
        this.addJoin(" NATURAL JOIN ", subquery, alias);
        return this;
    }

    public FromBuilder crossJoin(String table) {
        this.select.buffer.append(" CROSS JOIN ").append(table);
        return this;
    }

    public FromBuilder crossJoin(SelectBuilder subquery, String alias) {
        this.addJoin(" CROSS JOIN ", subquery, alias);
        return this;
    }

    public FromBuilder crossJoin(SQLQuery subquery, String alias) {
        this.addJoin(" CROSS JOIN ", subquery, alias);
        return this;
    }

    private void addJoin(String join, SelectBuilder subquery, String alias) {
        this.select.buffer.append(join).append('(').append(subquery).append(") ").append(alias);
        this.select.values.addAll(subquery.values);
    }

    private void addJoin(String join, SQLQuery subquery, String alias) {
        this.select.buffer.append(join).append('(').append(subquery.getQuery()).append(") ").append(alias);
        this.select.values.addAll(subquery.getValues());
    }

    private void addJoin(String join, String table, ClausesBuilder clauses) {
        if (!clauses.firstClause) {
            this.select.buffer.append(join).append(table).append(" ON ").append((CharSequence)clauses.buffer);
            this.select.values.addAll(clauses.values);
        }
    }

    private void addJoin(String join, SelectBuilder subquery, String alias, ClausesBuilder clauses) {
        if (!clauses.firstClause) {
            this.select.buffer.append(join).append('(').append(subquery).append(") ").append(alias).append(" ON ").append((CharSequence)clauses.buffer);
            this.select.values.addAll(subquery.values);
            this.select.values.addAll(clauses.values);
        }
    }

    private void addJoin(String join, SQLQuery subquery, String alias, ClausesBuilder clauses) {
        if (!clauses.firstClause) {
            this.select.buffer.append(join).append('(').append(subquery.getQuery()).append(") ").append(alias).append(" ON ").append((CharSequence)clauses.buffer);
            this.select.values.addAll(subquery.getValues());
            this.select.values.addAll(clauses.values);
        }
    }

    public SelectBuilder where(ClausesBuilder clauses) {
        if (!clauses.firstClause) {
            this.select.buffer.append(" WHERE ").append((CharSequence)clauses.buffer);
            this.select.values.addAll(clauses.values);
        }
        return this.select;
    }
}

