/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlachenal.sql;

import com.github.vlachenal.sql.ClauseMaker;
import com.github.vlachenal.sql.ClausesBuilder;
import com.github.vlachenal.sql.DeleteBuilder;
import com.github.vlachenal.sql.SelectBuilder;
import com.github.vlachenal.sql.UpdateBuilder;
import com.github.vlachenal.sql.ValueChecker;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SQL {
    private SQL() {
    }

    public static SelectBuilder select() {
        return new SelectBuilder();
    }

    public static UpdateBuilder update(String table) {
        return new UpdateBuilder(table);
    }

    public static DeleteBuilder delete(String table) {
        return new DeleteBuilder(table);
    }

    public static ClausesBuilder clauses() {
        return new ClausesBuilder();
    }

    public static ClausesBuilder clauses(ClausesBuilder other) {
        return new ClausesBuilder(other);
    }

    public static <T> ClausesBuilder clauses(ClauseMaker clause, T value) {
        return new ClausesBuilder(clause, value);
    }

    public static <T> ClausesBuilder clauses(ClauseMaker clause, T value, ValueChecker<T> checker) {
        return new ClausesBuilder(clause, value, checker);
    }

    public static <T> ClausesBuilder clauses(String column, ClauseMaker clause, T value) {
        return new ClausesBuilder(column, clause, value);
    }

    public static <T> ClausesBuilder clauses(String column, ClauseMaker clause, T value, ValueChecker<T> checker) {
        return new ClausesBuilder(column, clause, value, checker);
    }

    public static <T> ClausesBuilder clauses(String column, ClauseMaker clause, T value1, T value2) {
        return new ClausesBuilder(column, clause, value1, value2);
    }

    public static <T> ClausesBuilder clauses(String column, ClauseMaker clause, T value1, T value2, ValueChecker<T> checker) {
        return new ClausesBuilder(column, clause, value1, value2, checker);
    }

    public static String formatText(Object value) {
        String text = null;
        if (value != null) {
            text = "'" + value.toString() + "'";
        }
        return text;
    }

    public static List<String> formatText(Collection<?> values) {
        List texts = null;
        if (values != null) {
            texts = values.stream().map(SQL::formatText).collect(Collectors.toList());
        }
        return texts;
    }

    public static <T> String toSQLList(Collection<T> values) {
        StringBuilder buffer = new StringBuilder("(");
        StringBuilder buf = new StringBuilder();
        for (T val : values) {
            buf.append(',').append(val);
        }
        buffer.append(buf.substring(1)).append(')');
        return buffer.toString();
    }

    public static <T> boolean isValidValue(T value) {
        boolean valid = false;
        if (value != null) {
            valid = value instanceof Optional ? ((Optional)value).isPresent() : (value instanceof Collection ? !((Collection)value).isEmpty() : (value instanceof String ? !((String)value).isEmpty() : true));
        }
        return valid;
    }
}

