/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlachenal.sql;

import com.github.vlachenal.sql.ClausesBuilder;
import com.github.vlachenal.sql.FieldsBuilder;
import com.github.vlachenal.sql.SQLQuery;
import java.util.ArrayList;
import java.util.List;

public class SelectBuilder {
    final StringBuilder buffer = new StringBuilder("SELECT ");
    final List<Object> values = new ArrayList<Object>();

    public SelectBuilder distinct() {
        this.buffer.append("DISTINCT ");
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public FieldsBuilder field(String column) {
        return new FieldsBuilder(this, column);
    }

    public FieldsBuilder groupBy(String column) {
        this.buffer.append(" GROUP BY ");
        return new FieldsBuilder(this, column);
    }

    public FieldsBuilder orderBy(String column) {
        this.buffer.append(" ORDER BY ");
        return new FieldsBuilder(this, column);
    }

    public SelectBuilder having(ClausesBuilder clauses) {
        if (!clauses.firstClause) {
            this.buffer.append(" HAVING ").append((CharSequence)clauses.buffer);
            this.values.addAll(clauses.values);
        }
        return this;
    }

    public SelectBuilder union(SelectBuilder other) {
        this.buffer.append(" UNION ").append((CharSequence)other.buffer);
        this.values.addAll(other.values);
        return this;
    }

    public SelectBuilder unionAll(SelectBuilder other) {
        this.buffer.append(" UNION ALL ").append((CharSequence)other.buffer);
        this.values.addAll(other.values);
        return this;
    }

    public SelectBuilder offset(long offset) {
        this.buffer.append(" OFFSET ").append(offset).append(" ROWS");
        return this;
    }

    public SelectBuilder fetchNext(long limit) {
        this.buffer.append(" FETCH NEXT ").append(limit).append(" ROWS ONLY");
        return this;
    }

    public SelectBuilder fetch(long limit) {
        this.buffer.append(" FETCH FIRST ").append(limit).append(" ROWS ONLY");
        return this;
    }

    public SelectBuilder limitOffset(long limit, long offset) {
        if (limit < 1L) {
            return this;
        }
        this.buffer.append(" LIMIT ").append(limit);
        if (offset > 0L) {
            this.buffer.append(" OFFSET ").append(offset);
        }
        return this;
    }

    public SelectBuilder windowByRowNumber(String alias, String rowColumn, String order, int min, int max) {
        this.window("row_number()", alias, rowColumn, order, min, max);
        return this;
    }

    public SelectBuilder windowByRank(String alias, String rowColumn, String order, int min, int max) {
        this.window("rank()", alias, rowColumn, order, min, max);
        return this;
    }

    private void window(String function, String alias, String rowColumn, String order, int min, int max) {
        StringBuilder colBuffer = new StringBuilder();
        colBuffer.append(',').append(function).append(" OVER(ORDER BY ").append(order).append(") AS ").append(rowColumn);
        int idx = this.buffer.indexOf(" FROM");
        this.buffer.insert(idx, colBuffer);
        this.buffer.insert(0, "SELECT * FROM (");
        this.buffer.append(") AS ").append(alias).append(" WHERE");
        if (min > 0) {
            this.buffer.append(' ').append(rowColumn).append(" >= ?");
            this.values.add(min);
        }
        if (max > 1) {
            if (min > 0) {
                this.buffer.append(" AND ");
            } else {
                this.buffer.append(' ');
            }
            this.buffer.append(rowColumn).append(" < ?");
            this.values.add(max);
        }
    }

    public SQLQuery build() {
        return new SQLQuery(this.buffer.toString(), this.values);
    }
}

